/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.scheduler;

import com.sun.tools.visualvm.core.scheduler.DefaultScheduledTask;
import com.sun.tools.visualvm.core.scheduler.Quantum;
import com.sun.tools.visualvm.core.scheduler.ScheduledTask;
import com.sun.tools.visualvm.core.scheduler.SchedulerTask;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(Scheduler.class.getName());
    private static final Scheduler INSTANCE = new Scheduler();
    private final Map<Quantum, Set<WeakReference<DefaultScheduledTask>>> interval2recevier = new HashMap<Quantum, Set<WeakReference<DefaultScheduledTask>>>();
    private final ScheduledExecutorService schedulerService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private final ExecutorService intermediateTaskService = Executors.newCachedThreadPool();
    private final ExecutorService dispatcher = Executors.newCachedThreadPool();

    private Scheduler() {
    }

    public static final Scheduler sharedInstance() {
        return INSTANCE;
    }

    public final ScheduledTask schedule(SchedulerTask task, Quantum interval) {
        return this.schedule(task, interval, true);
    }

    public final ScheduledTask schedule(final SchedulerTask task, Quantum interval, boolean immediate) {
        boolean suspended = interval.equals(Quantum.SUSPENDED);
        if (immediate && !suspended) {
            this.intermediateTaskService.submit(new Runnable(){

                public void run() {
                    task.onSchedule(System.currentTimeMillis());
                }
            });
        }
        DefaultScheduledTask scheduled = new DefaultScheduledTask(interval, task);
        this.add(scheduled, interval);
        return scheduled;
    }

    public final void unschedule(ScheduledTask task) {
        if (task == null) {
            return;
        }
        this.remove((DefaultScheduledTask)task, task.getInterval());
        task.suspend();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DefaultScheduledTask task = (DefaultScheduledTask)evt.getSource();
        this.reschedule(task, (Quantum)evt.getOldValue(), (Quantum)evt.getNewValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(DefaultScheduledTask task, final Quantum interval) {
        if (task == null || interval == null) {
            return;
        }
        Map<Quantum, Set<WeakReference<DefaultScheduledTask>>> map = this.interval2recevier;
        synchronized (map) {
            Set<WeakReference<DefaultScheduledTask>> receivers = this.interval2recevier.get(interval);
            if (receivers == null) {
                HashSet<WeakReference<DefaultScheduledTask>> newReceivers = new HashSet<WeakReference<DefaultScheduledTask>>();
                newReceivers.add(new WeakReference<DefaultScheduledTask>(task));
                this.interval2recevier.put(interval, newReceivers);
                if (!interval.equals(Quantum.SUSPENDED)) {
                    this.schedulerService.scheduleAtFixedRate(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            block12: {
                                try {
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.finest("Notifying scheduled tasks at interval " + interval);
                                    }
                                    long timeStamp = System.currentTimeMillis();
                                    HashSet myReceivers = Collections.EMPTY_SET;
                                    Map map = Scheduler.this.interval2recevier;
                                    synchronized (map) {
                                        myReceivers = new HashSet((Collection)Scheduler.this.interval2recevier.get(interval));
                                        if (LOGGER.isLoggable(Level.FINEST)) {
                                            LOGGER.finest((myReceivers != null ? Integer.valueOf(myReceivers.size()) : "0") + " scheduled tasks for interval " + interval);
                                        }
                                    }
                                    int deadRefCounter = Scheduler.this.notifyReceivers(timeStamp, myReceivers);
                                    if (deadRefCounter > 0) {
                                        Set cleansed = Scheduler.cleanDeadRefs(myReceivers);
                                        Map map2 = Scheduler.this.interval2recevier;
                                        synchronized (map2) {
                                            Scheduler.this.interval2recevier.remove(interval);
                                            Scheduler.this.interval2recevier.put(interval, cleansed);
                                        }
                                    }
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.finest("Finished");
                                    }
                                }
                                catch (Exception e) {
                                    if (!LOGGER.isLoggable(Level.WARNING)) break block12;
                                    LOGGER.log(Level.WARNING, "Exception in scheduler", e);
                                }
                            }
                        }
                    }, interval.interval, interval.interval, interval.unit);
                }
            } else {
                receivers.add(new WeakReference<DefaultScheduledTask>(task));
            }
        }
        task.addPropertyChangeListener("Task.Interval", this);
    }

    private static Set<WeakReference<DefaultScheduledTask>> cleanDeadRefs(Set<WeakReference<DefaultScheduledTask>> tasks) {
        HashSet<WeakReference<DefaultScheduledTask>> newSet = new HashSet<WeakReference<DefaultScheduledTask>>();
        for (WeakReference<DefaultScheduledTask> task : tasks) {
            if (task.get() == null) continue;
            newSet.add(task);
        }
        return newSet;
    }

    private int notifyReceivers(final long timeStamp, Set<WeakReference<DefaultScheduledTask>> myReceivers) {
        int deadRefCounter = 0;
        for (WeakReference<DefaultScheduledTask> rcvRef : myReceivers) {
            final DefaultScheduledTask rcv = (DefaultScheduledTask)rcvRef.get();
            if (rcv == null) {
                ++deadRefCounter;
                continue;
            }
            if (rcv.isSuspended()) continue;
            this.dispatcher.submit(new Runnable(){

                public void run() {
                    rcv.onSchedule(timeStamp);
                }
            });
        }
        return deadRefCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(DefaultScheduledTask task, Quantum interval) {
        task.removePropertyChangeListener("Task.Interval", this);
        Map<Quantum, Set<WeakReference<DefaultScheduledTask>>> map = this.interval2recevier;
        synchronized (map) {
            Set<WeakReference<DefaultScheduledTask>> receivers = this.interval2recevier.get(interval);
            if (receivers != null) {
                int deadRefCounter = 0;
                for (WeakReference<DefaultScheduledTask> rcvRef : receivers) {
                    DefaultScheduledTask rcv = (DefaultScheduledTask)rcvRef.get();
                    if (rcv == null) {
                        ++deadRefCounter;
                        continue;
                    }
                    if (!rcv.equals(task)) continue;
                    rcv.suspend();
                    receivers.remove(rcv);
                    rcv.resume();
                    break;
                }
                if (deadRefCounter > 0) {
                    receivers = Scheduler.cleanDeadRefs(receivers);
                    this.interval2recevier.remove(interval);
                    if (!receivers.isEmpty()) {
                        this.interval2recevier.put(interval, receivers);
                    }
                } else if (receivers.isEmpty()) {
                    this.interval2recevier.remove(interval);
                }
            }
        }
    }

    private void reschedule(final DefaultScheduledTask task, Quantum oldInterval, Quantum newInterval) {
        this.remove(task, oldInterval);
        if (oldInterval.equals(Quantum.SUSPENDED)) {
            this.intermediateTaskService.submit(new Runnable(){

                public void run() {
                    task.onSchedule(System.currentTimeMillis());
                }
            });
        }
        this.add(task, newInterval);
    }
}

