/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.datasource;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceProvider {
    private final Set<DataSource> dataSources = Collections.synchronizedSet(new HashSet());
    private final Map<DataChangeListener<? extends DataSource>, Class<? extends DataSource>> listeners = new HashMap<DataChangeListener<? extends DataSource>, Class<? extends DataSource>>();

    DataSourceProvider() {
    }

    public final <Y extends DataSource> void addDataChangeListener(final DataChangeListener<Y> listener, final Class<Y> scope) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                if (DataSourceProvider.this.listeners.containsKey(listener)) {
                    throw new IllegalArgumentException("Listener " + listener + " already registered");
                }
                DataSourceProvider.this.listeners.put(listener, scope);
                DataSourceProvider.this.fireCurrentState(listener);
            }
        });
    }

    public final <Y extends DataSource> void removeDataChangeListener(final DataChangeListener<Y> listener) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                if (!DataSourceProvider.this.listeners.containsKey(listener)) {
                    throw new IllegalArgumentException("Listener " + listener + " not registered");
                }
                DataSourceProvider.this.listeners.remove(listener);
            }
        });
    }

    public final Set<DataSource> getDataSources() {
        return new HashSet<DataSource>(this.dataSources);
    }

    public final <Y extends DataSource> Set<Y> getDataSources(Class<Y> scope) {
        return Utils.getFilteredSet(this.dataSources, scope);
    }

    protected final void registerDataSource(DataSource added) {
        this.registerDataSources(Collections.singleton(added));
    }

    protected final void registerDataSources(final Set<? extends DataSource> added) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                if (!added.isEmpty()) {
                    DataSourceProvider.this.registerDataSourcesImpl(added);
                }
            }
        });
    }

    protected final void unregisterDataSource(DataSource removed) {
        this.unregisterDataSources(Collections.singleton(removed));
    }

    protected final void unregisterDataSources(final Set<? extends DataSource> removed) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                if (!removed.isEmpty()) {
                    DataSourceProvider.this.unregisterDataSourcesImpl(removed);
                }
            }
        });
    }

    protected final void changeDataSources(final Set<? extends DataSource> added, final Set<? extends DataSource> removed) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                if (!removed.isEmpty()) {
                    DataSourceProvider.this.unregisterDataSourcesImpl(removed);
                }
                if (!added.isEmpty()) {
                    DataSourceProvider.this.registerDataSourcesImpl(added);
                }
            }
        });
    }

    void registerDataSourcesImpl(Set<? extends DataSource> added) {
        for (DataSource dataSource : added) {
            if (!this.dataSources.contains(dataSource)) continue;
            throw new UnsupportedOperationException("DataSource already in repository: " + dataSource);
        }
        this.dataSources.addAll(added);
        this.fireDataAdded(added);
    }

    void unregisterDataSourcesImpl(Set<? extends DataSource> removed) {
        for (DataSource dataSource : removed) {
            if (this.dataSources.contains(dataSource)) continue;
            throw new UnsupportedOperationException("DataSource not in repository: " + dataSource);
        }
        this.dataSources.removeAll(removed);
        this.fireDataRemoved(removed);
    }

    private void fireCurrentState(DataChangeListener<? extends DataSource> listener) {
        this.fireDataChanged(listener, null, null);
    }

    private void fireDataAdded(Set<? extends DataSource> added) {
        this.fireDataChanged(added, Collections.EMPTY_SET);
    }

    private void fireDataRemoved(Set<? extends DataSource> removed) {
        this.fireDataChanged(Collections.EMPTY_SET, removed);
    }

    private void fireDataChanged(Set<? extends DataSource> added, Set<? extends DataSource> removed) {
        Set<DataChangeListener<? extends DataSource>> listenersSet = this.listeners.keySet();
        for (DataChangeListener<? extends DataSource> listener : listenersSet) {
            this.fireDataChanged(listener, added, removed);
        }
    }

    private void fireDataChanged(DataChangeListener<? extends DataSource> listener, Set<? extends DataSource> added, Set<? extends DataSource> removed) {
        Class<? extends DataSource> filter = this.listeners.get(listener);
        Set<? extends DataSource> filteredCurrent = Utils.getFilteredSet(this.dataSources, filter);
        if (added == null && removed == null) {
            DataChangeEvent<? extends DataSource> event = new DataChangeEvent<DataSource>(filteredCurrent, filteredCurrent, null);
            listener.dataChanged(event);
        } else {
            Set<? extends DataSource> filteredRemoved;
            Set<? extends DataSource> filteredAdded = added != null ? Utils.getFilteredSet(added, filter) : Collections.EMPTY_SET;
            Set<? extends DataSource> set = filteredRemoved = removed != null ? Utils.getFilteredSet(removed, filter) : Collections.EMPTY_SET;
            if (!filteredAdded.isEmpty() || !filteredRemoved.isEmpty()) {
                DataChangeEvent<? extends DataSource> event = new DataChangeEvent<DataSource>(filteredCurrent, filteredAdded, filteredRemoved);
                listener.dataChanged(event);
            }
        }
    }
}

