/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.model;

import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.model.HostOverview;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class LocalHostOverview
extends HostOverview {
    OperatingSystemMXBean osMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    boolean loadAverageAvailable = !Utilities.isMac() && this.osMXBean.getSystemLoadAverage() >= 0.0;

    LocalHostOverview() {
    }

    public String getName() {
        return this.osMXBean.getName();
    }

    public String getVersion() {
        return this.osMXBean.getVersion();
    }

    public String getPatchLevel() {
        return System.getProperty("sun.os.patch.level", "");
    }

    public int getAvailableProcessors() {
        return this.osMXBean.getAvailableProcessors();
    }

    public String getArch() {
        String arch = this.osMXBean.getArch();
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            arch = arch + " " + bits + "bit";
        }
        return arch;
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return NbBundle.getMessage(Host.class, (String)"LBL_Unknown");
        }
    }

    public double getSystemLoadAverage() {
        if (this.loadAverageAvailable) {
            return this.osMXBean.getSystemLoadAverage();
        }
        return -1.0;
    }

    public long getTotalPhysicalMemorySize() {
        return this.osMXBean.getTotalPhysicalMemorySize();
    }

    public long getFreePhysicalMemorySize() {
        return this.osMXBean.getFreePhysicalMemorySize();
    }

    public long getTotalSwapSpaceSize() {
        return this.osMXBean.getTotalSwapSpaceSize();
    }

    public long getFreeSwapSpaceSize() {
        return this.osMXBean.getFreeSwapSpaceSize();
    }

    public String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "127.0.0.1";
        }
    }
}

