/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.View;
import sun.tools.jconsole.VMPanel;

public final class SheetDialog {
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    private SheetDialog() {
    }

    static JOptionPane showOptionDialog(VMPanel vMPanel, Object object, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        JRootPane jRootPane = SwingUtilities.getRootPane(vMPanel);
        JPanel jPanel = (JPanel)jRootPane.getGlassPane();
        if (!(jPanel instanceof SlideAndFadeGlassPane)) {
            jPanel = new SlideAndFadeGlassPane();
            jPanel.setName(jRootPane.getName() + ".glassPane");
            jRootPane.setGlassPane(jPanel);
            jRootPane.revalidate();
        }
        final SlideAndFadeGlassPane slideAndFadeGlassPane = (SlideAndFadeGlassPane)jPanel;
        object = SheetDialog.fixWrapping(object, jRootPane.getWidth() - 75);
        final SheetOptionPane sheetOptionPane = new SheetOptionPane(object, n2, n, icon, objectArray, object2);
        sheetOptionPane.setComponentOrientation(vMPanel.getComponentOrientation());
        sheetOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    ((SlideAndFadeGlassPane)sheetOptionPane.getParent()).hide(sheetOptionPane);
                }
            }
        });
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                slideAndFadeGlassPane.show(sheetOptionPane);
            }
        });
        return sheetOptionPane;
    }

    private static Object fixWrapping(Object object, final int n) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = SheetDialog.fixWrapping(objectArray[i], n);
            }
        } else if (object instanceof String && ((String)object).startsWith("<html>")) {
            object = new JLabel((String)object){

                public Dimension getPreferredSize() {
                    String string = this.getText();
                    Insets insets = this.getInsets(viewInsets);
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    Dimension dimension = super.getPreferredSize();
                    Dimension dimension2 = this.getMinimumSize();
                    iconR.height = 0;
                    iconR.width = 0;
                    iconR.y = 0;
                    iconR.x = 0;
                    textR.height = 0;
                    textR.width = 0;
                    textR.y = 0;
                    textR.x = 0;
                    int n4 = insets.left + insets.right;
                    int n2 = insets.top + insets.bottom;
                    viewR.x = n4;
                    viewR.y = n2;
                    viewR.height = Short.MAX_VALUE;
                    viewR.width = Short.MAX_VALUE;
                    View view = (View)this.getClientProperty("html");
                    if (view != null) {
                        int n3 = Math.min(n, Math.min(dimension.width, Math.max(dimension2.width, 300)));
                        view.setSize(n3, 0.0f);
                        SwingUtilities.layoutCompoundLabel(this, fontMetrics, string, null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, this.getIconTextGap());
                        return new Dimension(textR.width + n4, textR.height + n2);
                    }
                    return dimension;
                }
            };
        }
        return object;
    }

    static class SheetOptionPane
    extends JOptionPane {
        private static Composite comp = AlphaComposite.getInstance(3, 0.8f);
        private static Color bgColor = new Color(241, 239, 239);

        SheetOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
            super(object, n, n2, icon, objectArray, object2);
            this.setBorder(new CompoundBorder(new LineBorder(new Color(204, 204, 204), 1), new EmptyBorder(4, 4, 4, 4)));
        }

        public void setVisible(boolean bl) {
            SlideAndFadeGlassPane slideAndFadeGlassPane = (SlideAndFadeGlassPane)this.getParent();
            if (slideAndFadeGlassPane != null) {
                if (bl) {
                    slideAndFadeGlassPane.show(this);
                } else {
                    slideAndFadeGlassPane.hide(this);
                }
            }
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(comp);
            Color color = graphics2D.getColor();
            graphics2D.setColor(bgColor);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
            super.paint(graphics);
        }
    }

    private static class SlideAndFadeGlassPane
    extends JPanel {
        SheetOptionPane optionPane;
        int fade = 20;
        boolean slideIn = true;

        SlideAndFadeGlassPane() {
            super(null);
            this.setVisible(false);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){});
        }

        public void show(SheetOptionPane sheetOptionPane) {
            this.optionPane = sheetOptionPane;
            this.removeAll();
            this.add(sheetOptionPane);
            this.setVisible(true);
            this.slideIn = true;
            this.revalidate();
            this.repaint();
            this.doSlide();
        }

        public void hide(SheetOptionPane sheetOptionPane) {
            if (sheetOptionPane != this.optionPane) {
                return;
            }
            this.slideIn = false;
            this.revalidate();
            this.repaint();
            this.doSlide();
        }

        private void doSlide() {
            int n;
            if (this.optionPane.getParent() == null) {
                return;
            }
            if (this.optionPane.getWidth() == 0) {
                this.optionPane.setSize(this.optionPane.getPreferredSize());
            }
            if ((n = this.getWidth()) == 0 && this.getParent() != null) {
                n = this.getParent().getWidth();
            }
            int n2 = (n - this.optionPane.getWidth()) / 2;
            if (!this.slideIn) {
                this.remove(this.optionPane);
                this.setVisible(false);
                return;
            }
            this.optionPane.setLocation(n2, 0);
            this.setGrayLevel(this.fade);
        }

        public void setGrayLevel(int n) {
            n = n * 255 / 100;
            this.setBackground(new Color(0, 0, 0, n));
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(graphics);
        }
    }
}

