/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.MethodAliasInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class CreateAliasNode
extends DDLStatementNode {
    private String javaClassName;
    private String methodName;
    private char aliasType;
    private boolean delimitedIdentifier;
    private AliasInfo aliasInfo;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        TableName tableName = (TableName)object;
        this.aliasType = ((Character)object5).charValue();
        this.initAndCheck(tableName);
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                Integer n;
                int n2;
                this.javaClassName = (String)object2;
                this.methodName = (String)object3;
                this.delimitedIdentifier = (Boolean)object6;
                Object[] objectArray = (Object[])object4;
                Object[] objectArray2 = (Object[])objectArray[0];
                int n3 = ((Vector)objectArray2[0]).size();
                if (this.methodName.indexOf(40) != -1) {
                    this.getDataDictionary().checkVersion(130, "EXTERNAL NAME 'class.method(<signature>)'");
                }
                Object[] objectArray3 = null;
                Object[] objectArray4 = null;
                int[] nArray = null;
                if (n3 > 90) {
                    throw StandardException.newException("54023", (Object)String.valueOf(90), object, (Object)String.valueOf(n3));
                }
                if (n3 != 0) {
                    objectArray3 = new String[n3];
                    ((Vector)objectArray2[0]).copyInto(objectArray3);
                    objectArray4 = new TypeDescriptor[n3];
                    ((Vector)objectArray2[1]).copyInto(objectArray4);
                    nArray = new int[n3];
                    for (int i = 0; i < n3; ++i) {
                        nArray[i] = (Integer)((Vector)objectArray2[2]).elementAt(i);
                        if (!TypeId.getBuiltInTypeId(objectArray4[i].getJDBCTypeId()).isLongConcatableTypeId()) continue;
                        throw StandardException.newException("42962", objectArray3[i]);
                    }
                    if (n3 > 1) {
                        Object[] objectArray5 = new String[n3];
                        System.arraycopy(objectArray3, 0, objectArray5, 0, n3);
                        Arrays.sort(objectArray5);
                        for (n2 = 1; n2 < objectArray5.length; ++n2) {
                            if (((String)objectArray5[n2]).equals("") || !((String)objectArray5[n2]).equals(objectArray5[n2 - 1])) continue;
                            throw StandardException.newException("42734", objectArray5[n2], (Object)this.getFullName());
                        }
                    }
                }
                n2 = (n = (Integer)objectArray[2]) == null ? 0 : n;
                Short s = (Short)objectArray[6];
                short s2 = s != null ? s : (this.aliasType == 'P' ? (short)0 : 1);
                Boolean bl = (Boolean)objectArray[7];
                boolean bl2 = bl == null ? true : bl;
                this.aliasInfo = new RoutineAliasInfo(this.methodName, n3, (String[])objectArray3, (TypeDescriptor[])objectArray4, nArray, n2, (Short)objectArray[5], s2, bl2, (TypeDescriptor)objectArray[8]);
                this.implicitCreateSchema = true;
                break;
            }
            case 'S': {
                this.implicitCreateSchema = true;
                TableName tableName2 = (TableName)object2;
                String string = tableName2.getSchemaName() != null ? tableName2.getSchemaName() : this.getSchemaDescriptor().getSchemaName();
                this.aliasInfo = new SynonymAliasInfo(string, tableName2.getTableName());
                break;
            }
        }
    }

    public String statementToString() {
        switch (this.aliasType) {
            case 'P': {
                return "CREATE PROCEDURE";
            }
            case 'S': {
                return "CREATE SYNONYM";
            }
        }
        return "CREATE FUNCTION";
    }

    private boolean anyStringTypeDescriptor() {
        TypeId typeId;
        RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)this.aliasInfo;
        TypeDescriptor typeDescriptor = routineAliasInfo.getReturnType();
        if (typeDescriptor != null && (typeId = TypeId.getBuiltInTypeId(typeDescriptor.getTypeName())) != null && typeId.isStringTypeId()) {
            return true;
        }
        if (routineAliasInfo.getParameterCount() != 0) {
            int n = routineAliasInfo.getParameterCount();
            TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
            for (int i = 0; i < n; ++i) {
                typeId = TypeId.getBuiltInTypeId(typeDescriptorArray[i].getTypeName());
                if (typeId == null || !typeId.isStringTypeId()) continue;
                return true;
            }
        }
        return false;
    }

    private TypeDescriptor typeDescriptorWithCorrectCollation(TypeDescriptor typeDescriptor) throws StandardException {
        if (typeDescriptor == null) {
            return typeDescriptor;
        }
        TypeId typeId = TypeId.getBuiltInTypeId(typeDescriptor.getTypeName());
        if (typeId != null && typeId.isStringTypeId()) {
            DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId, typeDescriptor.isNullable(), typeDescriptor.getMaximumWidth());
            dataTypeDescriptor.setCollationType(this.getSchemaDescriptor().getCollationType());
            dataTypeDescriptor.setCollationDerivation(1);
            return dataTypeDescriptor;
        }
        return typeDescriptor;
    }

    public void bindStatement() throws StandardException {
        TypeDescriptor[] typeDescriptorArray;
        Object object;
        if ((this.aliasType == 'F' || this.aliasType == 'P') && this.anyStringTypeDescriptor()) {
            object = (RoutineAliasInfo)this.aliasInfo;
            typeDescriptorArray = null;
            int n = ((RoutineAliasInfo)object).getParameterCount();
            if (n > 0) {
                typeDescriptorArray = new TypeDescriptor[n];
                TypeDescriptor[] typeDescriptorArray2 = ((RoutineAliasInfo)object).getParameterTypes();
                for (int i = 0; i < n; ++i) {
                    typeDescriptorArray[i] = this.typeDescriptorWithCorrectCollation(typeDescriptorArray2[i]);
                }
            }
            this.aliasInfo = new RoutineAliasInfo(((MethodAliasInfo)object).getMethodName(), ((RoutineAliasInfo)object).getParameterCount(), ((RoutineAliasInfo)object).getParameterNames(), typeDescriptorArray, ((RoutineAliasInfo)object).getParameterModes(), ((RoutineAliasInfo)object).getMaxDynamicResultSets(), ((RoutineAliasInfo)object).getParameterStyle(), ((RoutineAliasInfo)object).getSQLAllowed(), ((RoutineAliasInfo)object).calledOnNullInput(), this.typeDescriptorWithCorrectCollation(((RoutineAliasInfo)object).getReturnType()));
        }
        if (this.aliasType != 'S') {
            return;
        }
        if (this.isSessionSchema(this.getSchemaDescriptor().getSchemaName())) {
            throw StandardException.newException("XCL51.S");
        }
        object = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
        typeDescriptorArray = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
        if (this.getObjectName().equals((String)object, (String)typeDescriptorArray)) {
            throw StandardException.newException("42916", (Object)this.getFullName(), (Object)((String)object + "." + (String)typeDescriptorArray));
        }
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor((String)object, false);
        if (schemaDescriptor != null && this.isSessionSchema(schemaDescriptor)) {
            throw StandardException.newException("XCL51.S");
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String string;
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                string = this.getSchemaDescriptor().getSchemaName();
                break;
            }
            case 'S': {
                string = this.getSchemaDescriptor().getSchemaName();
                break;
            }
            default: {
                string = null;
            }
        }
        return this.getGenericConstantActionFactory().getCreateAliasConstantAction(this.getRelativeName(), string, this.javaClassName, this.aliasInfo, this.aliasType);
    }
}

