/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCacheEntry;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class ConstantPoolCache
extends Array {
    private static OopField constants;
    private static long baseOffset;
    private static long elementSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("constantPoolCacheOopDesc");
        constants = new OopField(type.getOopField("_constant_pool"), 0L);
        baseOffset = type.getSize();
        Type elType = db.lookupType("ConstantPoolCacheEntry");
        elementSize = elType.getSize();
    }

    ConstantPoolCache(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public boolean isConstantPoolCache() {
        return true;
    }

    public ConstantPool getConstants() {
        return (ConstantPool)constants.getValue(this);
    }

    public long getObjectSize() {
        return ConstantPoolCache.alignObjectSize(baseOffset + this.getLength() * elementSize);
    }

    public ConstantPoolCacheEntry getEntryAt(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(0 <= i && (long)i < this.getLength(), "index out of bounds");
        }
        return new ConstantPoolCacheEntry(this, i);
    }

    public int getIntAt(int entry, int fld) {
        long offset = baseOffset + (long)entry * elementSize + (long)fld * this.getHeap().getIntSize();
        return (int)this.getHandle().getCIntegerAt(offset, this.getHeap().getIntSize(), true);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ConstantPoolCache for " + this.getConstants().getPoolHolder().getName().asString());
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(constants, true);
            int i = 0;
            while ((long)i < this.getLength()) {
                ConstantPoolCacheEntry entry = this.getEntryAt(i);
                entry.iterateFields(visitor);
                ++i;
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ConstantPoolCache.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

