/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterType;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCRegister
extends Register {
    private static final int nofRegisters = 32;
    private static final int GLOBAL_BASE = 0;
    private static final int OUT_BASE = 8;
    private static final int LOCAL_BASE = 16;
    private static final int IN_BASE = 24;
    private static final int LOCAL_SP_WORD_OFFSET = 0;
    private static final int IN_SP_WORD_OFFSET = 8;

    public SPARCRegister(int number) {
        super(number);
    }

    public SPARCRegister(SPARCRegisterType type, int number) {
        if (type == SPARCRegisterType.GLOBAL) {
            this.number = number + 0;
        } else if (type == SPARCRegisterType.OUT) {
            this.number = number + 8;
        } else if (type == SPARCRegisterType.LOCAL) {
            this.number = number + 16;
        } else if (type == SPARCRegisterType.IN) {
            this.number = number + 24;
        } else {
            throw new IllegalArgumentException("Invalid SPARC register type");
        }
    }

    public int getNumberOfRegisters() {
        return 32;
    }

    public boolean isIn() {
        return 24 <= this.getNumber();
    }

    public boolean isLocal() {
        return 16 <= this.getNumber() && this.getNumber() < 24;
    }

    public boolean isOut() {
        return 8 <= this.getNumber() && this.getNumber() < 16;
    }

    public boolean isGlobal() {
        return 0 <= this.getNumber() && this.getNumber() < 8;
    }

    public SPARCRegister afterSave() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isOut() || this.isGlobal(), "register not visible after save");
        }
        return this.isOut() ? new SPARCRegister(this.getNumber() + 16) : this;
    }

    public SPARCRegister afterRestore() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isIn() || this.isGlobal(), "register not visible after save");
        }
        return this.isIn() ? new SPARCRegister(this.getNumber() + -16) : this;
    }

    public long spOffsetInSavedWindow() {
        if (this.isIn()) {
            return VM.getVM().getAddressSize() * (long)(this.getNumber() - 24 + 8);
        }
        if (this.isLocal()) {
            return VM.getVM().getAddressSize() * (long)(this.getNumber() - 16 + 0);
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isIn() || this.isLocal(), "only ins and locals are saved in my frame");
        }
        return 0L;
    }

    public String toString() {
        return SPARCRegisters.getRegisterName(this.number);
    }

    public boolean isFramePointer() {
        return this.number == 30;
    }

    public boolean isStackPointer() {
        return this.number == 14;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isV9Only() {
        return false;
    }
}

