/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class Properties
extends Hashtable {
    protected Properties defaults;
    private static final long serialVersionUID = 4112578634029874840L;

    public Properties() {
    }

    public Properties(Properties defaults) {
        this.defaults = defaults;
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public void load(InputStream inStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "ISO-8859-1"));
        while ((line = reader.readLine()) != null) {
            boolean isDelim;
            int pos;
            char c = '\u0000';
            if (line.length() == 0 || line.charAt(0) == '#' || line.charAt(0) == '!') continue;
            for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
            }
            if (pos == line.length()) continue;
            StringBuffer key = new StringBuffer();
            block14: while (pos < line.length() && !Character.isWhitespace(c = line.charAt(pos++)) && c != '=' && c != ':') {
                if (c == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            break;
                        }
                        case 't': {
                            key.append('\t');
                            break;
                        }
                        case 'r': {
                            key.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block14;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            pos += 4;
                            break;
                        }
                        default: {
                            key.append(c);
                        }
                    }
                    continue;
                }
                key.append(c);
            }
            boolean bl = isDelim = c == ':' || c == '=';
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(isDelim || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            StringBuffer element = new StringBuffer(line.length() - pos);
            block18: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) break;
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            break;
                        }
                        case 't': {
                            element.append('\t');
                            break;
                        }
                        case 'r': {
                            element.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block18;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            pos += 4;
                            break;
                        }
                        default: {
                            element.append(c);
                        }
                    }
                    continue;
                }
                element.append(c);
            }
            this.put(key.toString(), element.toString());
        }
    }

    public void save(OutputStream out, String header) {
        try {
            this.store(out, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(OutputStream out, String header) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "ISO-8859-1"));
        if (header != null) {
            writer.println("#" + header);
        }
        writer.println("#" + Calendar.getInstance().getTime());
        Iterator iter = this.entrySet().iterator();
        int i = this.size();
        StringBuffer s = new StringBuffer();
        while (--i >= 0) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.formatForOutput((String)entry.getKey(), s, true);
            s.append('=');
            this.formatForOutput((String)entry.getValue(), s, false);
            writer.println(s);
        }
        writer.flush();
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        Properties prop = this;
        do {
            String value;
            if ((value = (String)prop.get(key)) == null) continue;
            return value;
        } while ((prop = prop.defaults) != null);
        return defaultValue;
    }

    public Enumeration propertyNames() {
        Properties prop = this;
        HashSet s = new HashSet();
        do {
            s.addAll(prop.keySet());
            prop = prop.defaults;
        } while (prop != null);
        return Collections.enumeration(s);
    }

    public void list(PrintStream out) {
        PrintWriter writer = new PrintWriter(out);
        this.list(writer);
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Iterator iter = this.entrySet().iterator();
        int i = this.size();
        while (--i >= 0) {
            Map.Entry entry = (Map.Entry)iter.next();
            out.print((String)entry.getKey() + "=");
            String s = (String)entry.getValue();
            if (s != null && s.length() > 40) {
                out.println(s.substring(0, 37) + "...");
                continue;
            }
            out.println(s);
        }
        out.flush();
    }

    private void formatForOutput(String str, StringBuffer buffer, boolean key) {
        if (key) {
            buffer.setLength(0);
            buffer.ensureCapacity(str.length());
        } else {
            buffer.ensureCapacity(buffer.length() + str.length());
        }
        boolean head = true;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case ' ': {
                    buffer.append(head ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    buffer.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String hex = Integer.toHexString(c);
                        buffer.append("\\u0000".substring(0, 6 - hex.length()));
                        buffer.append(hex);
                        break;
                    }
                    buffer.append(c);
                }
            }
            if (c == ' ') continue;
            head = key;
        }
    }
}

