/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.reflect.TypeSignature;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Map proxyClasses = new HashMap();
    protected InvocationHandler h;

    protected Proxy(InvocationHandler handler) {
        if (handler == null && Proxy.isProxyClass(this.getClass())) {
            throw new NullPointerException("invalid handler");
        }
        this.h = handler;
    }

    public static synchronized Class getProxyClass(ClassLoader loader, Class[] interfaces) {
        ProxyData data;
        Object check;
        ProxyType pt = new ProxyType(loader, interfaces = (Class[])interfaces.clone());
        Class clazz = (Class)proxyClasses.get(pt);
        if (clazz == null && ((check = proxyClasses.put(pt, clazz = new ClassFactory(data = ProxyData.getProxyData(pt)).generate(loader))) != null || clazz == null)) {
            throw new InternalError();
        }
        return clazz;
    }

    public static Object newProxyInstance(ClassLoader loader, Class[] interfaces, InvocationHandler handler) {
        try {
            return Proxy.getProxyClass(loader, interfaces).getConstructor(new Class[]{Proxy.class$("java.lang.reflect.InvocationHandler")}).newInstance(new Object[]{handler});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw (NullPointerException)e.getCause();
        }
        catch (Exception e) {
            throw (Error)new InternalError("Unexpected: " + e).initCause(e);
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static synchronized boolean isProxyClass(Class clazz) {
        if (!Proxy.class$("java.lang.reflect.Proxy").isAssignableFrom(clazz)) {
            return false;
        }
        return proxyClasses.containsValue(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        return ((Proxy)proxy).h;
    }

    private static native Class getProxyClass0(ClassLoader var0, Class[] var1);

    private static native ProxyData getProxyData0(ClassLoader var0, Class[] var1);

    private static native Class generateProxyClass0(ClassLoader var0, ProxyData var1);

    private static final class ClassFactory {
        private static final byte POOL = 0;
        private static final byte FIELD = 1;
        private static final byte METHOD = 2;
        private static final byte INTERFACE = 3;
        private static final String CTOR_SIG = "(Ljava/lang/reflect/InvocationHandler;)V";
        private static final String INVOKE_SIG = "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;";
        private static final char ACONST_NULL = '\u0001';
        private static final char ICONST_0 = '\u0003';
        private static final char BIPUSH = '\u0010';
        private static final char SIPUSH = '\u0011';
        private static final char ILOAD = '\u0015';
        private static final char ILOAD_0 = '\u001a';
        private static final char ALOAD_0 = '*';
        private static final char ALOAD_1 = '+';
        private static final char AALOAD = '2';
        private static final char AASTORE = 'S';
        private static final char DUP = 'Y';
        private static final char DUP_X1 = 'Z';
        private static final char SWAP = '_';
        private static final char IRETURN = '\u00ac';
        private static final char LRETURN = '\u00ad';
        private static final char FRETURN = '\u00ae';
        private static final char DRETURN = '\u00af';
        private static final char ARETURN = '\u00b0';
        private static final char RETURN = '\u00b1';
        private static final char GETSTATIC = '\u00b2';
        private static final char GETFIELD = '\u00b4';
        private static final char INVOKEVIRTUAL = '\u00b6';
        private static final char INVOKESPECIAL = '\u00b7';
        private static final char INVOKESTATIC = '\u00b8';
        private static final char INVOKEINTERFACE = '\u00b9';
        private static final char NEW = '\u00bb';
        private static final char ANEWARRAY = '\u00bd';
        private static final char ATHROW = '\u00bf';
        private static final char CHECKCAST = '\u00c0';
        private final StringBuffer pool;
        private final StringBuffer stream;
        private final Map poolEntries;
        private final String qualName;
        private final Method[] methods;

        private /* synthetic */ void finit$() {
            this.pool = new StringBuffer();
            this.stream = new StringBuffer();
            this.poolEntries = new HashMap();
        }

        ClassFactory(ProxyData data) {
            int i;
            this.finit$();
            this.methods = data.methods;
            this.pool.append("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0000");
            this.putU2(49);
            this.qualName = (data.pack == null ? "" : data.pack + '.') + "$Proxy" + data.id;
            this.putU2(this.classInfo(TypeSignature.getEncodingOfClass(this.qualName, false)));
            this.putU2(this.classInfo("java/lang/reflect/Proxy"));
            this.putU2(data.interfaces.length);
            for (i = 0; i < data.interfaces.length; ++i) {
                this.putU2(this.classInfo(data.interfaces[i]));
            }
            this.putU2(1);
            this.putU2(10);
            this.putU2(this.utf8Info("m"));
            this.putU2(this.utf8Info("[Ljava/lang/reflect/Method;"));
            this.putU2(0);
            this.putU2(this.methods.length + 1);
            this.putU2(1);
            this.putU2(this.utf8Info("<init>"));
            this.putU2(this.utf8Info(CTOR_SIG));
            this.putU2(1);
            this.putU2(this.utf8Info("Code"));
            this.stream.append("\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7");
            this.putU2(this.refInfo((byte)2, "java/lang/reflect/Proxy", "<init>", CTOR_SIG));
            this.stream.append("\u00b1\u0000\u0000\u0000\u0000");
            for (i = this.methods.length - 1; i >= 0; --i) {
                this.emitMethod(i, data.exceptions[i]);
            }
            this.putU2(0);
        }

        private void emitMethod(int i, Class[] e) {
            int j;
            Method m = this.methods[i];
            Class[] paramtypes = m.getParameterTypes();
            int wrap_overhead = 0;
            int param_count = 1;
            int code_length = 16;
            if (i > 5) {
                code_length = i > 127 ? (code_length += 2) : ++code_length;
            }
            if (paramtypes.length > 0) {
                code_length += 3;
                if (paramtypes.length > 127) {
                    code_length += 2;
                } else if (paramtypes.length > 5) {
                    ++code_length;
                }
                for (int j2 = 0; j2 < paramtypes.length; ++j2) {
                    code_length += 4;
                    Class type = paramtypes[j2];
                    if (j2 > 5) {
                        code_length = j2 > 127 ? (code_length += 2) : ++code_length;
                    }
                    if (param_count >= 4) {
                        ++code_length;
                    }
                    ++param_count;
                    if (!type.isPrimitive()) continue;
                    code_length += 7;
                    if (type == Long.TYPE || type == Double.TYPE) {
                        wrap_overhead = 3;
                        ++param_count;
                        continue;
                    }
                    if (wrap_overhead >= 2) continue;
                    wrap_overhead = 2;
                }
            }
            int end_pc = code_length++;
            Class ret_type = m.getReturnType();
            if (ret_type != Void.TYPE) {
                code_length = ret_type.isPrimitive() ? (code_length += 7) : (code_length += 4);
            }
            int exception_count = 0;
            boolean throws_throwable = false;
            for (int j3 = 0; j3 < e.length; ++j3) {
                if (e[j3] != Proxy.class$("java.lang.Throwable")) continue;
                throws_throwable = true;
                break;
            }
            if (!throws_throwable) {
                exception_count = e.length + 3;
                code_length += 9;
            }
            int handler_pc = code_length - 1;
            StringBuffer signature = new StringBuffer("(");
            for (j = 0; j < paramtypes.length; ++j) {
                signature.append(TypeSignature.getEncodingOfClass(paramtypes[j]));
            }
            signature.append(")").append(TypeSignature.getEncodingOfClass(ret_type));
            this.putU2(17);
            this.putU2(this.utf8Info(m.getName()));
            this.putU2(this.utf8Info(signature.toString()));
            this.putU2(e.length > 0 ? 2 : 1);
            this.putU2(this.utf8Info("Code"));
            this.putU4(12 + code_length + 8 * exception_count);
            this.putU2(param_count == 1 ? 4 : 7 + wrap_overhead);
            this.putU2(param_count);
            this.putU4(code_length);
            this.putU1(42);
            this.putU1(180);
            this.putU2(this.refInfo((byte)1, "java/lang/reflect/Proxy", "h", "Ljava/lang/reflect/InvocationHandler;"));
            this.putU1(42);
            this.putU1(178);
            this.putU2(this.refInfo((byte)1, TypeSignature.getEncodingOfClass(this.qualName, false), "m", "[Ljava/lang/reflect/Method;"));
            this.putConst(i);
            this.putU1(50);
            if (paramtypes.length > 0) {
                this.putConst(paramtypes.length);
                this.putU1(189);
                this.putU2(this.classInfo("java/lang/Object"));
                param_count = 1;
                j = 0;
                while (j < paramtypes.length) {
                    this.putU1(89);
                    this.putConst(j);
                    if (paramtypes[j].isPrimitive()) {
                        this.putU1(187);
                        this.putU2(this.classInfo(this.wrapper(paramtypes[j])));
                        this.putU1(89);
                    }
                    this.putLoad(param_count, paramtypes[j]);
                    if (paramtypes[j].isPrimitive()) {
                        this.putU1(183);
                        this.putU2(this.refInfo((byte)2, this.wrapper(paramtypes[j]), "<init>", "" + '(' + new StringBuffer().append(TypeSignature.getEncodingOfClass(paramtypes[j])).append(")V")));
                        if (paramtypes[j] == Long.TYPE || paramtypes[j] == Double.TYPE) {
                            ++param_count;
                        }
                    }
                    this.putU1(83);
                    ++j;
                    ++param_count;
                }
            } else {
                this.putU1(1);
            }
            this.putU1(185);
            this.putU2(this.refInfo((byte)3, "java/lang/reflect/InvocationHandler", "invoke", INVOKE_SIG));
            this.putU1(4);
            this.putU1(0);
            if (ret_type == Void.TYPE) {
                this.putU1(177);
            } else if (ret_type.isPrimitive()) {
                this.putU1(192);
                this.putU2(this.classInfo(this.wrapper(ret_type)));
                this.putU1(182);
                this.putU2(this.refInfo((byte)2, this.wrapper(ret_type), ret_type.getName() + "Value", "()" + TypeSignature.getEncodingOfClass(ret_type)));
                if (ret_type == Long.TYPE) {
                    this.putU1(173);
                } else if (ret_type == Float.TYPE) {
                    this.putU1(174);
                } else if (ret_type == Double.TYPE) {
                    this.putU1(175);
                } else {
                    this.putU1(172);
                }
            } else {
                this.putU1(192);
                this.putU2(this.classInfo(ret_type));
                this.putU1(176);
            }
            if (!throws_throwable) {
                this.putU1(187);
                this.putU2(this.classInfo("java/lang/reflect/UndeclaredThrowableException"));
                this.putU1(90);
                this.putU1(95);
                this.putU1(183);
                this.putU2(this.refInfo((byte)2, "java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V"));
                this.putU1(191);
            }
            this.putU2(exception_count);
            if (!throws_throwable) {
                this.putU2(0);
                this.putU2(end_pc);
                this.putU2(handler_pc);
                this.putU2(this.classInfo("java/lang/Error"));
                this.putU2(0);
                this.putU2(end_pc);
                this.putU2(handler_pc);
                this.putU2(this.classInfo("java/lang/RuntimeException"));
                for (j = 0; j < e.length; ++j) {
                    this.putU2(0);
                    this.putU2(end_pc);
                    this.putU2(handler_pc);
                    this.putU2(this.classInfo(e[j]));
                }
                this.putU2(0);
                this.putU2(end_pc);
                this.putU2(handler_pc - 8);
                this.putU2(0);
            }
            this.putU2(0);
            if (e.length > 0) {
                this.putU2(this.utf8Info("Exceptions"));
                this.putU4(2 * e.length + 2);
                this.putU2(e.length);
                for (j = 0; j < e.length; ++j) {
                    this.putU2(this.classInfo(e[j]));
                }
            }
        }

        final Class generate(ClassLoader loader) {
            byte[] bytecode = new byte[this.pool.length() + this.stream.length()];
            char[] c = this.pool.toString().toCharArray();
            int i = c.length;
            while (--i >= 0) {
                bytecode[i] = (byte)c[i];
            }
            c = this.stream.toString().toCharArray();
            i = c.length;
            int j = bytecode.length;
            while (i > 0) {
                bytecode[--j] = (byte)c[--i];
            }
            int count = this.poolEntries.size() + 1;
            bytecode[8] = (byte)(count >> 8);
            bytecode[9] = (byte)count;
            try {
                Class vmClassLoader = Class.forName("java.lang.VMClassLoader");
                Class[] types = new Class[]{Proxy.class$("java.lang.ClassLoader"), Proxy.class$("java.lang.String"), Proxy.class$("[B"), Integer.TYPE, Integer.TYPE, Proxy.class$("java.security.ProtectionDomain")};
                Method m = vmClassLoader.getDeclaredMethod("defineClass", types);
                m.flag = true;
                Object[] args = new Object[]{loader, this.qualName, bytecode, new Integer(0), new Integer(bytecode.length), Proxy.class$("java.lang.Object").getProtectionDomain()};
                Class clazz = (Class)m.invoke(null, args);
                m.flag = false;
                Field f = clazz.getDeclaredField("m");
                f.flag = true;
                f.set(null, this.methods);
                f.flag = false;
                return clazz;
            }
            catch (Throwable e) {
                throw (Error)new InternalError("Unexpected: " + e).initCause(e);
            }
        }

        private void putU1(int i) {
            this.stream.append((char)i);
        }

        private void putU2(int i) {
            this.stream.append((char)(i >> 8)).append((char)i);
        }

        private void putU4(int i) {
            this.stream.append((char)(i >> 24)).append((char)(i >> 16));
            this.stream.append((char)(i >> 8)).append((char)i);
        }

        private void putConst(int i) {
            if (i >= -1 && i <= 5) {
                this.putU1(3 + i);
            } else if (i >= -128 && i <= 127) {
                this.putU1(16);
                this.putU1(i);
            } else {
                this.putU1(17);
                this.putU2(i);
            }
        }

        private void putLoad(int i, Class type) {
            int offset = 0;
            if (type == Long.TYPE) {
                offset = 1;
            } else if (type == Float.TYPE) {
                offset = 2;
            } else if (type == Double.TYPE) {
                offset = 3;
            } else if (!type.isPrimitive()) {
                offset = 4;
            }
            if (i < 4) {
                this.putU1(26 + 4 * offset + i);
            } else {
                this.putU1(21 + offset);
                this.putU1(i);
            }
        }

        private String wrapper(Class clazz) {
            if (clazz == Boolean.TYPE) {
                return "java/lang/Boolean";
            }
            if (clazz == Byte.TYPE) {
                return "java/lang/Byte";
            }
            if (clazz == Short.TYPE) {
                return "java/lang/Short";
            }
            if (clazz == Character.TYPE) {
                return "java/lang/Character";
            }
            if (clazz == Integer.TYPE) {
                return "java/lang/Integer";
            }
            if (clazz == Long.TYPE) {
                return "java/lang/Long";
            }
            if (clazz == Float.TYPE) {
                return "java/lang/Float";
            }
            if (clazz == Double.TYPE) {
                return "java/lang/Double";
            }
            return null;
        }

        private char utf8Info(String str) {
            String utf8 = this.toUtf8(str);
            int len = utf8.length();
            return this.poolIndex("\u0001" + (char)(len >> 8) + (char)((char)len & 0xFF) + utf8);
        }

        private char classInfo(String name) {
            char index = this.utf8Info(name);
            char[] c = new char[]{'\u0007', (char)(index >> 8), index & 0xFF};
            return this.poolIndex(new String(c));
        }

        private char classInfo(Class clazz) {
            return this.classInfo(TypeSignature.getEncodingOfClass(clazz.getName(), false));
        }

        private char refInfo(byte structure, String clazz, String name, String type) {
            char cindex = this.classInfo(clazz);
            char ntindex = this.nameAndTypeInfo(name, type);
            char[] c = new char[]{(char)(structure + 8), (char)(cindex >> 8), cindex & 0xFF, (char)(ntindex >> 8), ntindex & 0xFF};
            return this.poolIndex(new String(c));
        }

        private char nameAndTypeInfo(String name, String type) {
            char nindex = this.utf8Info(name);
            char tindex = this.utf8Info(type);
            char[] c = new char[]{'\f', (char)(nindex >> 8), nindex & 0xFF, (char)(tindex >> 8), tindex & 0xFF};
            return this.poolIndex(new String(c));
        }

        private String toUtf8(String str) {
            int i;
            char[] ca = str.toCharArray();
            int len = ca.length;
            for (i = 0; i < len && ca[i] != '\u0000' && ca[i] <= '\u007f'; ++i) {
            }
            if (i == len) {
                return str;
            }
            StringBuffer sb = new StringBuffer(str);
            sb.setLength(i);
            while (i < len) {
                char c = ca[i];
                if (c > '\u0000' && c <= '\u007f') {
                    sb.append(c);
                } else if (c <= '\u07ff') {
                    sb.append((char)(0xC0 | c >> 6));
                    sb.append((char)(0x80 | c & 0x6F));
                } else {
                    sb.append((char)(0xE0 | c >> 12));
                    sb.append((char)(0x80 | c >> 6 & 0x6F));
                    sb.append((char)(0x80 | c & 0x6F));
                }
                ++i;
            }
            return sb.toString();
        }

        private char poolIndex(String sequence) {
            Integer i = (Integer)this.poolEntries.get(sequence);
            if (i == null) {
                int size = this.poolEntries.size() + 1;
                if (size >= 65535) {
                    throw new IllegalArgumentException("exceeds VM limitations");
                }
                i = new Integer(size);
                this.poolEntries.put(sequence, i);
                this.pool.append(sequence);
            }
            return (char)i.intValue();
        }

        static {
            CTOR_SIG = CTOR_SIG;
            INVOKE_SIG = INVOKE_SIG;
        }
    }

    private static final class ProxyData {
        String pack;
        Class[] interfaces;
        Method[] methods;
        Class[][] exceptions;
        private static int count = 0;
        final int id;

        private /* synthetic */ void finit$() {
            this.id = count++;
        }

        ProxyData() {
            this.finit$();
        }

        static String getPackage(Class k) {
            String name = k.getName();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                return name.substring(0, idx);
            }
            return null;
        }

        static ProxyData getProxyData(ProxyType pt) {
            Map method_set = (Map)ProxySignature.coreMethods.clone();
            boolean in_package = false;
            ProxyData data = new ProxyData();
            data.interfaces = pt.interfaces;
            int i = data.interfaces.length;
            while (--i >= 0) {
                Class inter = data.interfaces[i];
                if (!inter.isInterface()) {
                    throw new IllegalArgumentException("not an interface: " + inter);
                }
                try {
                    if (Class.forName(inter.getName(), false, pt.loader) != inter) {
                        throw new IllegalArgumentException("not accessible in classloader: " + inter);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("not accessible in classloader: " + inter);
                }
                if (!Modifier.isPublic(inter.getModifiers())) {
                    if (in_package) {
                        String p = ProxyData.getPackage(inter);
                        if (!data.pack.equals(p)) {
                            throw new IllegalArgumentException("non-public interfaces from different packages");
                        }
                    } else {
                        in_package = true;
                        data.pack = ProxyData.getPackage(inter);
                    }
                }
                for (int j = i - 1; j >= 0; --j) {
                    if (data.interfaces[j] != inter) continue;
                    throw new IllegalArgumentException("duplicate interface: " + inter);
                }
                Method[] methods = inter.getMethods();
                int j = methods.length;
                while (--j >= 0) {
                    ProxySignature sig = new ProxySignature(methods[j]);
                    ProxySignature old = (ProxySignature)method_set.put(sig, sig);
                    if (old == null) continue;
                    sig.checkCompatibility(old);
                }
            }
            i = method_set.size();
            data.methods = new Method[i];
            data.exceptions = new Class[i][];
            Iterator itr = method_set.values().iterator();
            while (--i >= 0) {
                ProxySignature sig = (ProxySignature)itr.next();
                data.methods[i] = sig.method;
                data.exceptions[i] = (Class[])sig.exceptions.toArray(new Class[sig.exceptions.size()]);
            }
            return data;
        }
    }

    private static final class ProxySignature {
        static final HashMap coreMethods = new HashMap();
        final Method method;
        final Set exceptions;

        private /* synthetic */ void finit$() {
            this.exceptions = new HashSet();
        }

        ProxySignature(Method method) {
            this.finit$();
            this.method = method;
            Class[] exc = method.getExceptionTypes();
            int i = exc.length;
            while (--i >= 0) {
                if (Proxy.class$("java.lang.Error").isAssignableFrom(exc[i]) || Proxy.class$("java.lang.RuntimeException").isAssignableFrom(exc[i])) continue;
                this.exceptions.add(exc[i]);
            }
        }

        void checkCompatibility(ProxySignature other) {
            if (this.method.getReturnType() != other.method.getReturnType()) {
                throw new IllegalArgumentException("incompatible return types: " + this.method + ", " + other.method);
            }
            int size1 = this.exceptions.size();
            int size2 = other.exceptions.size();
            boolean[] valid1 = new boolean[size1];
            boolean[] valid2 = new boolean[size2];
            Iterator itr = this.exceptions.iterator();
            int pos = size1;
            while (--pos >= 0) {
                Class c1 = (Class)itr.next();
                Iterator itr2 = other.exceptions.iterator();
                int pos2 = size2;
                while (--pos2 >= 0) {
                    Class c2 = (Class)itr2.next();
                    if (c2.isAssignableFrom(c1)) {
                        valid1[pos] = true;
                    }
                    if (!c1.isAssignableFrom(c2)) continue;
                    valid2[pos2] = true;
                }
            }
            pos = size1;
            itr = this.exceptions.iterator();
            while (--pos >= 0) {
                itr.next();
                if (valid1[pos]) continue;
                itr.remove();
            }
            pos = size2;
            itr = other.exceptions.iterator();
            while (--pos >= 0) {
                itr.next();
                if (valid2[pos]) continue;
                itr.remove();
            }
            this.exceptions.addAll(other.exceptions);
        }

        public int hashCode() {
            int hash = this.method.getName().hashCode();
            Class[] types = this.method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                hash = hash * 31 + types[i].hashCode();
            }
            return hash;
        }

        public boolean equals(Object other) {
            ProxySignature ps = (ProxySignature)other;
            Class[] types1 = this.method.getParameterTypes();
            Class[] types2 = ps.method.getParameterTypes();
            if (!this.method.getName().equals(ps.method.getName()) || types1.length != types2.length) {
                return false;
            }
            int i = types1.length;
            while (--i >= 0) {
                if (types1[i] == types2[i]) continue;
                return false;
            }
            return true;
        }

        static {
            try {
                ProxySignature sig = new ProxySignature(Proxy.class$("java.lang.Object").getMethod("equals", new Class[]{Proxy.class$("java.lang.Object")}));
                coreMethods.put(sig, sig);
                sig = new ProxySignature(Proxy.class$("java.lang.Object").getMethod("hashCode", null));
                coreMethods.put(sig, sig);
                sig = new ProxySignature(Proxy.class$("java.lang.Object").getMethod("toString", null));
                coreMethods.put(sig, sig);
            }
            catch (Exception e) {
                throw (Error)new InternalError("Unexpected: " + e).initCause(e);
            }
        }
    }

    private static final class ProxyType {
        final ClassLoader loader;
        final Class[] interfaces;

        ProxyType(ClassLoader loader, Class[] interfaces) {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            this.loader = loader;
            this.interfaces = interfaces;
        }

        public int hashCode() {
            int hash = this.loader.hashCode();
            for (int i = 0; i < this.interfaces.length; ++i) {
                hash = hash * 31 + this.interfaces[i].hashCode();
            }
            return hash;
        }

        private static boolean sameTypes(Class[] arr1, Class[] arr2) {
            if (arr1.length == 1 && arr2.length == 1) {
                return arr1[0] == arr2[0];
            }
            int total_occ_of_arr1_in_arr2 = 0;
            int i = arr1.length;
            block0: while (--i >= 0) {
                Class t = arr1[i];
                int j = i;
                while (--j >= 0) {
                    if (t != arr1[j]) continue;
                    continue block0;
                }
                int occ_in_arr2 = 0;
                int j2 = arr2.length;
                while (--j2 >= 0) {
                    if (t != arr2[j2]) continue;
                    ++occ_in_arr2;
                }
                if (occ_in_arr2 == 0) {
                    return false;
                }
                total_occ_of_arr1_in_arr2 += occ_in_arr2;
            }
            return arr2.length == total_occ_of_arr1_in_arr2;
        }

        public boolean equals(Object other) {
            ProxyType pt = (ProxyType)other;
            if (this.loader != pt.loader || this.interfaces.length != pt.interfaces.length) {
                return false;
            }
            return ProxyType.sameTypes(this.interfaces, pt.interfaces);
        }
    }
}

