/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class TableExample
implements LayoutManager {
    static String[] ConnectOptionNames = new String[]{"Connect"};
    static String ConnectTitle = "Connection Information";
    Dimension origin = new Dimension(0, 0);
    JButton fetchButton;
    JButton showConnectionInfoButton;
    JPanel connectionPanel;
    JFrame frame;
    JLabel userNameLabel;
    JTextField userNameField;
    JLabel passwordLabel;
    JTextField passwordField;
    JTextArea queryTextArea;
    JComponent queryAggregate;
    JLabel serverLabel;
    JTextField serverField;
    JLabel driverLabel;
    JTextField driverField;
    JPanel mainPanel = new JPanel();
    TableSorter sorter;
    JDBCAdapter dataBase;
    JScrollPane tableAggregate;

    void activateConnectionDialog() {
        if (JOptionPane.showOptionDialog(this.tableAggregate, this.connectionPanel, ConnectTitle, -1, 1, null, ConnectOptionNames, ConnectOptionNames[0]) == 0) {
            this.connect();
            this.frame.setVisible(true);
        } else if (!this.frame.isVisible()) {
            System.exit(0);
        }
    }

    public void createConnectionDialog() {
        this.userNameLabel = new JLabel("User name: ", 4);
        this.userNameField = new JTextField("guest");
        this.passwordLabel = new JLabel("Password: ", 4);
        this.passwordField = new JTextField("trustworthy");
        this.serverLabel = new JLabel("Database URL: ", 4);
        this.serverField = new JTextField("jdbc:sybase://dbtest:1455/pubs2");
        this.driverLabel = new JLabel("Driver: ", 4);
        this.driverField = new JTextField("connect.sybase.SybaseDriver");
        this.connectionPanel = new JPanel(false);
        this.connectionPanel.setLayout(new BoxLayout(this.connectionPanel, 0));
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.userNameLabel);
        jPanel.add(this.passwordLabel);
        jPanel.add(this.serverLabel);
        jPanel.add(this.driverLabel);
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(this.userNameField);
        jPanel2.add(this.passwordField);
        jPanel2.add(this.serverField);
        jPanel2.add(this.driverField);
        this.connectionPanel.add(jPanel);
        this.connectionPanel.add(jPanel2);
    }

    public TableExample() {
        this.createConnectionDialog();
        this.showConnectionInfoButton = new JButton("Configuration");
        this.showConnectionInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableExample.this.activateConnectionDialog();
            }
        });
        this.fetchButton = new JButton("Fetch");
        this.fetchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableExample.this.fetch();
            }
        });
        this.queryTextArea = new JTextArea("SELECT * FROM titles", 25, 25);
        this.queryAggregate = new JScrollPane(this.queryTextArea);
        this.queryAggregate.setBorder(new BevelBorder(1));
        this.tableAggregate = this.createTable();
        this.tableAggregate.setBorder(new BevelBorder(1));
        this.mainPanel.add(this.fetchButton);
        this.mainPanel.add(this.showConnectionInfoButton);
        this.mainPanel.add(this.queryAggregate);
        this.mainPanel.add(this.tableAggregate);
        this.mainPanel.setLayout(this);
        this.frame = new JFrame("TableExample");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.frame.setBackground(Color.lightGray);
        this.frame.getContentPane().add(this.mainPanel);
        this.frame.pack();
        this.frame.setVisible(false);
        this.frame.setBounds(200, 200, 640, 480);
        this.activateConnectionDialog();
    }

    public void connect() {
        this.dataBase = new JDBCAdapter(this.serverField.getText(), this.driverField.getText(), this.userNameField.getText(), this.passwordField.getText());
        this.sorter.setModel(this.dataBase);
    }

    public void fetch() {
        this.dataBase.executeQuery(this.queryTextArea.getText());
    }

    public JScrollPane createTable() {
        this.sorter = new TableSorter();
        JTable jTable = new JTable(this.sorter);
        jTable.setAutoResizeMode(0);
        this.sorter.addMouseListenerToHeaderInTable(jTable);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        return jScrollPane;
    }

    public static void main(String[] stringArray) {
        new TableExample();
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.origin;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.origin;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        Rectangle rectangle = container.getBounds();
        int n = 90;
        int n2 = 4;
        this.showConnectionInfoButton.setBounds(rectangle.width - 2 * n2 - 120, n2, 120, 25);
        this.fetchButton.setBounds(rectangle.width - 2 * n2 - 120, 60, 120, 25);
        this.queryAggregate.setBounds(n2, n2, rectangle.width - 2 * n2 - 150, 80);
        this.tableAggregate.setBounds(new Rectangle(n2, n2 + n, rectangle.width - 2 * n2, rectangle.height - 2 * n2 - n));
    }
}

