/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.VirtualSpace;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.BitMap;

public class CMSBitMap
extends VMObject {
    private static AddressField bmStartWordField;
    private static CIntegerField bmWordSizeField;
    private static CIntegerField shifterField;
    private static long virtualSpaceFieldOffset;

    public CMSBitMap(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CMSBitMap");
        bmStartWordField = type.getAddressField("_bmStartWord");
        bmWordSizeField = type.getCIntegerField("_bmWordSize");
        shifterField = type.getCIntegerField("_shifter");
        virtualSpaceFieldOffset = type.getField("_virtual_space").getOffset();
    }

    public void printAll() {
        System.out.println("bmStartWord(): " + this.bmStartWord());
        System.out.println("bmWordSize(): " + this.bmWordSize());
        System.out.println("shifter(): " + this.shifter());
    }

    public Address bmStartWord() {
        return bmStartWordField.getValue(this.addr);
    }

    public long bmWordSize() {
        return bmWordSizeField.getValue(this.addr);
    }

    public long shifter() {
        return shifterField.getValue(this.addr);
    }

    public VirtualSpace virtualSpace() {
        return (VirtualSpace)VMObjectFactory.newObject(VirtualSpace.class, this.addr.addOffsetTo(virtualSpaceFieldOffset));
    }

    public BitMap bm() {
        BitMap bitMap = new BitMap((int)(this.bmWordSize() >> (int)(this.shifter() + 3L)));
        VirtualSpace vs = this.virtualSpace();
        bitMap.set_map(vs.low());
        return bitMap;
    }

    public Address getNextMarkedWordAddress(Address addr) {
        Address endWord = this.bmStartWord().addOffsetTo(this.bmWordSize());
        int nextOffset = this.bm().getNextOneOffset(this.heapWordToOffset(addr), this.heapWordToOffset(endWord));
        Address nextAddr = this.offsetToHeapWord(nextOffset);
        return nextAddr;
    }

    int heapWordToOffset(Address addr) {
        int temp = (int)addr.minus(this.bmStartWord()) / (int)VM.getVM().getAddressSize();
        int ret_val = temp >> (int)this.shifter();
        return ret_val;
    }

    Address offsetToHeapWord(int offset) {
        int temp = offset << (int)this.shifter();
        return this.bmStartWord().addOffsetTo((long)temp * VM.getVM().getAddressSize());
    }

    boolean isMarked(Address addr) {
        BitMap bm = this.bm();
        return bm.at(this.heapWordToOffset(addr));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CMSBitMap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

