/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.jdi.FieldImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.ThreadReferenceImpl;
import sun.jvm.hotspot.jdi.ValueImpl;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Mark;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.MonitorInfo;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.utilities.Assert;

public class ObjectReferenceImpl
extends ValueImpl
implements ObjectReference {
    private Oop saObject;
    private long myID;
    private boolean monitorInfoCached = false;
    private ThreadReferenceImpl owningThread = null;
    private List waitingThreads = null;
    private int entryCount = 0;
    private static long nextID = 0L;

    private static synchronized long nextID() {
        return nextID++;
    }

    ObjectReferenceImpl(VirtualMachine aVm, Oop oRef) {
        super(aVm);
        this.saObject = oRef;
        this.myID = ObjectReferenceImpl.nextID();
    }

    protected Oop ref() {
        return this.saObject;
    }

    public Type type() {
        return this.referenceType();
    }

    public ReferenceType referenceType() {
        Klass myKlass = this.ref().getKlass();
        return this.vm.referenceType(myKlass);
    }

    public Value getValue(Field sig) {
        ArrayList<Field> list = new ArrayList<Field>(1);
        list.add(sig);
        Map map = this.getValues(list);
        return (Value)map.get(sig);
    }

    public Map getValues(List theFields) {
        ArrayList<FieldImpl> staticFields = new ArrayList<FieldImpl>(0);
        int size = theFields.size();
        ArrayList<FieldImpl> instanceFields = new ArrayList<FieldImpl>(size);
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)theFields.get(i);
            ((ReferenceTypeImpl)this.referenceType()).validateFieldAccess(field);
            if (field.isStatic()) {
                staticFields.add(field);
                continue;
            }
            instanceFields.add(field);
        }
        Map<Field, Value> map = staticFields.size() > 0 ? this.referenceType().getValues(staticFields) : new HashMap<Field, Value>(size);
        size = instanceFields.size();
        for (int ii = 0; ii < size; ++ii) {
            FieldImpl fieldImpl = (FieldImpl)instanceFields.get(ii);
            map.put(fieldImpl, fieldImpl.getValue(this.saObject));
        }
        return map;
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.vm.throwNotReadOnlyException("ObjectReference.setValue(...)");
    }

    public Value invokeMethod(ThreadReference threadIntf, Method methodIntf, List arguments, int options) throws InvalidTypeException, IncompatibleThreadStateException, InvocationException, ClassNotLoadedException {
        this.vm.throwNotReadOnlyException("ObjectReference.invokeMethod(...)");
        return null;
    }

    public void disableCollection() {
        this.vm.throwNotReadOnlyException("ObjectReference.disableCollection()");
    }

    public void enableCollection() {
        this.vm.throwNotReadOnlyException("ObjectReference.enableCollection()");
    }

    public boolean isCollected() {
        this.vm.throwNotReadOnlyException("ObjectReference.isCollected()");
        return false;
    }

    public long uniqueID() {
        return this.myID;
    }

    public List waitingThreads() throws IncompatibleThreadStateException {
        if (!this.vm.canGetMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (!this.monitorInfoCached) {
            this.computeMonitorInfo();
        }
        return this.waitingThreads;
    }

    public ThreadReference owningThread() throws IncompatibleThreadStateException {
        if (!this.vm.canGetMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (!this.monitorInfoCached) {
            this.computeMonitorInfo();
        }
        return this.owningThread;
    }

    public int entryCount() throws IncompatibleThreadStateException {
        if (!this.vm.canGetMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (!this.monitorInfoCached) {
            this.computeMonitorInfo();
        }
        return this.entryCount;
    }

    public List referringObjects(long maxReferrers) {
        if (!this.vm.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        if (maxReferrers < 0L) {
            throw new IllegalArgumentException("maxReferrers is less than zero: " + maxReferrers);
        }
        final ObjectReferenceImpl obj = this;
        final ArrayList objects = new ArrayList(0);
        final long max = maxReferrers;
        this.vm.saObjectHeap().iterate(new DefaultHeapVisitor(){
            private long refCount = 0L;

            public boolean doObj(Oop oop) {
                try {
                    ObjectReferenceImpl objref = ObjectReferenceImpl.this.vm.objectMirror(oop);
                    List<Field> fields = objref.referenceType().allFields();
                    for (int i = 0; i < fields.size(); ++i) {
                        Field fld = fields.get(i);
                        if (!objref.getValue(fld).equals(obj) || objects.contains(objref)) continue;
                        objects.add(objref);
                        ++this.refCount;
                    }
                    if (max > 0L && this.refCount >= max) {
                        return true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return false;
            }
        });
        return objects;
    }

    private int countLockedObjects(JavaThread jt, Oop obj) {
        int res = 0;
        for (JavaVFrame frame = jt.getLastJavaVFrameDbg(); frame != null; frame = (JavaVFrame)frame.sender()) {
            List monitors = frame.getMonitors();
            OopHandle givenHandle = obj.getHandle();
            Iterator itr = monitors.iterator();
            while (itr.hasNext()) {
                MonitorInfo mi = (MonitorInfo)itr.next();
                if (!givenHandle.equals(mi.owner())) continue;
                ++res;
            }
        }
        return res;
    }

    private List getPendingThreads(ObjectMonitor mon) {
        return this.vm.saVM().getThreads().getPendingThreads(mon);
    }

    private List getWaitingThreads(ObjectMonitor mon) {
        return this.vm.saVM().getThreads().getWaitingThreads(mon);
    }

    private JavaThread owningThreadFromMonitor(Address addr) {
        return this.vm.saVM().getThreads().owningThreadFromMonitor(addr);
    }

    private void computeMonitorInfo() {
        this.monitorInfoCached = true;
        Mark mark = this.saObject.getMark();
        ObjectMonitor mon = null;
        Address owner = null;
        if (!mark.hasMonitor()) {
            if (mark.hasLocker()) {
                owner = mark.locker().getAddress();
            }
        } else {
            mon = mark.monitor();
            owner = mon.owner();
        }
        if (owner != null) {
            this.owningThread = this.vm.threadMirror(this.owningThreadFromMonitor(owner));
        }
        if (this.owningThread != null) {
            if (((Object)this.owningThread.getJavaThread().getAddress()).equals(owner)) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(false, "must have heavyweight monitor with JavaThread * owner");
                }
                this.entryCount = (int)mark.monitor().recursions() + 1;
            } else {
                this.entryCount = this.countLockedObjects(this.owningThread.getJavaThread(), this.saObject);
            }
        }
        this.waitingThreads = new ArrayList();
        if (mon != null) {
            List pendingThreads = this.getPendingThreads(mon);
            Iterator itrPend = pendingThreads.iterator();
            while (itrPend.hasNext()) {
                this.waitingThreads.add(this.vm.threadMirror((JavaThread)itrPend.next()));
            }
            List objWaitingThreads = this.getWaitingThreads(mon);
            Iterator itrWait = objWaitingThreads.iterator();
            while (itrWait.hasNext()) {
                this.waitingThreads.add(this.vm.threadMirror((JavaThread)itrWait.next()));
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ObjectReferenceImpl) {
            ObjectReferenceImpl other = (ObjectReferenceImpl)obj;
            return this.ref().equals(other.ref()) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.saObject.hashCode();
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(id=" + this.uniqueID() + ")";
    }
}

