/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.EventObject;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XTable;
import sun.tools.jconsole.inspector.XTextFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMBeanAttributes
extends XTable {
    private static final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
    private boolean editable = true;
    private XMBean mbean;
    private MBeanInfo mbeanInfo;
    private MBeanAttributeInfo[] attributesInfo;
    private HashMap<String, Object> attributes;
    private HashMap<String, Object> unavailableAttributes;
    private HashMap<String, Object> viewableAttributes;
    private TableModelListener attributesListener;
    private MBeansTab mbeansTab;
    private XTable table;
    private CellEditor cellEditor = new CellEditor();
    private XDataViewer viewer;
    private int rowMinHeight = -1;
    private AttributesMouseListener mouseListener = new AttributesMouseListener();

    public XMBeanAttributes(XDataViewer xDataViewer, MBeansTab mBeansTab) {
        this.mbeansTab = mBeansTab;
        ((DefaultTableModel)this.getModel()).setColumnIdentifiers(columnNames);
        this.attributesListener = new AttributesListener(this);
        this.getModel().addTableModelListener(this.attributesListener);
        this.viewer = xDataViewer;
        this.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.addMouseListener(this.mouseListener);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnEditors();
    }

    @Override
    public synchronized Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        if (n >= this.getRowCount()) {
            return null;
        }
        return super.prepareRenderer(tableCellRenderer, n, n2);
    }

    void updateRowHeight(Object object, int n) {
        ZoomedCell zoomedCell = null;
        if (object instanceof ZoomedCell) {
            zoomedCell = (ZoomedCell)object;
            if (zoomedCell.isInited()) {
                this.setRowHeight(n, zoomedCell.getHeight());
            } else if (this.rowMinHeight != -1) {
                this.setRowHeight(n, this.rowMinHeight);
            }
        } else if (this.rowMinHeight != -1) {
            this.setRowHeight(n, this.rowMinHeight);
        }
    }

    @Override
    public synchronized TableCellRenderer getCellRenderer(int n, int n2) {
        Object object;
        if (n >= this.getRowCount()) {
            return null;
        }
        ZoomedCell zoomedCell = null;
        if (n2 == 1 && (object = this.getModel().getValueAt(n, n2)) instanceof ZoomedCell && (zoomedCell = (ZoomedCell)object).isInited()) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)zoomedCell.getRenderer();
            Color color = this.getDefaultColor();
            Color color2 = this.getEditableColor();
            if (this.isCellEditable(n, n2)) {
                if (color2 != null) {
                    defaultTableCellRenderer.setForeground(color2);
                }
            } else if (color != null) {
                defaultTableCellRenderer.setForeground(color);
            }
            return defaultTableCellRenderer;
        }
        if (n2 == 0 && this.isAttributeViewable(n, n2)) {
            object = (DefaultTableCellRenderer)super.getCellRenderer(n, n2);
            ((JComponent)object).setToolTipText(this.getToolTip(n, n2));
        }
        return super.getCellRenderer(n, n2);
    }

    private void setColumnEditors() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            TableCellEditor tableCellEditor;
            if (!this.isColumnEditable(i) || (tableCellEditor = this.getCellEditor(i)) == null) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellEditor(this.getCellEditor(i));
        }
    }

    @Override
    public final boolean editCellAt(int n, int n2, EventObject eventObject) {
        TableCellEditor tableCellEditor;
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && (tableCellEditor = this.getColumnModel().getColumn(n2).getCellEditor()) != null) {
            ((JComponent)((Object)tableCellEditor)).requestFocus();
        }
        return bl;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        ZoomedCell zoomedCell;
        Object object = this.getModel().getValueAt(n, n2);
        if (object instanceof ZoomedCell && (zoomedCell = (ZoomedCell)object).isMaximized()) {
            return true;
        }
        boolean bl2 = bl = this.isTableEditable() && this.isColumnEditable(n2) && this.isWritable(n);
        if (!bl) {
            return false;
        }
        String string = this.getClassName(n);
        return Utils.isEditableType(string);
    }

    @Override
    public TableCellEditor getCellEditor(int n) {
        return this.cellEditor;
    }

    @Override
    public boolean isTableEditable() {
        return true;
    }

    @Override
    public void setTableValue(Object object, int n) {
        this.setValueAt(object, n, 3);
    }

    @Override
    public boolean isColumnEditable(int n) {
        if (n < this.getColumnCount()) {
            return this.getColumnName(n).equals(Resources.getText("Value", new Object[0]));
        }
        return false;
    }

    @Override
    public String getClassName(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].getType();
        }
        return null;
    }

    @Override
    public String getValueName(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].getName();
        }
        return null;
    }

    @Override
    public Object getValue(int n) {
        return ((DefaultTableModel)this.getModel()).getValueAt(n, 1);
    }

    @Override
    public String getToolTip(int n, int n2) {
        int n3;
        if (this.isCellError(n, n2)) {
            return (String)this.unavailableAttributes.get(this.getValueName(n));
        }
        if (this.isColumnEditable(n2)) {
            Object object = this.getValue(n);
            String string = null;
            if (object != null) {
                string = object.toString();
                if (this.isAttributeViewable(n, 1)) {
                    string = Resources.getText("Double click to expand/collapse", new Object[0]) + ". " + string;
                }
            }
            return string;
        }
        if (n2 == 0 && (n3 = this.convertRowToIndex(n)) != -1) {
            String string = "R/W";
            if (!this.attributesInfo[n3].isReadable()) {
                string = "W";
            } else if (!this.attributesInfo[n3].isWritable()) {
                string = "R";
            }
            String string2 = Resources.getText("TipDescrTypeModifier", this.attributesInfo[n3].getDescription(), Utils.getReadableClassName(this.attributesInfo[n3].getType()), string);
        }
        return null;
    }

    @Override
    public synchronized boolean isWritable(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].isWritable();
        }
        return false;
    }

    @Override
    public synchronized int getRowCount() {
        return super.getRowCount();
    }

    @Override
    public synchronized boolean isReadable(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].isReadable();
        }
        return false;
    }

    @Override
    public synchronized boolean isCellError(int n, int n2) {
        return this.isColumnEditable(n2) && this.unavailableAttributes.containsKey(this.getValueName(n));
    }

    @Override
    public synchronized boolean isAttributeViewable(int n, int n2) {
        Object object;
        boolean bl = false;
        if (n2 == 1 && (object = this.getModel().getValueAt(n, n2)) instanceof ZoomedCell) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAttributes(XMBean xMBean, MBeanInfo mBeanInfo) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3;
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        block18: {
            Object object;
            Object object2;
            int n;
            if (xMBean == null) {
                return;
            }
            mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            hashMap3 = new HashMap<String, Object>(mBeanAttributeInfoArray.length);
            hashMap2 = new HashMap<String, Object>(mBeanAttributeInfoArray.length);
            hashMap = new HashMap<String, Object>(mBeanAttributeInfoArray.length);
            HashMap hashMap4 = new HashMap(mBeanAttributeInfoArray.length);
            AttributeList attributeList = null;
            try {
                attributeList = xMBean.getAttributes(mBeanAttributeInfoArray);
            }
            catch (Exception exception) {
                attributeList = new AttributeList();
                for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                    object2 = null;
                    try {
                        object2 = mBeanAttributeInfoArray[n].getName();
                        object = xMBean.getAttribute((String)object2);
                        attributeList.add(new Attribute((String)object2, object));
                        continue;
                    }
                    catch (Exception exception2) {
                        if (!mBeanAttributeInfoArray[n].isReadable()) continue;
                        hashMap2.put((String)object2, Utils.getActualException(exception2).toString());
                    }
                }
            }
            try {
                int n2 = attributeList.size();
                for (n = 0; n < n2; ++n) {
                    object2 = (Attribute)attributeList.get(n);
                    if (this.isViewable((Attribute)object2)) {
                        hashMap.put(((Attribute)object2).getName(), ((Attribute)object2).getValue());
                        continue;
                    }
                    hashMap3.put(((Attribute)object2).getName(), ((Attribute)object2).getValue());
                }
                if (n2 >= mBeanAttributeInfoArray.length) break block18;
                for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                    object2 = mBeanAttributeInfoArray[n];
                    if (hashMap3.containsKey(((MBeanFeatureInfo)object2).getName()) || hashMap.containsKey(((MBeanFeatureInfo)object2).getName()) || hashMap2.containsKey(((MBeanFeatureInfo)object2).getName()) || !((MBeanAttributeInfo)object2).isReadable()) continue;
                    try {
                        object = xMBean.getAttribute(((MBeanFeatureInfo)object2).getName());
                        hashMap3.put(((MBeanFeatureInfo)object2).getName(), object);
                        continue;
                    }
                    catch (Exception exception) {
                        hashMap2.put(((MBeanFeatureInfo)object2).getName(), Utils.getActualException(exception).toString());
                    }
                }
            }
            catch (Exception exception) {
                for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                    object2 = mBeanAttributeInfoArray[n];
                    if (!((MBeanAttributeInfo)object2).isReadable()) continue;
                    hashMap2.put(((MBeanFeatureInfo)object2).getName(), Utils.getActualException(exception).toString());
                }
            }
        }
        XMBeanAttributes xMBeanAttributes = this;
        synchronized (xMBeanAttributes) {
            this.mbean = xMBean;
            this.mbeanInfo = mBeanInfo;
            this.attributesInfo = mBeanAttributeInfoArray;
            this.attributes = hashMap3;
            this.unavailableAttributes = hashMap2;
            this.viewableAttributes = hashMap;
            if (this.isEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            defaultTableModel.removeTableModelListener(this.attributesListener);
            this.emptyTable();
            this.addTableData(defaultTableModel, mBeanAttributeInfoArray, hashMap3, hashMap2, hashMap);
            defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
            defaultTableModel.addTableModelListener(this.attributesListener);
        }
    }

    void collapse(String string, Component component) {
        int n = this.getSelectedRow();
        Object object = this.getModel().getValueAt(n, 1);
        if (object instanceof ZoomedCell) {
            ZoomedCell zoomedCell = (ZoomedCell)object;
            zoomedCell.reset();
            this.setRowHeight(n, zoomedCell.getHeight());
            this.editCellAt(n, 1);
            this.invalidate();
            this.repaint();
        }
    }

    ZoomedCell updateZoomedCell(int n, int n2) {
        Object object = this.getModel().getValueAt(n, 1);
        ZoomedCell zoomedCell = null;
        if (object instanceof ZoomedCell) {
            zoomedCell = (ZoomedCell)object;
            if (!zoomedCell.isInited()) {
                String string;
                Object object2 = zoomedCell.getValue();
                Component component = this.viewer.createAttributeViewer(object2, this.mbean, string = (String)this.getModel().getValueAt(n, 0), this);
                if (component != null) {
                    if (this.rowMinHeight == -1) {
                        this.rowMinHeight = this.getRowHeight(n);
                    }
                    zoomedCell.init(super.getCellRenderer(n, n2), component, this.rowMinHeight);
                    XDataViewer.registerForMouseEvent(component, this.mouseListener);
                } else {
                    return zoomedCell;
                }
            }
            zoomedCell.switchState();
            this.setRowHeight(n, zoomedCell.getHeight());
            if (!zoomedCell.isMaximized()) {
                this.editCellAt(n, 1);
            }
            this.invalidate();
            this.repaint();
        }
        return zoomedCell;
    }

    public void refreshAttributes() {
        this.loadAttributes(this.mbean, this.mbeanInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emptyTable() {
        XMBeanAttributes xMBeanAttributes = this;
        synchronized (xMBeanAttributes) {
            ((DefaultTableModel)this.getModel()).removeTableModelListener(this.attributesListener);
            super.emptyTable();
        }
    }

    private boolean isViewable(Attribute attribute) {
        Object object = attribute.getValue();
        return XDataViewer.isViewableValue(object);
    }

    synchronized void removeAttributes() {
        this.attributes.clear();
        this.unavailableAttributes.clear();
        this.viewableAttributes.clear();
        this.mbean = null;
    }

    protected void addTableData(DefaultTableModel defaultTableModel, MBeanAttributeInfo[] mBeanAttributeInfoArray, HashMap<String, Object> hashMap, HashMap<String, Object> hashMap2, HashMap<String, Object> hashMap3) {
        Object[] objectArray = new Object[2];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            objectArray[0] = mBeanAttributeInfoArray[i].getName();
            if (hashMap2.containsKey(objectArray[0])) {
                objectArray[1] = Resources.getText("Unavailable", new Object[0]);
            } else if (hashMap3.containsKey(objectArray[0])) {
                objectArray[1] = hashMap3.get(objectArray[0]);
                objectArray[1] = new ZoomedCell(objectArray[1]);
            } else {
                objectArray[1] = hashMap.get(objectArray[0]);
            }
            defaultTableModel.addRow(objectArray);
            String string = null;
            if (objectArray[0] != null && (string = objectArray[0].toString()).length() > n) {
                n = string.length();
            }
            if (objectArray[1] == null || (string = objectArray[1].toString()).length() <= n2) continue;
            n2 = string.length();
        }
        this.updateColumnWidth(n, n2);
    }

    private void updateColumnWidth(int n, int n2) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if ((n *= 7) + (n2 *= 7) < (int)this.getPreferredScrollableViewportSize().getWidth()) {
            n2 = (int)this.getPreferredScrollableViewportSize().getWidth() - n;
        }
        tableColumnModel.getColumn(0).setPreferredWidth(50);
    }

    class AttributesListener
    implements TableModelListener {
        private Component component;

        public AttributesListener(Component component) {
            this.component = component;
        }

        public void tableChanged(final TableModelEvent tableModelEvent) {
            final TableModel tableModel = (TableModel)tableModelEvent.getSource();
            if (XMBeanAttributes.this.isColumnEditable(tableModelEvent.getColumn())) {
                XMBeanAttributes.this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            Object object = tableModel.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                            if (object instanceof String) {
                                object = Utils.createObjectFromString(XMBeanAttributes.this.getClassName(tableModelEvent.getFirstRow()), (String)object);
                            }
                            String string = XMBeanAttributes.this.getValueName(tableModelEvent.getFirstRow());
                            Attribute attribute = new Attribute(string, object);
                            XMBeanAttributes.this.mbean.setAttribute(attribute);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = Utils.getActualException(throwable);
                            String string = throwable2.getMessage() != null ? throwable2.getMessage() : throwable2.toString();
                            EventQueue.invokeLater(new ThreadDialog(AttributesListener.this.component, string + "\n", Resources.getText("Problem setting attribute", new Object[0]), 0));
                        }
                        XMBeanAttributes.this.refreshAttributes();
                    }
                });
            }
        }
    }

    class ZoomedCell {
        TableCellRenderer minRenderer;
        MaximizedCellRenderer maxRenderer;
        int minHeight;
        boolean minimized = true;
        boolean init = false;
        int type;
        Object value;

        ZoomedCell(Object object) {
            this.type = XDataViewer.getViewerType(object);
            this.value = object;
        }

        boolean isInited() {
            return this.init;
        }

        Object getValue() {
            return this.value;
        }

        void init(TableCellRenderer tableCellRenderer, Component component, int n) {
            this.minRenderer = tableCellRenderer;
            this.maxRenderer = new MaximizedCellRenderer(component);
            this.minHeight = n;
            this.init = true;
        }

        int getType() {
            return this.type;
        }

        void reset() {
            this.init = false;
            this.minimized = true;
        }

        void switchState() {
            this.minimized = !this.minimized;
        }

        boolean isMaximized() {
            return !this.minimized;
        }

        void minimize() {
            this.minimized = true;
        }

        void maximize() {
            this.minimized = false;
        }

        int getHeight() {
            if (this.minimized) {
                return this.minHeight;
            }
            return (int)this.maxRenderer.getComponent().getPreferredSize().getHeight();
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            if (this.value.getClass().isArray()) {
                String string = Utils.getArrayClassName(this.value.getClass().getName());
                int n = Array.getLength(this.value);
                return string + "[" + n + "]";
            }
            if (this.value instanceof CompositeData || this.value instanceof TabularData) {
                return this.value.getClass().getName();
            }
            return this.value.toString();
        }

        TableCellRenderer getRenderer() {
            if (this.minimized) {
                return this.minRenderer;
            }
            return this.maxRenderer;
        }
    }

    class MaximizedCellRenderer
    extends DefaultTableCellRenderer {
        Component comp;

        MaximizedCellRenderer(Component component) {
            this.comp = component;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }
    }

    class CellEditor
    extends XTextFieldEditor {
        CellEditor() {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ZoomedCell zoomedCell;
            Object object2;
            Object object3 = object;
            if (n2 == 1 && (object2 = XMBeanAttributes.this.getModel().getValueAt(n, n2)) instanceof ZoomedCell && (zoomedCell = (ZoomedCell)object2).getRenderer() instanceof MaximizedCellRenderer) {
                MaximizedCellRenderer maximizedCellRenderer = (MaximizedCellRenderer)zoomedCell.getRenderer();
                return maximizedCellRenderer.getComponent();
            }
            return super.getTableCellEditorComponent(jTable, object3, bl, n, n2);
        }
    }

    class AttributesMouseListener
    extends MouseAdapter {
        AttributesMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
                int n = XMBeanAttributes.this.getSelectedRow();
                int n2 = XMBeanAttributes.this.getSelectedColumn();
                if (n2 != 1) {
                    return;
                }
                if (n2 == -1 || n == -1) {
                    return;
                }
                XMBeanAttributes.this.updateZoomedCell(n, n2);
            }
        }
    }
}

