/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;

public class AbstractIndexWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(ConfigurationImpl configurationImpl, String string, String string2, String string3, IndexBuilder indexBuilder) throws IOException {
        super(configurationImpl, string, string2, string3);
        this.indexbuilder = indexBuilder;
    }

    protected AbstractIndexWriter(ConfigurationImpl configurationImpl, String string, IndexBuilder indexBuilder) throws IOException {
        super(configurationImpl, string);
        this.indexbuilder = indexBuilder;
    }

    protected void navLinkIndex() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Index");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void generateContents(Character c, List list) {
        this.anchor("_" + c + "_");
        this.h2();
        this.bold(c.toString());
        this.h2End();
        this.dl();
        for (int i = 0; i < list.size(); ++i) {
            Doc doc = (Doc)list.get(i);
            if (doc instanceof MemberDoc) {
                this.printDescription((MemberDoc)doc);
                continue;
            }
            if (doc instanceof ClassDoc) {
                this.printDescription((ClassDoc)doc);
                continue;
            }
            if (!(doc instanceof PackageDoc)) continue;
            this.printDescription((PackageDoc)doc);
        }
        this.dlEnd();
        this.hr();
    }

    protected void printDescription(PackageDoc packageDoc) {
        this.dt();
        this.printPackageLink(packageDoc, Util.getPackageName(packageDoc), true);
        this.print(" - ");
        this.print(this.configuration.getText("doclet.package") + " " + packageDoc.name());
        this.dd();
        this.printSummaryComment(packageDoc);
    }

    protected void printDescription(ClassDoc classDoc) {
        this.dt();
        this.printLink(new LinkInfoImpl(5, classDoc, true));
        this.print(" - ");
        this.printClassInfo(classDoc);
        this.dd();
        this.printComment(classDoc);
    }

    protected void printClassInfo(ClassDoc classDoc) {
        this.print(this.configuration.getText("doclet.in", Util.getTypeName(this.configuration, classDoc, false), this.getPackageLink(classDoc.containingPackage(), Util.getPackageName(classDoc.containingPackage()), false)));
    }

    protected void printDescription(MemberDoc memberDoc) {
        String string;
        String string2 = string = memberDoc instanceof ExecutableMemberDoc ? memberDoc.name() + ((ExecutableMemberDoc)memberDoc).flatSignature() : memberDoc.name();
        if (string.indexOf("<") != -1 || string.indexOf(">") != -1) {
            string = Util.escapeHtmlChars(string);
        }
        ClassDoc classDoc = memberDoc.containingClass();
        this.dt();
        this.printDocLink(5, memberDoc, string, true);
        this.println(" - ");
        this.printMemberDesc(memberDoc);
        this.println();
        this.dd();
        this.printComment(memberDoc);
        this.println();
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        if (Util.isDeprecated(programElementDoc)) {
            this.boldText("doclet.Deprecated");
            this.space();
            Tag[] tagArray = programElementDoc.tags("deprecated");
            if (tagArray.length > 0) {
                this.printInlineDeprecatedComment(programElementDoc, tagArray[0]);
            }
        } else {
            for (ClassDoc classDoc = programElementDoc.containingClass(); classDoc != null; classDoc = classDoc.containingClass()) {
                if (!Util.isDeprecated(classDoc)) continue;
                this.boldText("doclet.Deprecated");
                this.space();
                break;
            }
            this.printSummaryComment(programElementDoc);
        }
    }

    protected void printMemberDesc(MemberDoc memberDoc) {
        ClassDoc classDoc = memberDoc.containingClass();
        String string = Util.getTypeName(this.configuration, classDoc, true) + " " + this.getPreQualifiedClassLink(5, classDoc, false);
        if (memberDoc.isField()) {
            if (memberDoc.isStatic()) {
                this.printText("doclet.Static_variable_in", string);
            } else {
                this.printText("doclet.Variable_in", string);
            }
        } else if (memberDoc.isConstructor()) {
            this.printText("doclet.Constructor_for", string);
        } else if (memberDoc.isMethod()) {
            if (memberDoc.isStatic()) {
                this.printText("doclet.Static_method_in", string);
            } else {
                this.printText("doclet.Method_in", string);
            }
        }
    }
}

