/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.ZoneInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneInfoFile {
    public static final byte[] JAVAZI_LABEL = new byte[]{106, 97, 118, 97, 122, 105, 0};
    private static final int JAVAZI_LABEL_LENGTH = JAVAZI_LABEL.length;
    public static final byte JAVAZI_VERSION = 1;
    public static final byte TAG_RawOffset = 1;
    public static final byte TAG_LastDSTSaving = 2;
    public static final byte TAG_CRC32 = 3;
    public static final byte TAG_Transition = 4;
    public static final byte TAG_Offset = 5;
    public static final byte TAG_SimpleTimeZone = 6;
    public static final byte TAG_GMTOffsetWillChange = 7;
    public static final String JAVAZM_FILE_NAME = "ZoneInfoMappings";
    public static final byte[] JAVAZM_LABEL = new byte[]{106, 97, 118, 97, 122, 109, 0};
    private static final int JAVAZM_LABEL_LENGTH = JAVAZM_LABEL.length;
    public static final byte JAVAZM_VERSION = 1;
    public static final byte TAG_ZoneIDs = 64;
    public static final byte TAG_RawOffsets = 65;
    public static final byte TAG_RawOffsetIndices = 66;
    public static final byte TAG_ZoneAliases = 67;
    public static final byte TAG_TZDataVersion = 68;
    public static final byte TAG_ExcludedZones = 69;
    private static Map<String, ZoneInfo> zoneInfoObjects = null;
    private static volatile SoftReference<List<String>> zoneIDs = null;
    private static volatile SoftReference<List<String>> excludedIDs = null;
    private static volatile boolean hasNoExcludeList = false;
    private static volatile SoftReference<byte[]> rawOffsetIndices = null;
    private static volatile SoftReference<int[]> rawOffsets = null;
    private static volatile SoftReference<byte[]> zoneInfoMappings = null;

    public static String getFileName(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replace('/', File.separatorChar);
    }

    public static ZoneInfo getCustomTimeZone(String string, int n) {
        String string2 = ZoneInfoFile.toCustomID(n);
        ZoneInfo zoneInfo = ZoneInfoFile.getFromCache(string2);
        if (zoneInfo == null) {
            zoneInfo = new ZoneInfo(string2, n);
            zoneInfo = ZoneInfoFile.addToCache(string2, zoneInfo);
            if (!string2.equals(string)) {
                zoneInfo = ZoneInfoFile.addToCache(string, zoneInfo);
            }
        }
        return (ZoneInfo)zoneInfo.clone();
    }

    public static String toCustomID(int n) {
        char c;
        int n2 = n / 60000;
        if (n2 >= 0) {
            c = '+';
        } else {
            c = '-';
            n2 = -n2;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        char[] cArray = new char[]{'G', 'M', 'T', c, '0', '0', ':', '0', '0'};
        if (n3 >= 10) {
            cArray[4] = (char)(cArray[4] + n3 / 10);
        }
        cArray[5] = (char)(cArray[5] + n3 % 10);
        if (n4 != 0) {
            cArray[7] = (char)(cArray[7] + n4 / 10);
            cArray[8] = (char)(cArray[8] + n4 % 10);
        }
        return new String(cArray);
    }

    public static ZoneInfo getZoneInfo(String string) {
        ZoneInfo zoneInfo = ZoneInfoFile.getFromCache(string);
        if (zoneInfo == null) {
            zoneInfo = ZoneInfoFile.createZoneInfo(string);
            if (zoneInfo == null) {
                return null;
            }
            zoneInfo = ZoneInfoFile.addToCache(string, zoneInfo);
        }
        return (ZoneInfo)zoneInfo.clone();
    }

    static synchronized ZoneInfo getFromCache(String string) {
        if (zoneInfoObjects == null) {
            return null;
        }
        return zoneInfoObjects.get(string);
    }

    static synchronized ZoneInfo addToCache(String string, ZoneInfo zoneInfo) {
        if (zoneInfoObjects == null) {
            zoneInfoObjects = new HashMap<String, ZoneInfo>();
        } else {
            ZoneInfo zoneInfo2 = zoneInfoObjects.get(string);
            if (zoneInfo2 != null) {
                return zoneInfo2;
            }
        }
        zoneInfoObjects.put(string, zoneInfo);
        return zoneInfo;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ZoneInfo createZoneInfo(String var0) {
        var1_1 = ZoneInfoFile.readZoneInfoFile(ZoneInfoFile.getFileName(var0));
        if (var1_1 == null) {
            return null;
        }
        for (var2_2 = 0; var2_2 < ZoneInfoFile.JAVAZI_LABEL.length; ++var2_2) {
            if (var1_1[var2_2] == ZoneInfoFile.JAVAZI_LABEL[var2_2]) continue;
            System.err.println("ZoneInfo: wrong magic number: " + var0);
            return null;
        }
        if (var1_1[var2_2++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + var1_1[var2_2 - 1] + "): " + var0);
            return null;
        }
        var3_3 = var1_1.length;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = false;
        var8_8 = null;
        var9_9 = null;
        var10_10 = null;
lbl19:
        // 5 sources

        try {
            block12: while (var2_2 < var3_3) {
                var11_11 = var1_1[var2_2++];
                if (var3_3 < var2_2 + (var12_13 = ((var1_1[var2_2++] & 255) << 8) + (var1_1[var2_2++] & 255))) break;
                switch (var11_11) {
                    case 3: {
                        var13_14 = var1_1[var2_2++] & 255;
                        var13_14 = (var13_14 << 8) + (var1_1[var2_2++] & 255);
                        var13_14 = (var13_14 << 8) + (var1_1[var2_2++] & 255);
                        var6_6 = var13_14 = (var13_14 << 8) + (var1_1[var2_2++] & 255);
                        ** GOTO lbl19
                    }
                    case 2: {
                        var13_14 = (short)(var1_1[var2_2++] & 255);
                        var13_14 = (short)((var13_14 << 8) + (var1_1[var2_2++] & 255));
                        var5_5 = var13_14 * 1000;
                        ** GOTO lbl19
                    }
                    case 1: {
                        var13_14 = var1_1[var2_2++] & 255;
                        var13_14 = (var13_14 << 8) + (var1_1[var2_2++] & 255);
                        var13_14 = (var13_14 << 8) + (var1_1[var2_2++] & 255);
                        var4_4 = var13_14 = (var13_14 << 8) + (var1_1[var2_2++] & 255);
                        ** GOTO lbl19
                    }
                    case 4: {
                        var13_14 = var12_13 / 8;
                        var8_8 = new long[var13_14];
                        for (var14_15 = 0; var14_15 < var13_14; ++var14_15) {
                            var15_16 = var1_1[var2_2++] & 255;
                            var15_16 = (var15_16 << 8) + (long)(var1_1[var2_2++] & 255);
                            var15_16 = (var15_16 << 8) + (long)(var1_1[var2_2++] & 255);
                            var15_16 = (var15_16 << 8) + (long)(var1_1[var2_2++] & 255);
                            var15_16 = (var15_16 << 8) + (long)(var1_1[var2_2++] & 255);
                            var15_16 = (var15_16 << 8) + (long)(var1_1[var2_2++] & 255);
                            var15_16 = (var15_16 << 8) + (long)(var1_1[var2_2++] & 255);
                            var8_8[var14_15] = var15_16 = (var15_16 << 8) + (long)(var1_1[var2_2++] & 255);
                        }
                        continue block12;
                    }
                    case 5: {
                        var13_14 = var12_13 / 4;
                        var9_9 = new int[var13_14];
                        for (var14_15 = 0; var14_15 < var13_14; ++var14_15) {
                            var15_17 = var1_1[var2_2++] & 255;
                            var15_17 = (var15_17 << 8) + (var1_1[var2_2++] & 255);
                            var15_17 = (var15_17 << 8) + (var1_1[var2_2++] & 255);
                            var9_9[var14_15] = var15_17 = (var15_17 << 8) + (var1_1[var2_2++] & 255);
                        }
                        continue block12;
                    }
                    case 6: {
                        if (var12_13 != 32 && var12_13 != 40) {
                            System.err.println("ZoneInfo: wrong SimpleTimeZone parameter size");
                            return null;
                        }
                        var13_14 = var12_13 / 4;
                        var10_10 = new int[var13_14];
                        for (var14_15 = 0; var14_15 < var13_14; ++var14_15) {
                            var15_18 = var1_1[var2_2++] & 255;
                            var15_18 = (var15_18 << 8) + (var1_1[var2_2++] & 255);
                            var15_18 = (var15_18 << 8) + (var1_1[var2_2++] & 255);
                            var10_10[var14_15] = var15_18 = (var15_18 << 8) + (var1_1[var2_2++] & 255);
                        }
                        continue block12;
                    }
                    case 7: {
                        if (var12_13 != 1) {
                            System.err.println("ZoneInfo: wrong byte length for TAG_GMTOffsetWillChange");
                        }
                        var7_7 = var1_1[var2_2++] == 1;
                        ** GOTO lbl19
                    }
                }
                System.err.println("ZoneInfo: unknown tag < " + var11_11 + ">. ignored.");
                var2_2 += var12_13;
            }
        }
        catch (Exception var11_12) {
            System.err.println("ZoneInfo: corrupted zoneinfo file: " + var0);
            return null;
        }
        if (var2_2 != var3_3) {
            System.err.println("ZoneInfo: wrong file size: " + var0);
            return null;
        }
        return new ZoneInfo(var0, var4_4, var5_5, var6_6, var8_8, var9_9, var10_10, var7_7);
    }

    static List<String> getZoneIDs() {
        List<String> list;
        block8: {
            list = null;
            SoftReference<List<String>> softReference = zoneIDs;
            if (softReference != null && (list = softReference.get()) != null) {
                return list;
            }
            byte[] byArray = null;
            byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 64: {
                            int n3 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            list = new ArrayList<String>(n3);
                            for (int j = 0; j < n3; ++j) {
                                byte by2 = byArray[i++];
                                list.add(new String(byArray, i, (int)by2, "US-ASCII"));
                                i += by2;
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        zoneIDs = new SoftReference<List<String>>(list);
        return list;
    }

    static Map<String, String> getZoneAliases() {
        HashMap<String, String> hashMap;
        block7: {
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            hashMap = null;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 67: {
                            int n3 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            hashMap = new HashMap<String, String>(n3);
                            for (int j = 0; j < n3; ++j) {
                                byte by2 = byArray[i++];
                                String string = new String(byArray, i, (int)by2, "US-ASCII");
                                i += by2;
                                by2 = byArray[i++];
                                String string2 = new String(byArray, i, (int)by2, "US-ASCII");
                                i += by2;
                                hashMap.put(string, string2);
                            }
                            break block7;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        return hashMap;
    }

    static List<String> getExcludedZones() {
        List<String> list;
        block11: {
            if (hasNoExcludeList) {
                return null;
            }
            list = null;
            SoftReference<List<String>> softReference = excludedIDs;
            if (softReference != null && (list = softReference.get()) != null) {
                return list;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 69: {
                            int n3 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            list = new ArrayList<String>();
                            for (int j = 0; j < n3; ++j) {
                                byte by2 = byArray[i++];
                                String string = new String(byArray, i, (int)by2, "US-ASCII");
                                i += by2;
                                list.add(string);
                            }
                            break block11;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        if (list != null) {
            excludedIDs = new SoftReference<List<String>>(list);
        } else {
            hasNoExcludeList = true;
        }
        return list;
    }

    static byte[] getRawOffsetIndices() {
        byte[] byArray;
        block8: {
            byArray = null;
            SoftReference<byte[]> softReference = rawOffsetIndices;
            if (softReference != null && (byArray = softReference.get()) != null) {
                return byArray;
            }
            byte[] byArray2 = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray2.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray2[i++];
                    n2 = ((byArray2[i++] & 0xFF) << 8) + (byArray2[i++] & 0xFF);
                    switch (by) {
                        case 66: {
                            byArray = new byte[n2];
                            for (int j = 0; j < n2; ++j) {
                                byArray[j] = byArray2[i++];
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsetIndices = new SoftReference<byte[]>(byArray);
        return byArray;
    }

    static int[] getRawOffsets() {
        int[] nArray;
        block8: {
            nArray = null;
            SoftReference<int[]> softReference = rawOffsets;
            if (softReference != null && (nArray = softReference.get()) != null) {
                return nArray;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 65: {
                            int n3 = n2 / 4;
                            nArray = new int[n3];
                            for (int j = 0; j < n3; ++j) {
                                int n4 = byArray[i++] & 0xFF;
                                n4 = (n4 << 8) + (byArray[i++] & 0xFF);
                                n4 = (n4 << 8) + (byArray[i++] & 0xFF);
                                nArray[j] = n4 = (n4 << 8) + (byArray[i++] & 0xFF);
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsets = new SoftReference<int[]>(nArray);
        return nArray;
    }

    private static byte[] getZoneInfoMappings() {
        int n;
        byte[] byArray;
        SoftReference<byte[]> softReference = zoneInfoMappings;
        if (softReference != null && (byArray = softReference.get()) != null) {
            return byArray;
        }
        byArray = ZoneInfoFile.readZoneInfoFile(JAVAZM_FILE_NAME);
        if (byArray == null) {
            return null;
        }
        for (n = 0; n < JAVAZM_LABEL.length; ++n) {
            if (byArray[n] == JAVAZM_LABEL[n]) continue;
            System.err.println("ZoneInfo: wrong magic number: ZoneInfoMappings");
            return null;
        }
        if (byArray[n++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + byArray[n - 1] + "): " + JAVAZM_FILE_NAME);
            return null;
        }
        zoneInfoMappings = new SoftReference<byte[]>(byArray);
        return byArray;
    }

    private static byte[] readZoneInfoFile(String string) {
        byte[] byArray;
        block2: {
            byArray = null;
            try {
                String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
                final String string3 = string2 + File.separator + "lib" + File.separator + "zi" + File.separator + string;
                byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        File file = new File(string3);
                        FileInputStream fileInputStream = new FileInputStream(file);
                        int n = (int)file.length();
                        byte[] byArray = new byte[n];
                        if (fileInputStream.read(byArray) != n) {
                            fileInputStream.close();
                            throw new IOException("read error on " + string3);
                        }
                        fileInputStream.close();
                        return byArray;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof FileNotFoundException && !JAVAZM_FILE_NAME.equals(string)) break block2;
                System.err.println("ZoneInfo: " + exception.getMessage());
            }
        }
        return byArray;
    }
}

