/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  int opcode;   /* Either TK_GLOB or TK_LIKE */
  int not;      /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 225
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct {int value; int mask;} yy47;
  TriggerStep* yy91;
  Token yy98;
  Select* yy107;
  struct TrigEvent yy146;
  ExprList* yy210;
  Expr* yy258;
  SrcList* yy259;
  IdList* yy272;
  int yy284;
  struct AttachKey yy292;
  struct LikeOp yy342;
  struct LimitVal yy404;
  int yy449;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 537
#define YYNRULE 292
#define YYERRORSYMBOL 130
#define YYERRSYMDT yy449
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   257,  325,  255,  138,  140,  142,  144,  146,  148,  150,
 /*    10 */   152,  154,  156,   89,   87,   88,  159,   12,    4,    6,
 /*    20 */   158,  537,   38,   24,  830,    1,  536,    3,  329,  488,
 /*    30 */   534,  535,  319,   50,  124,  112,  160,  169,  174,  179,
 /*    40 */   168,  173,  134,  136,  128,  130,  126,  132,  138,  140,
 /*    50 */   142,  144,  146,  148,  150,  152,  154,  156,   26,   73,
 /*    60 */   384,  256,   39,   58,   64,   66,  299,  330,  612,  611,
 /*    70 */   351,   30,   92,  332,  326,  159,   13,   14,  353,  158,
 /*    80 */     5,  355,  361,  366,  499,  146,  148,  150,  152,  154,
 /*    90 */   156,   12,  369,  124,  112,  160,  169,  174,  179,  168,
 /*   100 */   173,  134,  136,  128,  130,  126,  132,  138,  140,  142,
 /*   110 */   144,  146,  148,  150,  152,  154,  156,  128,  130,  126,
 /*   120 */   132,  138,  140,  142,  144,  146,  148,  150,  152,  154,
 /*   130 */   156,  659,  353,  244,   62,  355,  361,  366,   79,   12,
 /*   140 */    63,   98,   96,  289,  159,  280,  369,  349,  158,  181,
 /*   150 */    13,   14,   27,   12,  546,  383,   32,   10,  368,  273,
 /*   160 */   515,  765,  124,  112,  160,  169,  174,  179,  168,  173,
 /*   170 */   134,  136,  128,  130,  126,  132,  138,  140,  142,  144,
 /*   180 */   146,  148,  150,  152,  154,  156,  810,  349,   47,   73,
 /*   190 */   222,  763,  223,  114,  246,   31,   32,   48,   13,   14,
 /*   200 */    74,  274,  252,  166,  175,  180,  275,  304,   49,    8,
 /*   210 */   255,   45,   13,   14,  159,  290,  350,  382,  158,  245,
 /*   220 */   441,   46,  378,  183,  247,  185,  186,   15,   16,   17,
 /*   230 */    73,  205,  124,  112,  160,  169,  174,  179,  168,  173,
 /*   240 */   134,  136,  128,  130,  126,  132,  138,  140,  142,  144,
 /*   250 */   146,  148,  150,  152,  154,  156,  542,  306,  438,  159,
 /*   260 */    98,   96,  332,  158,  272,  475,  447,  437,   12,  256,
 /*   270 */   288,   12,  304,  339,  287,   50,   77,  124,  112,  160,
 /*   280 */   169,  174,  179,  168,  173,  134,  136,  128,  130,  126,
 /*   290 */   132,  138,  140,  142,  144,  146,  148,  150,  152,  154,
 /*   300 */   156,  547,   36,  335,   39,   58,   64,   66,  299,  330,
 /*   310 */    35,  334,  291,  545,  114,  332,  114,  329,   12,  625,
 /*   320 */   353,  187,  306,  355,  361,  366,  422,   13,   14,  159,
 /*   330 */    13,   14,  184,  158,  369,  636,  188,  259,  188,  764,
 /*   340 */    91,   87,   88,  100,   87,   88,  219,  124,  112,  160,
 /*   350 */   169,  174,  179,  168,  173,  134,  136,  128,  130,  126,
 /*   360 */   132,  138,  140,  142,  144,  146,  148,  150,  152,  154,
 /*   370 */   156,  297,  282,  114,  292,   51,  237,   13,   14,  150,
 /*   380 */   152,  154,  156,  114,   12,  225,   53,  225,  159,  166,
 /*   390 */   175,  180,  158,  380,  303,  111,  433,  658,   69,   92,
 /*   400 */   379,  183,   92,  185,  186,  111,  124,  112,  160,  169,
 /*   410 */   174,  179,  168,  173,  134,  136,  128,  130,  126,  132,
 /*   420 */   138,  140,  142,  144,  146,  148,  150,  152,  154,  156,
 /*   430 */   103,  230,  561,  159,  773,   12,  286,  158,  631,  534,
 /*   440 */   535,  105,  815,   13,   14,  166,  175,  180,  203,  808,
 /*   450 */   215,  124,  112,  160,  169,  174,  179,  168,  173,  134,
 /*   460 */   136,  128,  130,  126,  132,  138,  140,  142,  144,  146,
 /*   470 */   148,  150,  152,  154,  156,    2,    3,  183,  159,  185,
 /*   480 */   186,  813,  158,   43,   44,  569,   33,  633,   41,  348,
 /*   490 */   340,  413,  415,  414,   13,   14,  124,  112,  160,  169,
 /*   500 */   174,  179,  168,  173,  134,  136,  128,  130,  126,  132,
 /*   510 */   138,  140,  142,  144,  146,  148,  150,  152,  154,  156,
 /*   520 */   249,  336,  697,  159,  337,  338,  183,  158,  185,  186,
 /*   530 */    56,   57,  183,   11,  185,  186,  183,  416,  185,  186,
 /*   540 */   402,  124,  112,  160,  169,  174,  179,  168,  173,  134,
 /*   550 */   136,  128,  130,  126,  132,  138,  140,  142,  144,  146,
 /*   560 */   148,  150,  152,  154,  156,  342,   87,   88,  159,  345,
 /*   570 */    87,   88,  158,   98,   96,  183,  404,  185,  186,  240,
 /*   580 */     9,  183,   92,  185,  186,  802,  124,  177,  160,  169,
 /*   590 */   174,  179,  168,  173,  134,  136,  128,  130,  126,  132,
 /*   600 */   138,  140,  142,  144,  146,  148,  150,  152,  154,  156,
 /*   610 */   787,  341,  257,  159,  255,  255,  183,  158,  185,  186,
 /*   620 */    94,   95,  480,  518,   92,  307,  314,  316,   92,  548,
 /*   630 */   325,  171,  112,  160,  169,  174,  179,  168,  173,  134,
 /*   640 */   136,  128,  130,  126,  132,  138,  140,  142,  144,  146,
 /*   650 */   148,  150,  152,  154,  156,  255,   25,  486,  159,  482,
 /*   660 */   170,  358,  158,   19,  241,  242,  252,  266,  513,  267,
 /*   670 */   259,  553,   72,  256,  256,  402,   68,  244,  160,  169,
 /*   680 */   174,  179,  168,  173,  134,  136,  128,  130,  126,  132,
 /*   690 */   138,  140,  142,  144,  146,  148,  150,  152,  154,  156,
 /*   700 */   207,  255,   72,  326,  780,  260,   68,  267,  514,   47,
 /*   710 */   189,  428,  388,  385,  256,  325,  259,   21,   48,  162,
 /*   720 */   395,   12,  114,  161,  516,  517,  195,  193,  294,   49,
 /*   730 */   207,  484,  209,  312,  191,   70,   71,  387,  246,  113,
 /*   740 */   189,  164,  165,   73,  198,  114,  363,  396,  114,  391,
 /*   750 */    73,  277,  529,  313,  436,  182,  195,  193,   72,  467,
 /*   760 */   256,  623,   68,  245,  191,   70,   71,  188,  163,  113,
 /*   770 */   188,  119,  120,  121,  122,  197,  114,  803,  691,   72,
 /*   780 */    13,   14,   92,   68,   73,   73,  207,   77,  326,   73,
 /*   790 */   199,  807,   99,  436,  452,  293,  189,  223,  474,  325,
 /*   800 */   309,  119,  120,  121,  122,  197,  423,  207,  221,  460,
 /*   810 */   434,  419,  195,  193,  418,   90,  224,  189,   77,  225,
 /*   820 */   191,   70,   71,   73,  442,  113,  420,  114,  325,  444,
 /*   830 */   372,  468,  114,  195,  193,  283,  325,  311,  310,  402,
 /*   840 */   470,  191,   70,   71,  114,    7,  113,   41,  460,  474,
 /*   850 */    18,   20,   22,  386,  296,  114,  457,  119,  120,  121,
 /*   860 */   122,  197,  766,  446,  521,  554,  123,  430,  444,   23,
 /*   870 */   531,  114,  326,  114,  114,  481,  114,  125,  119,  120,
 /*   880 */   121,  122,  197,  510,   72,  441,  114,  238,   68,  114,
 /*   890 */   508,  506,  114,  127,  114,  129,  131,  114,  133,  411,
 /*   900 */   412,  322,  114,  114,  114,  114,  407,  114,  135,  326,
 /*   910 */   660,  137,  207,  114,  139,  114,  141,  451,  114,  143,
 /*   920 */   114,  114,  189,  114,  145,  147,  149,  151,  114,  153,
 /*   930 */   489,  493,  437,  114,  114,  155,  479,  157,  195,  193,
 /*   940 */   167,   77,  176,  178,  114,  190,  191,   70,   71,  114,
 /*   950 */   192,  113,  114,  114,  114,  194,  196,  114,  691,  114,
 /*   960 */   269,  320,  343,  321,  344,  269,  204,  114,  359,  284,
 /*   970 */   321,  206,  114,  555,  216,  218,  220,  114,  364,  234,
 /*   980 */   321,  239,  660,  119,  120,  121,  122,  197,  373,  271,
 /*   990 */   321,  281,  114,  114,  367,  227,  227,  269,  431,  408,
 /*  1000 */   321,  503,  439,   44,  465,  473,  267,  471,  114,   77,
 /*  1010 */   402,  402,  402,  402,  455,  459,  265,  457,  402,  402,
 /*  1020 */   823,  417,  504,  507,  556,  471,   28,   29,  560,   37,
 /*  1030 */   472,   73,   34,   55,   40,   41,   42,   54,   59,   67,
 /*  1040 */   570,  571,   52,   75,   60,   78,  483,  485,  487,  491,
 /*  1050 */    61,   65,   76,  464,  495,  501,  101,  527,   77,  238,
 /*  1060 */   233,  235,   85,   93,   86,   80,   97,  238,  102,   81,
 /*  1070 */   104,   82,  108,  107,  109,  110,   83,  115,  497,   84,
 /*  1080 */   117,  116,  156,  172,  637,  217,  638,  118,  202,  226,
 /*  1090 */   639,  208,  106,  211,  227,  210,  213,  214,  212,  229,
 /*  1100 */   228,  231,  236,  223,  200,  243,  201,  251,  248,  250,
 /*  1110 */   254,  253,  232,  258,  261,  270,  264,  263,  262,  268,
 /*  1120 */   276,  278,  285,  295,  318,  279,  300,  303,  301,  305,
 /*  1130 */   333,  346,  298,  323,  327,  356,  357,  362,  370,  302,
 /*  1140 */   371,   53,  374,  394,  399,  354,  331,  375,  401,  409,
 /*  1150 */   308,  347,  315,  324,  406,  317,  405,  328,  795,  390,
 /*  1160 */   389,  392,  397,  410,  421,  800,  360,  381,  365,  393,
 /*  1170 */   398,  352,  376,  403,  801,  377,  400,  425,  426,  424,
 /*  1180 */   427,  429,  771,  432,  772,  435,  440,  698,  443,  794,
 /*  1190 */   445,  438,  809,  449,  699,  450,  453,  448,  454,  456,
 /*  1200 */   811,  458,  461,  462,  463,  469,  812,  814,  476,  630,
 /*  1210 */   478,  632,  779,  821,  490,  477,  690,  492,  494,  496,
 /*  1220 */   498,  693,  500,  505,  696,  509,  781,  511,  782,  783,
 /*  1230 */   466,  784,  785,  502,  512,  786,  520,  822,  519,  530,
 /*  1240 */   524,  824,  523,  825,  525,  528,  533,  828,  518,  518,
 /*  1250 */   518,  518,  518,  518,  522,  518,  526,  518,  518,  532,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    24,  139,   26,   72,   73,   74,   75,   76,   77,   78,
 /*    10 */    79,   80,   81,  154,  155,  156,   40,   26,  135,  136,
 /*    20 */    44,    0,  158,  140,  131,  132,  133,  134,  164,  146,
 /*    30 */     9,   10,  170,   60,   58,   59,   60,   61,   62,   63,
 /*    40 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    50 */    74,   75,   76,   77,   78,   79,   80,   81,   22,  176,
 /*    60 */    24,   85,   89,   90,   91,   92,   93,   94,   23,   23,
 /*    70 */    25,   25,  213,  100,  212,   40,   85,   86,   87,   44,
 /*    80 */     9,   90,   91,   92,  201,   76,   77,   78,   79,   80,
 /*    90 */    81,   26,  101,   58,   59,   60,   61,   62,   63,   64,
 /*   100 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   110 */    75,   76,   77,   78,   79,   80,   81,   68,   69,   70,
 /*   120 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   130 */    81,   23,   87,   25,   29,   90,   91,   92,  179,   26,
 /*   140 */    35,   76,   77,   23,   40,  186,  101,  139,   44,   22,
 /*   150 */    85,   86,  144,   26,    9,  147,  148,   12,  159,  146,
 /*   160 */    95,  126,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   170 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   180 */    76,   77,   78,   79,   80,   81,   17,  139,   18,  176,
 /*   190 */    23,   17,   25,  139,   86,  147,  148,   27,   85,   86,
 /*   200 */   146,  188,  189,  204,  205,  206,  193,   45,   38,  137,
 /*   210 */    26,   41,   85,   86,   40,  161,  168,  169,   44,  111,
 /*   220 */    51,   51,   60,  103,  111,  105,  106,   13,   14,   15,
 /*   230 */   176,  127,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   240 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   250 */    76,   77,   78,   79,   80,   81,    9,   95,   58,   40,
 /*   260 */    76,   77,  100,   44,   22,   96,   97,   98,   26,   85,
 /*   270 */   104,   26,   45,   89,  108,   60,  107,   58,   59,   60,
 /*   280 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   290 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   300 */    81,    9,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   310 */   157,  158,   23,    9,  139,  100,  139,  164,   26,  119,
 /*   320 */    87,   23,   95,   90,   91,   92,   21,   85,   86,   40,
 /*   330 */    85,   86,  104,   44,  101,  107,  161,  152,  161,   17,
 /*   340 */   154,  155,  156,  154,  155,  156,  127,   58,   59,   60,
 /*   350 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   360 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   370 */    81,   23,  187,  139,  199,   89,  199,   85,   86,   78,
 /*   380 */    79,   80,   81,  139,   26,  210,  100,  210,   40,  204,
 /*   390 */   205,  206,   44,  164,  165,  161,   91,   23,   22,  213,
 /*   400 */   171,  103,  213,  105,  106,  161,   58,   59,   60,   61,
 /*   410 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   420 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   430 */   196,  197,    9,   40,  129,   26,   78,   44,    9,    9,
 /*   440 */    10,  197,    9,   85,   86,  204,  205,  206,  126,   11,
 /*   450 */   128,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   460 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   470 */    77,   78,   79,   80,   81,  133,  134,  103,   40,  105,
 /*   480 */   106,    9,   44,  173,  174,  109,  149,    9,   95,  152,
 /*   490 */   153,   96,   97,   98,   85,   86,   58,   59,   60,   61,
 /*   500 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   510 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   520 */   111,  152,    9,   40,  155,  156,  103,   44,  105,  106,
 /*   530 */    13,   14,  103,  139,  105,  106,  103,   47,  105,  106,
 /*   540 */   139,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   550 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   560 */    77,   78,   79,   80,   81,  154,  155,  156,   40,  154,
 /*   570 */   155,  156,   44,   76,   77,  103,  175,  105,  106,   25,
 /*   580 */   138,  103,  213,  105,  106,   95,   58,   59,   60,   61,
 /*   590 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   600 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   610 */     9,   22,   24,   40,   26,   26,  103,   44,  105,  106,
 /*   620 */   121,  122,   20,   22,  213,   96,   97,   98,  213,    9,
 /*   630 */   139,   60,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   640 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   650 */    77,   78,   79,   80,   81,   26,  141,   55,   40,   57,
 /*   660 */    89,  170,   44,  138,  110,  188,  189,   23,   67,   25,
 /*   670 */   152,    9,   22,   85,   85,  139,   26,   25,   60,   61,
 /*   680 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   690 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   700 */    50,   26,   22,  212,    9,  187,   26,   25,  139,   18,
 /*   710 */    60,  175,   20,  146,   85,  139,  152,  138,   27,   40,
 /*   720 */   146,   26,  139,   44,  155,  156,   76,   77,   78,   38,
 /*   730 */    50,  129,   41,   32,   84,   85,   86,  142,   86,   89,
 /*   740 */    60,   62,   63,  176,  161,  139,  170,   55,  139,   57,
 /*   750 */   176,  187,  123,   52,  146,  146,   76,   77,   22,  146,
 /*   760 */    85,    9,   26,  111,   84,   85,   86,  161,   89,   89,
 /*   770 */   161,  121,  122,  123,  124,  125,  139,   95,    9,   22,
 /*   780 */    85,   86,  213,   26,  176,  176,   50,  107,  212,  176,
 /*   790 */   207,   11,   25,  146,   25,   23,   60,   25,  161,  139,
 /*   800 */    99,  121,  122,  123,  124,  125,  211,   50,  199,  201,
 /*   810 */   215,   28,   76,   77,   31,   48,  210,   60,  107,  210,
 /*   820 */    84,   85,   86,  176,  216,   89,   43,  139,  139,  221,
 /*   830 */   170,  120,  139,   76,   77,   78,  139,   88,   89,  139,
 /*   840 */   203,   84,   85,   86,  139,   11,   89,   95,  201,  161,
 /*   850 */    16,   17,   18,   19,  161,  139,  139,  121,  122,  123,
 /*   860 */   124,  125,  126,  216,   30,    9,  161,  170,  221,  138,
 /*   870 */    36,  139,  212,  139,  139,  175,  139,  161,  121,  122,
 /*   880 */   123,  124,  125,   49,   22,   51,  139,  118,   26,  139,
 /*   890 */    56,  203,  139,  161,  139,  161,  161,  139,  161,   53,
 /*   900 */    54,  212,  139,  139,  139,  139,  126,  139,  161,  212,
 /*   910 */    24,  161,   50,  139,  161,  139,  161,  200,  139,  161,
 /*   920 */   139,  139,   60,  139,  161,  161,  161,  161,  139,  161,
 /*   930 */    96,   97,   98,  139,  139,  161,  102,  161,   76,   77,
 /*   940 */   161,  107,  161,  161,  139,  161,   84,   85,   86,  139,
 /*   950 */   161,   89,  139,  139,  139,  161,  161,  139,    9,  139,
 /*   960 */   139,   23,   23,   25,   25,  139,  161,  139,   23,  139,
 /*   970 */    25,  161,  139,    9,  161,  161,  161,  139,   23,  161,
 /*   980 */    25,  161,   95,  121,  122,  123,  124,  125,   23,  161,
 /*   990 */    25,  161,  139,  139,  161,  109,  109,  139,   23,  161,
 /*  1000 */    25,  146,  173,  174,   23,   23,   25,   25,  139,  107,
 /*  1010 */   139,  139,  139,  139,  161,  161,  195,  139,  139,  139,
 /*  1020 */     9,  195,  120,   23,    9,   25,  145,   23,    9,  139,
 /*  1030 */   161,  176,  150,   42,  159,   95,   33,  167,   46,   22,
 /*  1040 */   109,  109,  159,  177,  160,  178,  175,  175,  175,  175,
 /*  1050 */   159,  159,  176,  195,  175,  175,  113,   46,  107,  118,
 /*  1060 */   116,  115,  185,  214,  117,  180,  214,  118,  114,  181,
 /*  1070 */    25,  182,   94,  160,   26,  151,  183,  109,  200,  184,
 /*  1080 */   109,  139,   81,   89,  107,  126,  107,  139,   17,  139,
 /*  1090 */   107,   22,  198,  174,  109,   23,  139,   23,   25,  143,
 /*  1100 */   139,  198,  114,   25,  208,  190,  209,  111,  139,  139,
 /*  1110 */   143,  139,  160,  139,  191,   95,   22,  112,  192,  139,
 /*  1120 */    23,  191,  109,   23,   22,  192,  139,  165,  162,  139,
 /*  1130 */   167,   23,  159,  198,  198,   46,   22,   22,   46,  163,
 /*  1140 */    22,  100,   93,   24,  217,  139,  151,  139,   95,   39,
 /*  1150 */   166,  152,  166,  160,  220,  166,  219,  160,   11,  143,
 /*  1160 */   139,  139,  139,   37,   47,   95,  159,  169,  159,  143,
 /*  1170 */   143,  169,  162,  143,   95,  163,  218,  139,  143,  129,
 /*  1180 */    95,   22,    9,  159,  129,   11,  172,  119,   17,    9,
 /*  1190 */     9,   58,   17,  139,  119,   99,  139,  172,   67,  181,
 /*  1200 */     9,   67,  119,  139,   22,   22,    9,    9,  110,    9,
 /*  1210 */   181,    9,    9,    9,  110,  139,    9,  181,  172,   99,
 /*  1220 */   181,    9,  119,   22,    9,  139,    9,  139,    9,    9,
 /*  1230 */   202,    9,    9,  202,  143,    9,   23,    9,  139,   34,
 /*  1240 */    24,    9,  152,    9,  139,  152,  139,    9,  224,  224,
 /*  1250 */   224,  224,  224,  224,  222,  224,  223,  224,  224,  222,
};
#define YY_SHIFT_USE_DFLT (-70)
static const short yy_shift_ofst[] = {
 /*     0 */   430,   21,  -70,  834,   71,  -70,  247,  214,  145,  304,
 /*    10 */   292,  620,  -70,  -70,  -70,  -70,  -70,  -70,  145,  662,
 /*    20 */   145,  856,  145,  964,   36, 1015,  245,   46, 1004, 1019,
 /*    30 */    -9,  -70,  675,  -70,  215,  -70,  245,  -27,  -70,  940,
 /*    40 */   -70, 1003,  170,  -70,  -70,  -70,  -70,  -70,  -70,  -70,
 /*    50 */   286,  940,  -70,  991,  -70,  517,  -70,  -70,  992,  105,
 /*    60 */   940,  -70,  -70,  -70,  940,  -70, 1017,  862,  376,  650,
 /*    70 */   931,  932,  680,  -70,  120,  951,  -70,  166,  -70,  554,
 /*    80 */   941,  946,  944,  943,  947,  -70,  497,  -70,  -70,  767,
 /*    90 */   497,  -70,  499,  -70,  -70,  -70,  499,  -70,  -70,  497,
 /*   100 */   -70,  954,  862, 1045,  862,  978,  105,  -70, 1048,  -70,
 /*   110 */   -70,  483,  862,  -70,  968,  245,  971,  245,  -70,  -70,
 /*   120 */   -70,  -70,  -70,  618,  862,  573,  862,  -69,  862,  -69,
 /*   130 */   862,  -69,  862,  -69,  862,   49,  862,   49,  862,    9,
 /*   140 */   862,    9,  862,    9,  862,    9,  862,  301,  862,  301,
 /*   150 */   862, 1001,  862, 1001,  862, 1001,  862,  -70,  -70,  -70,
 /*   160 */   679,  -70,  -70,  -70,  -70,  -70,  862,   49,  -70,  571,
 /*   170 */   -70,  994,  -70,  -70,  -70,  862,  528,  862,   49,  -70,
 /*   180 */   127,  680,  298,  228,  977,  979,  983,  -70,  483,  862,
 /*   190 */   618,  862,  -70,  862,  -70,  862,  -70,  736,   35,  959,
 /*   200 */   322, 1071,  -70,  862,  104,  862,  483, 1069,  691, 1072,
 /*   210 */   -70, 1073,  245, 1074,  -70,  862,  174,  862,  219,  862,
 /*   220 */   483,  167,  -70,  862,  -70,  -70,  985,  245,  -70,  -70,
 /*   230 */   978,  105,  -70,  862,  483,  988,  862, 1078,  862,  483,
 /*   240 */   -70,  -70,  652,  -70,  -70,  -70,  113,  -70,  409,  -70,
 /*   250 */   996,  -70,  242,  985,  588,  -70,  -70,  245,  -70,  -70,
 /*   260 */  1020, 1005,  -70, 1094,  245,  644,  -70,  245,  -70,  -70,
 /*   270 */   862,  483,  951,  374,  108, 1097,  588, 1020, 1005,  -70,
 /*   280 */   757,  -24,  -70,  -70, 1013,  358,  -70,  -70,  -70,  -70,
 /*   290 */   289,  -70,  772,  -70, 1100,  -70,  348,  940,  -70,  245,
 /*   300 */  1102,  -70,  227,  -70,  245,  -70,  529,  701,  -70,  749,
 /*   310 */   -70,  -70,  -70,  -70,  701,  -70,  701,  -70,  245,  938,
 /*   320 */   -70,  245,  978,  105,  -70,  -70,  978,  105,  -70,  -70,
 /*   330 */  1048,  -70,  991,  -70,  -70,  184,  -70,  -70,  -70,  -70,
 /*   340 */   589,  497,  939,  -70,  497, 1108,  -70,  -70,  -70,  -70,
 /*   350 */    45,  233,  -70,  245,  -70, 1089, 1114,  245,  945,  940,
 /*   360 */   -70, 1115,  245,  955,  940,  -70,  862,  393,  -70, 1092,
 /*   370 */  1118,  245,  965, 1049,  245, 1102,  -70,  162, 1041,  -70,
 /*   380 */   -70,  -70,  -70,  -70,  951,  423,  305,  692,  245,  985,
 /*   390 */   -70,  245,  886, 1119,  951,  429,  245,  985,  783,  395,
 /*   400 */  1053,  245,  985,  -70, 1110,  780, 1147,  862,  438, 1126,
 /*   410 */   846,  -70,  -70, 1070, 1079,  490,  245,  682,  -70,  -70,
 /*   420 */  1117,  -70,  -70, 1050,  245,  887, 1085,  245, 1159,  245,
 /*   430 */   975,  752, 1173, 1055, 1174,  169,  433,  200,  170,  -70,
 /*   440 */  1068, 1075, 1171, 1180, 1181,  169, 1175, 1133,  245, 1096,
 /*   450 */   245,  769,  245, 1131,  862,  483, 1191, 1134,  862,  483,
 /*   460 */  1083,  245, 1182,  245,  981,  -70,  711,  472, 1183,  862,
 /*   470 */   982,  862,  483, 1197,  483, 1098,  245,  949, 1198,  602,
 /*   480 */   245, 1200,  245, 1202,  245, 1203,  245, 1204,  478, 1104,
 /*   490 */   245,  949, 1207, 1133,  245, 1120,  245,  769, 1212, 1103,
 /*   500 */   245, 1182,  902,  513, 1201,  862, 1000, 1215,  695, 1217,
 /*   510 */   245,  985,  601,   65, 1219, 1220, 1222, 1223,  245, 1213,
 /*   520 */  1226, 1205,  675, 1216,  245, 1011, 1228,  629, 1232, 1234,
 /*   530 */   -70, 1205,  245, 1238,  -70,  -70,  -70,
};
#define YY_REDUCE_USE_DFLT (-142)
static const short yy_reduce_ofst[] = {
 /*     0 */  -107,  342, -142, -117, -142, -142, -142,   72,  442, -142,
 /*    10 */   394, -142, -142, -142, -142, -142, -142, -142,  525, -142,
 /*    20 */   579, -142,  731, -142,  515, -142,    8,  881, -142, -142,
 /*    30 */    48, -142,  337,  882,  153, -142,  890, -136, -142,  875,
 /*    40 */  -142, -142,  310, -142, -142, -142, -142, -142, -142, -142,
 /*    50 */  -142,  883, -142,  870, -142, -142, -142, -142, -142,  884,
 /*    60 */   891, -142, -142, -142,  892, -142, -142,  693, -142,  175,
 /*    70 */  -142, -142,   54, -142,  866,  876, -142,  867,  -41,  885,
 /*    80 */   888,  889,  893,  895,  877, -142, -141, -142, -142, -142,
 /*    90 */   186, -142,  849, -142, -142, -142,  852, -142, -142,  189,
 /*   100 */  -142, -142,  234, -142,  244,  894,  913, -142,  924, -142,
 /*   110 */  -142,  241,  705, -142, -142,  942, -142,  948, -142, -142,
 /*   120 */  -142, -142, -142,  241,  716,  241,  732,  241,  734,  241,
 /*   130 */   735,  241,  737,  241,  747,  241,  750,  241,  753,  241,
 /*   140 */   755,  241,  758,  241,  763,  241,  764,  241,  765,  241,
 /*   150 */   766,  241,  768,  241,  774,  241,  776,  241, -142, -142,
 /*   160 */  -142, -142, -142, -142, -142, -142,  779,  241, -142, -142,
 /*   170 */  -142, -142, -142, -142, -142,  781,  241,  782,  241, -142,
 /*   180 */   950,  609,  866, -142, -142, -142, -142, -142,  241,  784,
 /*   190 */   241,  789,  241,  794,  241,  795,  241,  583,  241,  896,
 /*   200 */   897, -142, -142,  805,  241,  810,  241, -142,  919, -142,
 /*   210 */  -142, -142,  957, -142, -142,  813,  241,  814,  241,  815,
 /*   220 */   241, -142, -142,  606, -142, -142,  956,  961, -142, -142,
 /*   230 */   903,  952, -142,  818,  241, -142,  177, -142,  820,  241,
 /*   240 */  -142,  477,  915, -142, -142, -142,  969, -142,  970, -142,
 /*   250 */  -142, -142,  972,  967,  518, -142, -142,  974, -142, -142,
 /*   260 */   923,  926, -142, -142,  821, -142, -142,  980, -142, -142,
 /*   270 */   828,  241,   13,  866,  915, -142,  564,  930,  933, -142,
 /*   280 */   830,  185, -142, -142, -142,  942, -142, -142, -142, -142,
 /*   290 */   241, -142, -142, -142, -142, -142,  241,  973, -142,  987,
 /*   300 */   966,  976,  962, -142,  990, -142, -142,  984, -142, -142,
 /*   310 */  -142, -142, -142, -142,  986, -142,  989, -142, -138, -142,
 /*   320 */  -142,  689,  935,  993, -142, -142,  936,  997, -142, -142,
 /*   330 */   995, -142,  963, -142, -142,  369, -142, -142, -142, -142,
 /*   340 */   999,  411, -142, -142,  415, -142, -142, -142, -142, -142,
 /*   350 */   998, 1002, -142, 1006, -142, -142, -142,  491, -142, 1007,
 /*   360 */  -142, -142,  576, -142, 1009, -142,  833,   -1, -142, -142,
 /*   370 */  -142,  660, -142, -142, 1008, 1010, 1012,  229, -142, -142,
 /*   380 */  -142, -142, -142, -142,  567,  866,  595, -142, 1021, 1016,
 /*   390 */  -142, 1022, 1026, -142,  574,  866, 1023, 1027,  927,  958,
 /*   400 */  -142,  401, 1030, -142,  937,  934, -142,  838,  241, -142,
 /*   410 */  -142, -142, -142, -142, -142, -142,  826, -142, -142, -142,
 /*   420 */  -142, -142, -142, -142, 1038, 1035, -142,  536, -142,  697,
 /*   430 */  -142, 1024, -142, -142, -142,  608,  866, 1014,  829, -142,
 /*   440 */  -142, -142, -142, -142, -142,  647, -142, 1025, 1054, -142,
 /*   450 */   717, 1018, 1057, -142,  853,  241, -142, -142,  854,  241,
 /*   460 */  -142, 1064, 1028,  858, -142, -142,  613,  866, -142,  637,
 /*   470 */  -142,  869,  241, -142,  241, -142, 1076, 1029, -142, -142,
 /*   480 */   700, -142,  871, -142,  872, -142,  873, -142,  866, -142,
 /*   490 */   874, 1036, -142, 1046,  879, -142,  878, 1039, -142, -142,
 /*   500 */   880, 1031,  855,  866, -142,  688, -142, -142, 1086, -142,
 /*   510 */  1088, 1091, -142,  569, -142, -142, -142, -142, 1099, -142,
 /*   520 */  -142, 1032, 1090, -142, 1105, 1033, -142, 1093, -142, -142,
 /*   530 */  -142, 1037, 1107, -142, -142, -142, -142,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   544,  544,  538,  829,  829,  540,  829,  549,  829,  829,
 /*    10 */   829,  829,  569,  570,  571,  550,  551,  552,  829,  829,
 /*    20 */   829,  829,  829,  829,  829,  829,  829,  829,  829,  829,
 /*    30 */   829,  562,  572,  581,  564,  580,  829,  829,  582,  623,
 /*    40 */   588,  829,  829,  624,  627,  628,  629,  818,  819,  820,
 /*    50 */   829,  623,  589,  608,  606,  829,  609,  610,  829,  679,
 /*    60 */   623,  590,  677,  678,  623,  591,  829,  829,  708,  770,
 /*    70 */   714,  709,  829,  634,  829,  829,  635,  643,  645,  652,
 /*    80 */   691,  682,  684,  672,  686,  640,  793,  578,  579,  687,
 /*    90 */   793,  688,  829,  788,  790,  791,  829,  789,  792,  793,
 /*   100 */   689,  829,  829,  673,  829,  680,  679,  674,  829,  566,
 /*   110 */   681,  676,  829,  707,  829,  829,  710,  829,  711,  712,
 /*   120 */   713,  715,  716,  719,  829,  720,  829,  721,  829,  722,
 /*   130 */   829,  723,  829,  724,  829,  725,  829,  726,  829,  727,
 /*   140 */   829,  728,  829,  729,  829,  730,  829,  731,  829,  732,
 /*   150 */   829,  733,  829,  734,  829,  735,  829,  736,  737,  738,
 /*   160 */   829,  739,  740,  745,  753,  756,  829,  741,  742,  829,
 /*   170 */   743,  829,  746,  744,  752,  829,  829,  829,  754,  755,
 /*   180 */   829,  770,  829,  829,  829,  829,  829,  758,  769,  829,
 /*   190 */   747,  829,  748,  829,  749,  829,  750,  829,  829,  829,
 /*   200 */   829,  829,  760,  829,  829,  829,  761,  829,  829,  829,
 /*   210 */   816,  829,  829,  829,  817,  829,  829,  829,  829,  829,
 /*   220 */   762,  829,  757,  770,  767,  768,  660,  829,  661,  759,
 /*   230 */   680,  679,  675,  829,  685,  829,  770,  683,  829,  692,
 /*   240 */   644,  655,  653,  654,  663,  664,  829,  665,  829,  666,
 /*   250 */   829,  667,  829,  660,  651,  567,  568,  829,  649,  650,
 /*   260 */   669,  671,  656,  829,  829,  829,  670,  829,  704,  705,
 /*   270 */   829,  668,  655,  829,  829,  829,  651,  669,  671,  657,
 /*   280 */   829,  651,  646,  647,  829,  829,  648,  641,  642,  751,
 /*   290 */   829,  706,  829,  717,  829,  718,  829,  623,  592,  829,
 /*   300 */   774,  596,  593,  597,  829,  598,  829,  829,  599,  829,
 /*   310 */   602,  603,  604,  605,  829,  600,  829,  601,  829,  829,
 /*   320 */   775,  829,  680,  679,  776,  778,  680,  679,  777,  594,
 /*   330 */   829,  595,  608,  607,  583,  793,  584,  585,  586,  587,
 /*   340 */   573,  793,  829,  574,  793,  829,  575,  577,  576,  565,
 /*   350 */   829,  829,  613,  829,  616,  829,  829,  829,  829,  623,
 /*   360 */   617,  829,  829,  829,  623,  618,  829,  623,  619,  829,
 /*   370 */   829,  829,  829,  829,  829,  774,  596,  621,  829,  620,
 /*   380 */   622,  614,  615,  563,  829,  829,  559,  829,  829,  660,
 /*   390 */   557,  829,  829,  829,  829,  829,  829,  660,  799,  829,
 /*   400 */   829,  829,  660,  662,  804,  829,  829,  829,  829,  829,
 /*   410 */   829,  805,  806,  829,  829,  829,  829,  829,  796,  797,
 /*   420 */   829,  798,  558,  829,  829,  829,  829,  829,  829,  829,
 /*   430 */   829,  829,  829,  829,  829,  829,  829,  829,  829,  626,
 /*   440 */   829,  829,  829,  829,  829,  829,  829,  625,  829,  829,
 /*   450 */   829,  829,  829,  829,  829,  694,  829,  829,  829,  695,
 /*   460 */   829,  829,  702,  829,  829,  703,  829,  829,  829,  829,
 /*   470 */   829,  829,  700,  829,  701,  829,  829,  829,  829,  829,
 /*   480 */   829,  829,  829,  829,  829,  829,  829,  829,  829,  829,
 /*   490 */   829,  829,  829,  625,  829,  829,  829,  829,  829,  829,
 /*   500 */   829,  702,  829,  829,  829,  829,  829,  829,  829,  829,
 /*   510 */   829,  660,  829,  793,  829,  829,  829,  829,  829,  829,
 /*   520 */   829,  827,  829,  829,  829,  829,  829,  829,  829,  829,
 /*   530 */   826,  827,  829,  829,  541,  543,  539,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*    CASCADE => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*       GLOB => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*       LIKE => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*  STATEMENT => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ASC",           "ATTACH",        "BEFORE",      
  "CASCADE",       "CONFLICT",      "DATABASE",      "DESC",        
  "DETACH",        "EACH",          "FAIL",          "FOR",         
  "GLOB",          "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "OR",            "AND",         
  "NOT",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "UMINUS",        "UPLUS",       
  "BITNOT",        "STRING",        "JOIN_KW",       "CONSTRAINT",  
  "DEFAULT",       "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "COLLATE",       "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "error",         "input",       
  "cmdlist",       "ecmd",          "explain",       "cmdx",        
  "cmd",           "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "dbnm",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typename",      "signed",        "plus_num",    
  "minus_num",     "carg",          "ccons",         "onconf",      
  "sortorder",     "expr",          "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "fullname",    
  "oneselect",     "multiselect_op",  "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "sclp",          "as",          
  "seltablist",    "stl_prefix",    "joinop",        "on_opt",      
  "using_opt",     "seltablist_paren",  "joinop2",       "inscollist",  
  "sortlist",      "sortitem",      "collate",       "exprlist",    
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "likeop",        "between_op",    "in_op",         "case_operand",
  "case_exprlist",  "case_else",     "expritem",      "uniqueflag",  
  "idxitem",       "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT ids",
 /*  48 */ "carg ::= DEFAULT plus_num",
 /*  49 */ "carg ::= DEFAULT minus_num",
 /*  50 */ "carg ::= DEFAULT NULL",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "refargs ::=",
 /*  60 */ "refargs ::= refargs refarg",
 /*  61 */ "refarg ::= MATCH nm",
 /*  62 */ "refarg ::= ON DELETE refact",
 /*  63 */ "refarg ::= ON UPDATE refact",
 /*  64 */ "refarg ::= ON INSERT refact",
 /*  65 */ "refact ::= SET NULL",
 /*  66 */ "refact ::= SET DEFAULT",
 /*  67 */ "refact ::= CASCADE",
 /*  68 */ "refact ::= RESTRICT",
 /*  69 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  70 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  71 */ "init_deferred_pred_opt ::=",
 /*  72 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  73 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  74 */ "conslist_opt ::=",
 /*  75 */ "conslist_opt ::= COMMA conslist",
 /*  76 */ "conslist ::= conslist COMMA tcons",
 /*  77 */ "conslist ::= conslist tcons",
 /*  78 */ "conslist ::= tcons",
 /*  79 */ "tcons ::= CONSTRAINT nm",
 /*  80 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  81 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  82 */ "tcons ::= CHECK expr onconf",
 /*  83 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  84 */ "defer_subclause_opt ::=",
 /*  85 */ "defer_subclause_opt ::= defer_subclause",
 /*  86 */ "onconf ::=",
 /*  87 */ "onconf ::= ON CONFLICT resolvetype",
 /*  88 */ "orconf ::=",
 /*  89 */ "orconf ::= OR resolvetype",
 /*  90 */ "resolvetype ::= raisetype",
 /*  91 */ "resolvetype ::= IGNORE",
 /*  92 */ "resolvetype ::= REPLACE",
 /*  93 */ "cmd ::= DROP TABLE fullname",
 /*  94 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  95 */ "cmd ::= DROP VIEW fullname",
 /*  96 */ "cmd ::= select",
 /*  97 */ "select ::= oneselect",
 /*  98 */ "select ::= select multiselect_op oneselect",
 /*  99 */ "multiselect_op ::= UNION",
 /* 100 */ "multiselect_op ::= UNION ALL",
 /* 101 */ "multiselect_op ::= INTERSECT",
 /* 102 */ "multiselect_op ::= EXCEPT",
 /* 103 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 104 */ "distinct ::= DISTINCT",
 /* 105 */ "distinct ::= ALL",
 /* 106 */ "distinct ::=",
 /* 107 */ "sclp ::= selcollist COMMA",
 /* 108 */ "sclp ::=",
 /* 109 */ "selcollist ::= sclp expr as",
 /* 110 */ "selcollist ::= sclp STAR",
 /* 111 */ "selcollist ::= sclp nm DOT STAR",
 /* 112 */ "as ::= AS nm",
 /* 113 */ "as ::= ids",
 /* 114 */ "as ::=",
 /* 115 */ "from ::=",
 /* 116 */ "from ::= FROM seltablist",
 /* 117 */ "stl_prefix ::= seltablist joinop",
 /* 118 */ "stl_prefix ::=",
 /* 119 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 120 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 121 */ "seltablist_paren ::= select",
 /* 122 */ "seltablist_paren ::= seltablist",
 /* 123 */ "dbnm ::=",
 /* 124 */ "dbnm ::= DOT nm",
 /* 125 */ "fullname ::= nm dbnm",
 /* 126 */ "joinop ::= COMMA",
 /* 127 */ "joinop ::= JOIN",
 /* 128 */ "joinop ::= JOIN_KW JOIN",
 /* 129 */ "joinop ::= JOIN_KW nm JOIN",
 /* 130 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 131 */ "on_opt ::= ON expr",
 /* 132 */ "on_opt ::=",
 /* 133 */ "using_opt ::= USING LP inscollist RP",
 /* 134 */ "using_opt ::=",
 /* 135 */ "orderby_opt ::=",
 /* 136 */ "orderby_opt ::= ORDER BY sortlist",
 /* 137 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 138 */ "sortlist ::= sortitem collate sortorder",
 /* 139 */ "sortitem ::= expr",
 /* 140 */ "sortorder ::= ASC",
 /* 141 */ "sortorder ::= DESC",
 /* 142 */ "sortorder ::=",
 /* 143 */ "collate ::=",
 /* 144 */ "collate ::= COLLATE id",
 /* 145 */ "groupby_opt ::=",
 /* 146 */ "groupby_opt ::= GROUP BY exprlist",
 /* 147 */ "having_opt ::=",
 /* 148 */ "having_opt ::= HAVING expr",
 /* 149 */ "limit_opt ::=",
 /* 150 */ "limit_opt ::= LIMIT signed",
 /* 151 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 152 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 153 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 154 */ "where_opt ::=",
 /* 155 */ "where_opt ::= WHERE expr",
 /* 156 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 157 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 158 */ "setlist ::= nm EQ expr",
 /* 159 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 160 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 161 */ "insert_cmd ::= INSERT orconf",
 /* 162 */ "insert_cmd ::= REPLACE",
 /* 163 */ "itemlist ::= itemlist COMMA expr",
 /* 164 */ "itemlist ::= expr",
 /* 165 */ "inscollist_opt ::=",
 /* 166 */ "inscollist_opt ::= LP inscollist RP",
 /* 167 */ "inscollist ::= inscollist COMMA nm",
 /* 168 */ "inscollist ::= nm",
 /* 169 */ "expr ::= LP expr RP",
 /* 170 */ "expr ::= NULL",
 /* 171 */ "expr ::= ID",
 /* 172 */ "expr ::= JOIN_KW",
 /* 173 */ "expr ::= nm DOT nm",
 /* 174 */ "expr ::= nm DOT nm DOT nm",
 /* 175 */ "expr ::= INTEGER",
 /* 176 */ "expr ::= FLOAT",
 /* 177 */ "expr ::= STRING",
 /* 178 */ "expr ::= BLOB",
 /* 179 */ "expr ::= VARIABLE",
 /* 180 */ "expr ::= ID LP exprlist RP",
 /* 181 */ "expr ::= ID LP STAR RP",
 /* 182 */ "expr ::= expr AND expr",
 /* 183 */ "expr ::= expr OR expr",
 /* 184 */ "expr ::= expr LT expr",
 /* 185 */ "expr ::= expr GT expr",
 /* 186 */ "expr ::= expr LE expr",
 /* 187 */ "expr ::= expr GE expr",
 /* 188 */ "expr ::= expr NE expr",
 /* 189 */ "expr ::= expr EQ expr",
 /* 190 */ "expr ::= expr BITAND expr",
 /* 191 */ "expr ::= expr BITOR expr",
 /* 192 */ "expr ::= expr LSHIFT expr",
 /* 193 */ "expr ::= expr RSHIFT expr",
 /* 194 */ "expr ::= expr PLUS expr",
 /* 195 */ "expr ::= expr MINUS expr",
 /* 196 */ "expr ::= expr STAR expr",
 /* 197 */ "expr ::= expr SLASH expr",
 /* 198 */ "expr ::= expr REM expr",
 /* 199 */ "expr ::= expr CONCAT expr",
 /* 200 */ "likeop ::= LIKE",
 /* 201 */ "likeop ::= GLOB",
 /* 202 */ "likeop ::= NOT LIKE",
 /* 203 */ "likeop ::= NOT GLOB",
 /* 204 */ "expr ::= expr likeop expr",
 /* 205 */ "expr ::= expr ISNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOTNULL",
 /* 208 */ "expr ::= expr NOT NULL",
 /* 209 */ "expr ::= expr IS NOT NULL",
 /* 210 */ "expr ::= NOT expr",
 /* 211 */ "expr ::= BITNOT expr",
 /* 212 */ "expr ::= MINUS expr",
 /* 213 */ "expr ::= PLUS expr",
 /* 214 */ "expr ::= LP select RP",
 /* 215 */ "between_op ::= BETWEEN",
 /* 216 */ "between_op ::= NOT BETWEEN",
 /* 217 */ "expr ::= expr between_op expr AND expr",
 /* 218 */ "in_op ::= IN",
 /* 219 */ "in_op ::= NOT IN",
 /* 220 */ "expr ::= expr in_op LP exprlist RP",
 /* 221 */ "expr ::= expr in_op LP select RP",
 /* 222 */ "expr ::= expr in_op nm dbnm",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= exprlist COMMA expritem",
 /* 231 */ "exprlist ::= expritem",
 /* 232 */ "expritem ::= expr",
 /* 233 */ "expritem ::=",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON fullname LP idxlist RP onconf",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "cmd ::= DROP INDEX fullname",
 /* 243 */ "cmd ::= VACUUM",
 /* 244 */ "cmd ::= VACUUM nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "plus_num ::= plus_opt number",
 /* 252 */ "minus_num ::= MINUS number",
 /* 253 */ "number ::= INTEGER",
 /* 254 */ "number ::= FLOAT",
 /* 255 */ "plus_opt ::= PLUS",
 /* 256 */ "plus_opt ::=",
 /* 257 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 258 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 259 */ "trigger_time ::= BEFORE",
 /* 260 */ "trigger_time ::= AFTER",
 /* 261 */ "trigger_time ::= INSTEAD OF",
 /* 262 */ "trigger_time ::=",
 /* 263 */ "trigger_event ::= DELETE",
 /* 264 */ "trigger_event ::= INSERT",
 /* 265 */ "trigger_event ::= UPDATE",
 /* 266 */ "trigger_event ::= UPDATE OF inscollist",
 /* 267 */ "foreach_clause ::=",
 /* 268 */ "foreach_clause ::= FOR EACH ROW",
 /* 269 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 270 */ "when_clause ::=",
 /* 271 */ "when_clause ::= WHEN expr",
 /* 272 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 273 */ "trigger_cmd_list ::=",
 /* 274 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 277 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 278 */ "trigger_cmd ::= select",
 /* 279 */ "expr ::= RAISE LP IGNORE RP",
 /* 280 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 281 */ "raisetype ::= ROLLBACK",
 /* 282 */ "raisetype ::= ABORT",
 /* 283 */ "raisetype ::= FAIL",
 /* 284 */ "cmd ::= DROP TRIGGER fullname",
 /* 285 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 286 */ "key_opt ::=",
 /* 287 */ "key_opt ::= KEY ids",
 /* 288 */ "key_opt ::= KEY BLOB",
 /* 289 */ "database_kw_opt ::= DATABASE",
 /* 290 */ "database_kw_opt ::=",
 /* 291 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 146:
    case 176:
    case 193:
#line 303 "parse.y"
{sqlite3SelectDelete((yypminor->yy107));}
#line 1236 "parse.c"
      break;
    case 161:
    case 181:
    case 183:
    case 191:
    case 197:
    case 210:
#line 552 "parse.y"
{sqlite3ExprDelete((yypminor->yy258));}
#line 1246 "parse.c"
      break;
    case 162:
    case 170:
    case 179:
    case 182:
    case 184:
    case 186:
    case 196:
    case 199:
    case 200:
    case 203:
    case 208:
#line 744 "parse.y"
{sqlite3ExprListDelete((yypminor->yy210));}
#line 1261 "parse.c"
      break;
    case 175:
    case 180:
    case 188:
    case 189:
#line 428 "parse.y"
{sqlite3SrcListDelete((yypminor->yy259));}
#line 1269 "parse.c"
      break;
    case 192:
    case 195:
    case 202:
#line 446 "parse.y"
{sqlite3IdListDelete((yypminor->yy272));}
#line 1276 "parse.c"
      break;
    case 216:
    case 221:
#line 833 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy91));}
#line 1282 "parse.c"
      break;
    case 218:
#line 817 "parse.y"
{sqlite3IdListDelete((yypminor->yy146).b);}
#line 1287 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 131, 1 },
  { 132, 2 },
  { 132, 1 },
  { 133, 3 },
  { 133, 1 },
  { 135, 1 },
  { 134, 1 },
  { 134, 0 },
  { 136, 3 },
  { 138, 0 },
  { 138, 1 },
  { 138, 2 },
  { 137, 0 },
  { 137, 1 },
  { 137, 1 },
  { 137, 1 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 140, 5 },
  { 142, 1 },
  { 142, 0 },
  { 141, 4 },
  { 141, 2 },
  { 144, 3 },
  { 144, 1 },
  { 147, 3 },
  { 148, 1 },
  { 151, 1 },
  { 152, 1 },
  { 152, 1 },
  { 139, 1 },
  { 139, 1 },
  { 139, 1 },
  { 149, 0 },
  { 149, 1 },
  { 149, 4 },
  { 149, 6 },
  { 153, 1 },
  { 153, 2 },
  { 154, 1 },
  { 154, 1 },
  { 150, 2 },
  { 150, 0 },
  { 157, 3 },
  { 157, 1 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 158, 2 },
  { 158, 3 },
  { 158, 4 },
  { 158, 2 },
  { 158, 5 },
  { 158, 4 },
  { 158, 1 },
  { 158, 2 },
  { 163, 0 },
  { 163, 2 },
  { 165, 2 },
  { 165, 3 },
  { 165, 3 },
  { 165, 3 },
  { 166, 2 },
  { 166, 2 },
  { 166, 1 },
  { 166, 1 },
  { 164, 3 },
  { 164, 2 },
  { 167, 0 },
  { 167, 2 },
  { 167, 2 },
  { 145, 0 },
  { 145, 2 },
  { 168, 3 },
  { 168, 2 },
  { 168, 1 },
  { 169, 2 },
  { 169, 6 },
  { 169, 5 },
  { 169, 3 },
  { 169, 10 },
  { 171, 0 },
  { 171, 1 },
  { 159, 0 },
  { 159, 3 },
  { 172, 0 },
  { 172, 2 },
  { 173, 1 },
  { 173, 1 },
  { 173, 1 },
  { 136, 3 },
  { 136, 7 },
  { 136, 3 },
  { 136, 1 },
  { 146, 1 },
  { 146, 3 },
  { 177, 1 },
  { 177, 2 },
  { 177, 1 },
  { 177, 1 },
  { 176, 9 },
  { 178, 1 },
  { 178, 1 },
  { 178, 0 },
  { 186, 2 },
  { 186, 0 },
  { 179, 3 },
  { 179, 2 },
  { 179, 4 },
  { 187, 2 },
  { 187, 1 },
  { 187, 0 },
  { 180, 0 },
  { 180, 2 },
  { 189, 2 },
  { 189, 0 },
  { 188, 6 },
  { 188, 7 },
  { 193, 1 },
  { 193, 1 },
  { 143, 0 },
  { 143, 2 },
  { 175, 2 },
  { 190, 1 },
  { 190, 1 },
  { 190, 2 },
  { 190, 3 },
  { 190, 4 },
  { 191, 2 },
  { 191, 0 },
  { 192, 4 },
  { 192, 0 },
  { 184, 0 },
  { 184, 3 },
  { 196, 5 },
  { 196, 3 },
  { 197, 1 },
  { 160, 1 },
  { 160, 1 },
  { 160, 0 },
  { 198, 0 },
  { 198, 2 },
  { 182, 0 },
  { 182, 3 },
  { 183, 0 },
  { 183, 2 },
  { 185, 0 },
  { 185, 2 },
  { 185, 4 },
  { 185, 4 },
  { 136, 4 },
  { 181, 0 },
  { 181, 2 },
  { 136, 6 },
  { 200, 5 },
  { 200, 3 },
  { 136, 8 },
  { 136, 5 },
  { 201, 2 },
  { 201, 1 },
  { 203, 3 },
  { 203, 1 },
  { 202, 0 },
  { 202, 3 },
  { 195, 3 },
  { 195, 1 },
  { 161, 3 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 3 },
  { 161, 5 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 4 },
  { 161, 4 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 204, 1 },
  { 204, 1 },
  { 204, 2 },
  { 204, 2 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 4 },
  { 161, 2 },
  { 161, 2 },
  { 161, 2 },
  { 161, 2 },
  { 161, 3 },
  { 205, 1 },
  { 205, 2 },
  { 161, 5 },
  { 206, 1 },
  { 206, 2 },
  { 161, 5 },
  { 161, 5 },
  { 161, 4 },
  { 161, 5 },
  { 208, 5 },
  { 208, 4 },
  { 209, 2 },
  { 209, 0 },
  { 207, 1 },
  { 207, 0 },
  { 199, 3 },
  { 199, 1 },
  { 210, 1 },
  { 210, 0 },
  { 136, 11 },
  { 211, 1 },
  { 211, 0 },
  { 162, 0 },
  { 162, 3 },
  { 170, 5 },
  { 170, 3 },
  { 212, 1 },
  { 136, 3 },
  { 136, 1 },
  { 136, 2 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 6 },
  { 136, 3 },
  { 155, 2 },
  { 156, 2 },
  { 214, 1 },
  { 214, 1 },
  { 213, 1 },
  { 213, 0 },
  { 136, 5 },
  { 215, 10 },
  { 217, 1 },
  { 217, 1 },
  { 217, 2 },
  { 217, 0 },
  { 218, 1 },
  { 218, 1 },
  { 218, 1 },
  { 218, 3 },
  { 219, 0 },
  { 219, 3 },
  { 219, 3 },
  { 220, 0 },
  { 220, 2 },
  { 216, 3 },
  { 216, 0 },
  { 221, 6 },
  { 221, 8 },
  { 221, 5 },
  { 221, 4 },
  { 221, 1 },
  { 161, 4 },
  { 161, 6 },
  { 174, 1 },
  { 174, 1 },
  { 174, 1 },
  { 136, 3 },
  { 136, 6 },
  { 223, 0 },
  { 223, 2 },
  { 223, 2 },
  { 222, 1 },
  { 222, 0 },
  { 136, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 5:
#line 86 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1794 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1799 "parse.c"
        break;
      case 7:
#line 88 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1804 "parse.c"
        break;
      case 8:
#line 93 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy284);}
#line 1809 "parse.c"
        break;
      case 12:
#line 98 "parse.y"
{yygotominor.yy284 = TK_DEFERRED;}
#line 1814 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 99:
      case 101:
      case 102:
#line 99 "parse.y"
{yygotominor.yy284 = yymsp[0].major;}
#line 1824 "parse.c"
        break;
      case 16:
      case 17:
#line 102 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1830 "parse.c"
        break;
      case 18:
#line 104 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1835 "parse.c"
        break;
      case 20:
#line 109 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98,yymsp[-3].minor.yy284,0);
}
#line 1842 "parse.c"
        break;
      case 21:
      case 72:
      case 104:
      case 216:
      case 219:
#line 113 "parse.y"
{yygotominor.yy284 = 1;}
#line 1851 "parse.c"
        break;
      case 22:
      case 71:
      case 73:
      case 84:
      case 105:
      case 106:
      case 215:
      case 218:
#line 114 "parse.y"
{yygotominor.yy284 = 0;}
#line 1863 "parse.c"
        break;
      case 23:
#line 115 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1870 "parse.c"
        break;
      case 24:
#line 118 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy107);
  sqlite3SelectDelete(yymsp[0].minor.yy107);
}
#line 1878 "parse.c"
        break;
      case 28:
#line 130 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy98);}
#line 1883 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 253:
      case 254:
#line 136 "parse.y"
{yygotominor.yy98 = yymsp[0].minor.yy0;}
#line 1895 "parse.c"
        break;
      case 36:
#line 185 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy98,&yymsp[0].minor.yy98);}
#line 1900 "parse.c"
        break;
      case 37:
#line 186 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy98,&yymsp[0].minor.yy0);}
#line 1905 "parse.c"
        break;
      case 38:
#line 188 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy98,&yymsp[0].minor.yy0);}
#line 1910 "parse.c"
        break;
      case 39:
      case 112:
      case 113:
      case 124:
      case 144:
      case 241:
      case 251:
      case 252:
#line 190 "parse.y"
{yygotominor.yy98 = yymsp[0].minor.yy98;}
#line 1922 "parse.c"
        break;
      case 40:
#line 191 "parse.y"
{yygotominor.yy98.z=yymsp[-1].minor.yy98.z; yygotominor.yy98.n=yymsp[0].minor.yy98.n+(yymsp[0].minor.yy98.z-yymsp[-1].minor.yy98.z);}
#line 1927 "parse.c"
        break;
      case 41:
#line 193 "parse.y"
{ yygotominor.yy284 = atoi(yymsp[0].minor.yy98.z); }
#line 1932 "parse.c"
        break;
      case 42:
#line 194 "parse.y"
{ yygotominor.yy284 = -atoi(yymsp[0].minor.yy98.z); }
#line 1937 "parse.c"
        break;
      case 47:
      case 48:
#line 199 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy98,0);}
#line 1943 "parse.c"
        break;
      case 49:
#line 201 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy98,1);}
#line 1948 "parse.c"
        break;
      case 52:
#line 208 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy284);}
#line 1953 "parse.c"
        break;
      case 53:
#line 209 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[0].minor.yy284);}
#line 1958 "parse.c"
        break;
      case 54:
#line 210 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy284,0,0);}
#line 1963 "parse.c"
        break;
      case 56:
#line 213 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy98,yymsp[-1].minor.yy210,yymsp[0].minor.yy284);}
#line 1968 "parse.c"
        break;
      case 57:
#line 214 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy284);}
#line 1973 "parse.c"
        break;
      case 58:
#line 215 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy98.z, yymsp[0].minor.yy98.n);}
#line 1978 "parse.c"
        break;
      case 59:
#line 223 "parse.y"
{ yygotominor.yy284 = OE_Restrict * 0x010101; }
#line 1983 "parse.c"
        break;
      case 60:
#line 224 "parse.y"
{ yygotominor.yy284 = (yymsp[-1].minor.yy284 & yymsp[0].minor.yy47.mask) | yymsp[0].minor.yy47.value; }
#line 1988 "parse.c"
        break;
      case 61:
#line 226 "parse.y"
{ yygotominor.yy47.value = 0;     yygotominor.yy47.mask = 0x000000; }
#line 1993 "parse.c"
        break;
      case 62:
#line 227 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy284;     yygotominor.yy47.mask = 0x0000ff; }
#line 1998 "parse.c"
        break;
      case 63:
#line 228 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy284<<8;  yygotominor.yy47.mask = 0x00ff00; }
#line 2003 "parse.c"
        break;
      case 64:
#line 229 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy284<<16; yygotominor.yy47.mask = 0xff0000; }
#line 2008 "parse.c"
        break;
      case 65:
#line 231 "parse.y"
{ yygotominor.yy284 = OE_SetNull; }
#line 2013 "parse.c"
        break;
      case 66:
#line 232 "parse.y"
{ yygotominor.yy284 = OE_SetDflt; }
#line 2018 "parse.c"
        break;
      case 67:
#line 233 "parse.y"
{ yygotominor.yy284 = OE_Cascade; }
#line 2023 "parse.c"
        break;
      case 68:
#line 234 "parse.y"
{ yygotominor.yy284 = OE_Restrict; }
#line 2028 "parse.c"
        break;
      case 69:
      case 70:
      case 85:
      case 87:
      case 89:
      case 90:
      case 161:
#line 236 "parse.y"
{yygotominor.yy284 = yymsp[0].minor.yy284;}
#line 2039 "parse.c"
        break;
      case 80:
#line 253 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-2].minor.yy210,yymsp[0].minor.yy284);}
#line 2044 "parse.c"
        break;
      case 81:
#line 255 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy210,yymsp[0].minor.yy284,0,0);}
#line 2049 "parse.c"
        break;
      case 83:
#line 258 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy210, &yymsp[-3].minor.yy98, yymsp[-2].minor.yy210, yymsp[-1].minor.yy284);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy284);
}
#line 2057 "parse.c"
        break;
      case 86:
      case 88:
#line 272 "parse.y"
{yygotominor.yy284 = OE_Default;}
#line 2063 "parse.c"
        break;
      case 91:
#line 277 "parse.y"
{yygotominor.yy284 = OE_Ignore;}
#line 2068 "parse.c"
        break;
      case 92:
      case 162:
#line 278 "parse.y"
{yygotominor.yy284 = OE_Replace;}
#line 2074 "parse.c"
        break;
      case 93:
#line 282 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy259, 0);
}
#line 2081 "parse.c"
        break;
      case 94:
#line 288 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy98, &yymsp[-2].minor.yy98, yymsp[0].minor.yy107, yymsp[-5].minor.yy284);
}
#line 2088 "parse.c"
        break;
      case 95:
#line 291 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy259, 1);
}
#line 2095 "parse.c"
        break;
      case 96:
#line 297 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy107, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy107);
}
#line 2103 "parse.c"
        break;
      case 97:
      case 121:
#line 307 "parse.y"
{yygotominor.yy107 = yymsp[0].minor.yy107;}
#line 2109 "parse.c"
        break;
      case 98:
#line 308 "parse.y"
{
  if( yymsp[0].minor.yy107 ){
    yymsp[0].minor.yy107->op = yymsp[-1].minor.yy284;
    yymsp[0].minor.yy107->pPrior = yymsp[-2].minor.yy107;
  }
  yygotominor.yy107 = yymsp[0].minor.yy107;
}
#line 2120 "parse.c"
        break;
      case 100:
#line 317 "parse.y"
{yygotominor.yy284 = TK_ALL;}
#line 2125 "parse.c"
        break;
      case 103:
#line 321 "parse.y"
{
  yygotominor.yy107 = sqlite3SelectNew(yymsp[-6].minor.yy210,yymsp[-5].minor.yy259,yymsp[-4].minor.yy258,yymsp[-3].minor.yy210,yymsp[-2].minor.yy258,yymsp[-1].minor.yy210,yymsp[-7].minor.yy284,yymsp[0].minor.yy404.limit,yymsp[0].minor.yy404.offset);
}
#line 2132 "parse.c"
        break;
      case 107:
      case 238:
#line 342 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy210;}
#line 2138 "parse.c"
        break;
      case 108:
      case 135:
      case 145:
      case 237:
#line 343 "parse.y"
{yygotominor.yy210 = 0;}
#line 2146 "parse.c"
        break;
      case 109:
#line 344 "parse.y"
{
   yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-2].minor.yy210,yymsp[-1].minor.yy258,yymsp[0].minor.yy98.n?&yymsp[0].minor.yy98:0);
}
#line 2153 "parse.c"
        break;
      case 110:
#line 347 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-1].minor.yy210, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2160 "parse.c"
        break;
      case 111:
#line 350 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy98);
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-3].minor.yy210, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2169 "parse.c"
        break;
      case 114:
#line 362 "parse.y"
{yygotominor.yy98.n = 0;}
#line 2174 "parse.c"
        break;
      case 115:
#line 374 "parse.y"
{yygotominor.yy259 = sqliteMalloc(sizeof(*yygotominor.yy259));}
#line 2179 "parse.c"
        break;
      case 116:
#line 375 "parse.y"
{yygotominor.yy259 = yymsp[0].minor.yy259;}
#line 2184 "parse.c"
        break;
      case 117:
#line 380 "parse.y"
{
   yygotominor.yy259 = yymsp[-1].minor.yy259;
   if( yygotominor.yy259 && yygotominor.yy259->nSrc>0 ) yygotominor.yy259->a[yygotominor.yy259->nSrc-1].jointype = yymsp[0].minor.yy284;
}
#line 2192 "parse.c"
        break;
      case 118:
#line 384 "parse.y"
{yygotominor.yy259 = 0;}
#line 2197 "parse.c"
        break;
      case 119:
#line 385 "parse.y"
{
  yygotominor.yy259 = sqlite3SrcListAppend(yymsp[-5].minor.yy259,&yymsp[-4].minor.yy98,&yymsp[-3].minor.yy98);
  if( yymsp[-2].minor.yy98.n ) sqlite3SrcListAddAlias(yygotominor.yy259,&yymsp[-2].minor.yy98);
  if( yymsp[-1].minor.yy258 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pOn = yymsp[-1].minor.yy258; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy258); }
  }
  if( yymsp[0].minor.yy272 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pUsing = yymsp[0].minor.yy272; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
  }
}
#line 2213 "parse.c"
        break;
      case 120:
#line 398 "parse.y"
{
  yygotominor.yy259 = sqlite3SrcListAppend(yymsp[-6].minor.yy259,0,0);
  yygotominor.yy259->a[yygotominor.yy259->nSrc-1].pSelect = yymsp[-4].minor.yy107;
  if( yymsp[-2].minor.yy98.n ) sqlite3SrcListAddAlias(yygotominor.yy259,&yymsp[-2].minor.yy98);
  if( yymsp[-1].minor.yy258 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pOn = yymsp[-1].minor.yy258; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy258); }
  }
  if( yymsp[0].minor.yy272 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pUsing = yymsp[0].minor.yy272; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
  }
}
#line 2230 "parse.c"
        break;
      case 122:
#line 419 "parse.y"
{
   yygotominor.yy107 = sqlite3SelectNew(0,yymsp[0].minor.yy259,0,0,0,0,0,-1,0);
}
#line 2237 "parse.c"
        break;
      case 123:
#line 424 "parse.y"
{yygotominor.yy98.z=0; yygotominor.yy98.n=0;}
#line 2242 "parse.c"
        break;
      case 125:
#line 429 "parse.y"
{yygotominor.yy259 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98);}
#line 2247 "parse.c"
        break;
      case 126:
      case 127:
#line 433 "parse.y"
{ yygotominor.yy284 = JT_INNER; }
#line 2253 "parse.c"
        break;
      case 128:
#line 435 "parse.y"
{ yygotominor.yy284 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2258 "parse.c"
        break;
      case 129:
#line 436 "parse.y"
{ yygotominor.yy284 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy98,0); }
#line 2263 "parse.c"
        break;
      case 130:
#line 438 "parse.y"
{ yygotominor.yy284 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy98,&yymsp[-1].minor.yy98); }
#line 2268 "parse.c"
        break;
      case 131:
      case 139:
      case 148:
      case 155:
      case 226:
      case 228:
      case 232:
#line 442 "parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 2279 "parse.c"
        break;
      case 132:
      case 147:
      case 154:
      case 227:
      case 229:
      case 233:
#line 443 "parse.y"
{yygotominor.yy258 = 0;}
#line 2289 "parse.c"
        break;
      case 133:
      case 166:
#line 447 "parse.y"
{yygotominor.yy272 = yymsp[-1].minor.yy272;}
#line 2295 "parse.c"
        break;
      case 134:
      case 165:
#line 448 "parse.y"
{yygotominor.yy272 = 0;}
#line 2301 "parse.c"
        break;
      case 136:
      case 146:
#line 459 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 2307 "parse.c"
        break;
      case 137:
#line 460 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210,yymsp[-2].minor.yy258,yymsp[-1].minor.yy98.n>0?&yymsp[-1].minor.yy98:0);
  if( yygotominor.yy210 ) yygotominor.yy210->a[yygotominor.yy210->nExpr-1].sortOrder = yymsp[0].minor.yy284;
}
#line 2315 "parse.c"
        break;
      case 138:
#line 464 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy258,yymsp[-1].minor.yy98.n>0?&yymsp[-1].minor.yy98:0);
  if( yygotominor.yy210 && yygotominor.yy210->a ) yygotominor.yy210->a[0].sortOrder = yymsp[0].minor.yy284;
}
#line 2323 "parse.c"
        break;
      case 140:
      case 142:
#line 473 "parse.y"
{yygotominor.yy284 = SQLITE_SO_ASC;}
#line 2329 "parse.c"
        break;
      case 141:
#line 474 "parse.y"
{yygotominor.yy284 = SQLITE_SO_DESC;}
#line 2334 "parse.c"
        break;
      case 143:
#line 476 "parse.y"
{yygotominor.yy98.z = 0; yygotominor.yy98.n = 0;}
#line 2339 "parse.c"
        break;
      case 149:
#line 490 "parse.y"
{yygotominor.yy404.limit = -1; yygotominor.yy404.offset = 0;}
#line 2344 "parse.c"
        break;
      case 150:
#line 491 "parse.y"
{yygotominor.yy404.limit = yymsp[0].minor.yy284; yygotominor.yy404.offset = 0;}
#line 2349 "parse.c"
        break;
      case 151:
#line 493 "parse.y"
{yygotominor.yy404.limit = yymsp[-2].minor.yy284; yygotominor.yy404.offset = yymsp[0].minor.yy284;}
#line 2354 "parse.c"
        break;
      case 152:
#line 495 "parse.y"
{yygotominor.yy404.limit = yymsp[0].minor.yy284; yygotominor.yy404.offset = yymsp[-2].minor.yy284;}
#line 2359 "parse.c"
        break;
      case 153:
#line 499 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy259,yymsp[0].minor.yy258);}
#line 2364 "parse.c"
        break;
      case 156:
#line 513 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy259,yymsp[-1].minor.yy210,yymsp[0].minor.yy258,yymsp[-4].minor.yy284);}
#line 2369 "parse.c"
        break;
      case 157:
#line 516 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210,yymsp[0].minor.yy258,&yymsp[-2].minor.yy98);}
#line 2374 "parse.c"
        break;
      case 158:
#line 517 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(0,yymsp[0].minor.yy258,&yymsp[-2].minor.yy98);}
#line 2379 "parse.c"
        break;
      case 159:
#line 523 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy259, yymsp[-1].minor.yy210, 0, yymsp[-4].minor.yy272, yymsp[-7].minor.yy284);}
#line 2384 "parse.c"
        break;
      case 160:
#line 525 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy259, 0, yymsp[0].minor.yy107, yymsp[-1].minor.yy272, yymsp[-4].minor.yy284);}
#line 2389 "parse.c"
        break;
      case 163:
      case 230:
#line 535 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-2].minor.yy210,yymsp[0].minor.yy258,0);}
#line 2395 "parse.c"
        break;
      case 164:
      case 231:
#line 536 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(0,yymsp[0].minor.yy258,0);}
#line 2401 "parse.c"
        break;
      case 167:
#line 545 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(yymsp[-2].minor.yy272,&yymsp[0].minor.yy98);}
#line 2406 "parse.c"
        break;
      case 168:
#line 546 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(0,&yymsp[0].minor.yy98);}
#line 2411 "parse.c"
        break;
      case 169:
#line 554 "parse.y"
{yygotominor.yy258 = yymsp[-1].minor.yy258; sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2416 "parse.c"
        break;
      case 170:
      case 175:
      case 176:
      case 177:
      case 178:
#line 555 "parse.y"
{yygotominor.yy258 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2425 "parse.c"
        break;
      case 171:
      case 172:
#line 556 "parse.y"
{yygotominor.yy258 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2431 "parse.c"
        break;
      case 173:
#line 558 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy98);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy98);
  yygotominor.yy258 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2440 "parse.c"
        break;
      case 174:
#line 563 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy98);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy98);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy98);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy258 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2451 "parse.c"
        break;
      case 179:
#line 574 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy258 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2460 "parse.c"
        break;
      case 180:
#line 579 "parse.y"
{
  yygotominor.yy258 = sqlite3ExprFunction(yymsp[-1].minor.yy210, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2468 "parse.c"
        break;
      case 181:
#line 583 "parse.y"
{
  yygotominor.yy258 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2476 "parse.c"
        break;
      case 182:
      case 183:
      case 184:
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
#line 587 "parse.y"
{yygotominor.yy258 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy258, yymsp[0].minor.yy258, 0);}
#line 2498 "parse.c"
        break;
      case 200:
#line 606 "parse.y"
{yygotominor.yy342.opcode = TK_LIKE; yygotominor.yy342.not = 0;}
#line 2503 "parse.c"
        break;
      case 201:
#line 607 "parse.y"
{yygotominor.yy342.opcode = TK_GLOB; yygotominor.yy342.not = 0;}
#line 2508 "parse.c"
        break;
      case 202:
#line 608 "parse.y"
{yygotominor.yy342.opcode = TK_LIKE; yygotominor.yy342.not = 1;}
#line 2513 "parse.c"
        break;
      case 203:
#line 609 "parse.y"
{yygotominor.yy342.opcode = TK_GLOB; yygotominor.yy342.not = 1;}
#line 2518 "parse.c"
        break;
      case 204:
#line 610 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy258, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-2].minor.yy258, 0);
  yygotominor.yy258 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->op = yymsp[-1].minor.yy342.opcode;
  if( yymsp[-1].minor.yy342.not ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-2].minor.yy258->span, &yymsp[0].minor.yy258->span);
}
#line 2530 "parse.c"
        break;
      case 205:
#line 618 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2538 "parse.c"
        break;
      case 206:
#line 622 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2546 "parse.c"
        break;
      case 207:
#line 626 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2554 "parse.c"
        break;
      case 208:
#line 630 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2562 "parse.c"
        break;
      case 209:
#line 634 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2570 "parse.c"
        break;
      case 210:
      case 211:
#line 638 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy258->span);
}
#line 2579 "parse.c"
        break;
      case 212:
#line 646 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy258->span);
}
#line 2587 "parse.c"
        break;
      case 213:
#line 650 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy258->span);
}
#line 2595 "parse.c"
        break;
      case 214:
#line 654 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pSelect = yymsp[-1].minor.yy107;
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2604 "parse.c"
        break;
      case 217:
#line 662 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy258, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy258, 0);
  yygotominor.yy258 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pList = pList;
  if( yymsp[-3].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-4].minor.yy258->span,&yymsp[0].minor.yy258->span);
}
#line 2616 "parse.c"
        break;
      case 220:
#line 673 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pList = yymsp[-1].minor.yy210;
  if( yymsp[-3].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-4].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2626 "parse.c"
        break;
      case 221:
#line 679 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pSelect = yymsp[-1].minor.yy107;
  if( yymsp[-3].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-4].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2636 "parse.c"
        break;
      case 222:
#line 685 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98);
  yygotominor.yy258 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  if( yymsp[-2].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy258->span,yymsp[0].minor.yy98.z?&yymsp[0].minor.yy98:&yymsp[-1].minor.yy98);
}
#line 2647 "parse.c"
        break;
      case 223:
#line 695 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy258, yymsp[-1].minor.yy258, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pList = yymsp[-2].minor.yy210;
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2656 "parse.c"
        break;
      case 224:
#line 702 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210, yymsp[-2].minor.yy258, 0);
  yygotominor.yy210 = sqlite3ExprListAppend(yygotominor.yy210, yymsp[0].minor.yy258, 0);
}
#line 2664 "parse.c"
        break;
      case 225:
#line 706 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy258, 0);
  yygotominor.yy210 = sqlite3ExprListAppend(yygotominor.yy210, yymsp[0].minor.yy258, 0);
}
#line 2672 "parse.c"
        break;
      case 234:
#line 731 "parse.y"
{
  if( yymsp[-9].minor.yy284!=OE_None ) yymsp[-9].minor.yy284 = yymsp[0].minor.yy284;
  if( yymsp[-9].minor.yy284==OE_Default) yymsp[-9].minor.yy284 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy98, &yymsp[-6].minor.yy98, yymsp[-4].minor.yy259, yymsp[-2].minor.yy210, yymsp[-9].minor.yy284, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2681 "parse.c"
        break;
      case 235:
      case 282:
#line 738 "parse.y"
{yygotominor.yy284 = OE_Abort;}
#line 2687 "parse.c"
        break;
      case 236:
#line 739 "parse.y"
{yygotominor.yy284 = OE_None;}
#line 2692 "parse.c"
        break;
      case 239:
#line 749 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy98.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy98.z, yymsp[-1].minor.yy98.n);
  }
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210, p, &yymsp[-2].minor.yy98);
}
#line 2704 "parse.c"
        break;
      case 240:
#line 757 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy98.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy98.z, yymsp[-1].minor.yy98.n);
  }
  yygotominor.yy210 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy98);
}
#line 2716 "parse.c"
        break;
      case 242:
#line 770 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy259);}
#line 2721 "parse.c"
        break;
      case 243:
      case 244:
#line 774 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2727 "parse.c"
        break;
      case 245:
      case 247:
#line 779 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy98,&yymsp[-2].minor.yy98,&yymsp[0].minor.yy98,0);}
#line 2733 "parse.c"
        break;
      case 246:
#line 780 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy98,&yymsp[-2].minor.yy98,&yymsp[0].minor.yy0,0);}
#line 2738 "parse.c"
        break;
      case 248:
#line 782 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy98,&yymsp[-2].minor.yy98,&yymsp[0].minor.yy98,1);
}
#line 2745 "parse.c"
        break;
      case 249:
#line 785 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy98,&yymsp[-3].minor.yy98,&yymsp[-1].minor.yy98,0);}
#line 2750 "parse.c"
        break;
      case 250:
#line 786 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98,0,0);}
#line 2755 "parse.c"
        break;
      case 257:
#line 796 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy98.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy98.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy91, &all);
}
#line 2765 "parse.c"
        break;
      case 258:
#line 805 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy98, &yymsp[-6].minor.yy98, yymsp[-5].minor.yy284, yymsp[-4].minor.yy146.a, yymsp[-4].minor.yy146.b, yymsp[-2].minor.yy259, yymsp[-1].minor.yy284, yymsp[0].minor.yy258, yymsp[-9].minor.yy284);
  yygotominor.yy98 = (yymsp[-6].minor.yy98.n==0?yymsp[-7].minor.yy98:yymsp[-6].minor.yy98);
}
#line 2773 "parse.c"
        break;
      case 259:
      case 262:
#line 811 "parse.y"
{ yygotominor.yy284 = TK_BEFORE; }
#line 2779 "parse.c"
        break;
      case 260:
#line 812 "parse.y"
{ yygotominor.yy284 = TK_AFTER;  }
#line 2784 "parse.c"
        break;
      case 261:
#line 813 "parse.y"
{ yygotominor.yy284 = TK_INSTEAD;}
#line 2789 "parse.c"
        break;
      case 263:
      case 264:
      case 265:
#line 818 "parse.y"
{yygotominor.yy146.a = yymsp[0].major; yygotominor.yy146.b = 0;}
#line 2796 "parse.c"
        break;
      case 266:
#line 821 "parse.y"
{yygotominor.yy146.a = TK_UPDATE; yygotominor.yy146.b = yymsp[0].minor.yy272;}
#line 2801 "parse.c"
        break;
      case 267:
      case 268:
#line 824 "parse.y"
{ yygotominor.yy284 = TK_ROW; }
#line 2807 "parse.c"
        break;
      case 269:
#line 826 "parse.y"
{ yygotominor.yy284 = TK_STATEMENT; }
#line 2812 "parse.c"
        break;
      case 270:
#line 829 "parse.y"
{ yygotominor.yy258 = 0; }
#line 2817 "parse.c"
        break;
      case 271:
#line 830 "parse.y"
{ yygotominor.yy258 = yymsp[0].minor.yy258; }
#line 2822 "parse.c"
        break;
      case 272:
#line 834 "parse.y"
{
  yymsp[-2].minor.yy91->pNext = yymsp[0].minor.yy91;
  yygotominor.yy91 = yymsp[-2].minor.yy91;
}
#line 2830 "parse.c"
        break;
      case 273:
#line 838 "parse.y"
{ yygotominor.yy91 = 0; }
#line 2835 "parse.c"
        break;
      case 274:
#line 844 "parse.y"
{ yygotominor.yy91 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy98, yymsp[-1].minor.yy210, yymsp[0].minor.yy258, yymsp[-4].minor.yy284); }
#line 2840 "parse.c"
        break;
      case 275:
#line 849 "parse.y"
{yygotominor.yy91 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy98, yymsp[-4].minor.yy272, yymsp[-1].minor.yy210, 0, yymsp[-7].minor.yy284);}
#line 2845 "parse.c"
        break;
      case 276:
#line 852 "parse.y"
{yygotominor.yy91 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy98, yymsp[-1].minor.yy272, 0, yymsp[0].minor.yy107, yymsp[-4].minor.yy284);}
#line 2850 "parse.c"
        break;
      case 277:
#line 856 "parse.y"
{yygotominor.yy91 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy98, yymsp[0].minor.yy258);}
#line 2855 "parse.c"
        break;
      case 278:
#line 859 "parse.y"
{yygotominor.yy91 = sqlite3TriggerSelectStep(yymsp[0].minor.yy107); }
#line 2860 "parse.c"
        break;
      case 279:
#line 862 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy258->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2869 "parse.c"
        break;
      case 280:
#line 867 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy98); 
  yygotominor.yy258->iColumn = yymsp[-3].minor.yy284;
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2878 "parse.c"
        break;
      case 281:
#line 873 "parse.y"
{yygotominor.yy284 = OE_Rollback;}
#line 2883 "parse.c"
        break;
      case 283:
#line 875 "parse.y"
{yygotominor.yy284 = OE_Fail;}
#line 2888 "parse.c"
        break;
      case 284:
#line 879 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy259);
}
#line 2895 "parse.c"
        break;
      case 285:
#line 884 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy98, &yymsp[-1].minor.yy98, yymsp[0].minor.yy292.type, &yymsp[0].minor.yy292.key);
}
#line 2902 "parse.c"
        break;
      case 286:
#line 888 "parse.y"
{ yygotominor.yy292.type = 0; }
#line 2907 "parse.c"
        break;
      case 287:
#line 889 "parse.y"
{ yygotominor.yy292.type=1; yygotominor.yy292.key = yymsp[0].minor.yy98; }
#line 2912 "parse.c"
        break;
      case 288:
#line 890 "parse.y"
{ yygotominor.yy292.type=2; yygotominor.yy292.key = yymsp[0].minor.yy0; }
#line 2917 "parse.c"
        break;
      case 291:
#line 896 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy98);
}
#line 2924 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 2976 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
