/* This file is part of the KDE project
   Copyright (C) 2002 Alexander Dymo <cloudtemple@mksat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include <qpixmap.h>

#include "plinestyle.h"
#include "propertyeditor.h"

PLineStyle::PLineStyle(const PropertyEditor *editor, const QString pname, const QString value, QWidget *parent, const char *name):
    QComboBox(parent, name)
{
    const char *nopen[]={
    "48 16 1 1",
    ". c None",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    insertItem(QPixmap(nopen));

    const char *solid[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".###########################################....",
    ".###########################################....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    insertItem(QPixmap(solid));

    const char *dash[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..#########..#########..##########....",
    ".#########..#########..#########..##########....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    insertItem(QPixmap(dash));

    const char *dashdot[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..##..#########..##..#########..##....",
    ".#########..##..#########..##..#########..##....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    insertItem(QPixmap(dashdot));

    const char *dashdotdot[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..##..##..#########..##..##..#####....",
    ".#########..##..##..#########..##..##..#####....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    insertItem(QPixmap(dashdotdot));

    setValue(value, false);
    setPName(pname);
    connect(this, SIGNAL(activated(int)), this, SLOT(updateProperty(int)));
    connect(this, SIGNAL(propertyChanged(QString, QString)), editor, SLOT(emitPropertyChange(QString, QString)));
}

QString PLineStyle::value() const
{
    return QString("%1").arg(currentItem());
}

void PLineStyle::setValue(const QString value, bool emitChange)
{
    if (value == "0") { setCurrentItem(0);         if (emitChange)
            emit propertyChanged(pname(), value);
 return; };
    if (value == "1") { setCurrentItem(1);         if (emitChange)
            emit propertyChanged(pname(), value);
 return; };
    if (value == "2") { setCurrentItem(2);         if (emitChange)
            emit propertyChanged(pname(), value);
 return; };
    if (value == "3") { setCurrentItem(3);         if (emitChange)
            emit propertyChanged(pname(), value);
 return; };
    if (value == "4") { setCurrentItem(4);         if (emitChange)
            emit propertyChanged(pname(), value);
 return; };
    if (value == "5") { setCurrentItem(5);          if (emitChange)
            emit propertyChanged(pname(), value);
 return; };
}

void PLineStyle::updateProperty(int val)
{
    emit propertyChanged(pname(), value());
}

#ifndef PURE_QT
#include "plinestyle.moc"
#endif
