/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.EUC_CN;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022;
import sun.nio.cs.ext.ISO2022_CN;

public class ISO2022_CN_GB
extends ISO2022
implements HistoricallyNamedCharset {
    private static Charset iso2022cn = new ISO2022_CN();

    public ISO2022_CN_GB() {
        super("x-ISO-2022-CN-GB", ExtendedCharsets.aliasesFor("x-ISO-2022-CN-GB"));
    }

    public boolean contains(Charset charset) {
        return charset instanceof EUC_CN || charset.name().equals("US-ASCII") || charset instanceof ISO2022_CN_GB;
    }

    public String historicalName() {
        return "ISO2022CN_GB";
    }

    public CharsetDecoder newDecoder() {
        return iso2022cn.newDecoder();
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends ISO2022.Encoder {
        public Encoder(Charset charset) {
            super(charset);
            this.SODesig = "$)A";
            try {
                Charset charset2 = Charset.forName("EUC_CN");
                this.ISOEncoder = charset2.newEncoder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean canEncode(char c) {
            return c != '\ufffd';
        }

        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] == 63;
        }
    }
}

