/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExportControl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.DefaultSSLServerSocketFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static SSLServerSocketFactory theFactory;
    private static final Debug debug;

    private static void log(String string) {
        if (debug != null && Debug.isOn("pluggability")) {
            System.out.println(string);
        }
    }

    protected SSLServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        if (theFactory == null) {
            SSLServerSocketFactory.log("setting up default SSLServerSocketFactory");
            String string = SSLServerSocketFactory.getFactoryProvider();
            try {
                Class<?> clazz;
                block5: {
                    clazz = null;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                        if (classLoader == null) break block5;
                        clazz = classLoader.loadClass(string);
                    }
                }
                SSLServerSocketFactory.log("class " + string + " is loaded");
                SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)clazz.newInstance();
                SSLServerSocketFactory.log("instantiated an instance of class " + string);
                ExportControl.checkCipherSuites(sSLServerSocketFactory);
                theFactory = sSLServerSocketFactory;
            }
            catch (Exception exception) {
                SSLServerSocketFactory.log("use dummy SSLServerSocketFactory due to " + exception.toString());
                theFactory = new DefaultSSLServerSocketFactory(exception.getMessage());
            }
        }
        return theFactory;
    }

    private static String getFactoryProvider() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.ServerSocketFactory.provider");
            }
        });
        if (string == null) {
            string = "com.sun.net.ssl.internal.ssl.SSLServerSocketFactoryImpl";
            SSLServerSocketFactory.log("use default SunJSSE impl class: " + string);
        } else {
            SSLServerSocketFactory.log("use class specified by ssl.ServerSocketFactory.provider: " + string);
        }
        return string;
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    static {
        debug = Debug.getInstance("ssl");
    }
}

