/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.HashtableEntry;

public class LoaderConstraintEntry
extends HashtableEntry {
    private static OopField nameField;
    private static CIntegerField numLoadersField;
    private static CIntegerField maxLoadersField;
    private static AddressField loadersField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("LoaderConstraintEntry");
        nameField = type.getOopField("_name");
        numLoadersField = type.getCIntegerField("_num_loaders");
        maxLoadersField = type.getCIntegerField("_max_loaders");
        loadersField = type.getAddressField("_loaders");
    }

    public Symbol name() {
        return (Symbol)VM.getVM().getObjectHeap().newOop(nameField.getValue(this.addr));
    }

    public int numLoaders() {
        return (int)numLoadersField.getValue(this.addr);
    }

    public int maxLoaders() {
        return (int)maxLoadersField.getValue(this.addr);
    }

    public Oop initiatingLoader(int i) {
        Assert.that(i >= 0 && i < this.numLoaders(), "invalid index");
        Address loaders = loadersField.getValue(this.addr);
        OopHandle loader = loaders.addOffsetToAsOopHandle((long)i * VM.getVM().getOopSize());
        return VM.getVM().getObjectHeap().newOop(loader);
    }

    public LoaderConstraintEntry(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                LoaderConstraintEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

