/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.DebugInfoReadStream;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class Location {
    private short value;
    private static int OFFSET_MASK;
    private static int OFFSET_SHIFT;
    private static int TYPE_MASK;
    private static int TYPE_SHIFT;
    private static int WHERE_MASK;
    private static int WHERE_SHIFT;
    private static int TYPE_NORMAL;
    private static int TYPE_OOP;
    private static int TYPE_INT_IN_LONG;
    private static int TYPE_LNG;
    private static int TYPE_FLOAT_IN_DBL;
    private static int TYPE_DBL;
    private static int TYPE_ADDR;
    private static int TYPE_INVALID;
    private static int WHERE_ON_STACK;
    private static int WHERE_IN_REGISTER;

    private static void initialize(TypeDataBase db) {
        Assert.that(!VM.getVM().isCore(), "Debug info not used in core build");
        OFFSET_MASK = db.lookupIntConstant("Location::OFFSET_MASK");
        OFFSET_SHIFT = db.lookupIntConstant("Location::OFFSET_SHIFT");
        TYPE_MASK = db.lookupIntConstant("Location::TYPE_MASK");
        TYPE_SHIFT = db.lookupIntConstant("Location::TYPE_SHIFT");
        WHERE_MASK = db.lookupIntConstant("Location::WHERE_MASK");
        WHERE_SHIFT = db.lookupIntConstant("Location::WHERE_SHIFT");
        TYPE_NORMAL = db.lookupIntConstant("Location::normal");
        TYPE_OOP = db.lookupIntConstant("Location::oop");
        TYPE_INT_IN_LONG = db.lookupIntConstant("Location::int_in_long");
        TYPE_LNG = db.lookupIntConstant("Location::lng");
        TYPE_FLOAT_IN_DBL = db.lookupIntConstant("Location::float_in_dbl");
        TYPE_DBL = db.lookupIntConstant("Location::dbl");
        TYPE_ADDR = db.lookupIntConstant("Location::addr");
        TYPE_INVALID = db.lookupIntConstant("Location::invalid");
        WHERE_ON_STACK = db.lookupIntConstant("Location::on_stack");
        WHERE_IN_REGISTER = db.lookupIntConstant("Location::in_register");
    }

    Location(Where where, Type type, short offset) {
        this.setWhere(where);
        this.setType(type);
        this.setOffset(offset);
    }

    public Where getWhere() {
        int where = (this.value & WHERE_MASK) >> WHERE_SHIFT;
        if (where == WHERE_ON_STACK) {
            return Where.ON_STACK;
        }
        if (where == WHERE_IN_REGISTER) {
            return Where.IN_REGISTER;
        }
        throw new RuntimeException("should not reach here");
    }

    public Type getType() {
        int type = (this.value & TYPE_MASK) >> TYPE_SHIFT;
        if (type == TYPE_NORMAL) {
            return Type.NORMAL;
        }
        if (type == TYPE_OOP) {
            return Type.OOP;
        }
        if (type == TYPE_INT_IN_LONG) {
            return Type.INT_IN_LONG;
        }
        if (type == TYPE_LNG) {
            return Type.LNG;
        }
        if (type == TYPE_FLOAT_IN_DBL) {
            return Type.FLOAT_IN_DBL;
        }
        if (type == TYPE_DBL) {
            return Type.DBL;
        }
        if (type == TYPE_ADDR) {
            return Type.ADDR;
        }
        if (type == TYPE_INVALID) {
            return Type.INVALID;
        }
        throw new RuntimeException("should not reach here");
    }

    public short getOffset() {
        return (short)((this.value & OFFSET_MASK) >> OFFSET_SHIFT);
    }

    public boolean isRegister() {
        return this.getWhere() == Where.IN_REGISTER;
    }

    public boolean isStack() {
        return this.getWhere() == Where.ON_STACK;
    }

    public boolean holdsOop() {
        return this.getType() == Type.OOP;
    }

    public boolean holdsInt() {
        return this.getType() == Type.INT_IN_LONG;
    }

    public boolean holdsLong() {
        return this.getType() == Type.LNG;
    }

    public boolean holdsFloat() {
        return this.getType() == Type.FLOAT_IN_DBL;
    }

    public boolean holdsDouble() {
        return this.getType() == Type.DBL;
    }

    public boolean holdsAddr() {
        return this.getType() == Type.ADDR;
    }

    public boolean isIllegal() {
        return this.getType() == Type.INVALID;
    }

    public int getStackOffset() {
        Assert.that(this.getWhere() == Where.ON_STACK, "wrong Where");
        return this.getOffset() << (int)VM.getVM().getLogAddressSize();
    }

    public int getRegisterNumber() {
        Assert.that(this.getWhere() == Where.IN_REGISTER, "wrong Where");
        return this.getOffset();
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        tty.print("Value " + this.value + ", ");
        if (this.isIllegal()) {
            tty.print("Illegal");
        } else {
            Where w = this.getWhere();
            if (w == Where.ON_STACK) {
                tty.print("stack[" + this.getStackOffset() + "]");
            } else if (w == Where.IN_REGISTER) {
                tty.print("reg " + this.getRegisterNumber());
            }
            Type type = this.getType();
            if (type != Type.NORMAL) {
                if (type == Type.OOP) {
                    tty.print(",oop");
                } else if (type == Type.INT_IN_LONG) {
                    tty.print(",int");
                } else if (type == Type.LNG) {
                    tty.print(",long");
                } else if (type == Type.FLOAT_IN_DBL) {
                    tty.print(",float");
                } else if (type == Type.DBL) {
                    tty.print(",double");
                } else if (type == Type.ADDR) {
                    tty.print(",address");
                } else if (type == Type.INVALID) {
                    tty.print(",invalid");
                }
            }
        }
    }

    public Location(DebugInfoReadStream stream) {
        this.value = stream.readShort();
    }

    private void setWhere(Where where) {
        this.value = (short)(this.value | where.getValue() << WHERE_SHIFT);
    }

    private void setType(Type type) {
        this.value = (short)(this.value | type.getValue() << TYPE_SHIFT);
    }

    private void setOffset(short offset) {
        this.value = (short)(this.value | offset << OFFSET_SHIFT);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Location.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static class Type {
        public static final Type NORMAL = new Type("normal");
        public static final Type OOP = new Type("oop");
        public static final Type INT_IN_LONG = new Type("int_in_long");
        public static final Type LNG = new Type("lng");
        public static final Type FLOAT_IN_DBL = new Type("float_in_dbl");
        public static final Type DBL = new Type("dbl");
        public static final Type ADDR = new Type("addr");
        public static final Type INVALID = new Type("invalid");
        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public int getValue() {
            if (this == NORMAL) {
                return TYPE_NORMAL;
            }
            if (this == OOP) {
                return TYPE_OOP;
            }
            if (this == INT_IN_LONG) {
                return TYPE_INT_IN_LONG;
            }
            if (this == LNG) {
                return TYPE_LNG;
            }
            if (this == FLOAT_IN_DBL) {
                return TYPE_FLOAT_IN_DBL;
            }
            if (this == DBL) {
                return TYPE_DBL;
            }
            if (this == ADDR) {
                return TYPE_ADDR;
            }
            if (this == INVALID) {
                return TYPE_INVALID;
            }
            throw new RuntimeException("should not reach here");
        }
    }

    public static class Where {
        public static final Where ON_STACK = new Where("on_stack");
        public static final Where IN_REGISTER = new Where("in_register");
        private String value;

        private Where(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public int getValue() {
            if (this == ON_STACK) {
                return WHERE_ON_STACK;
            }
            if (this == IN_REGISTER) {
                return WHERE_IN_REGISTER;
            }
            throw new RuntimeException("should not reach here");
        }
    }
}

