/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.Globals;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;

public class JARDesc
implements ResourceType {
    private URL _location;
    private String _version;
    private int _size;
    private boolean _isNativeLib;
    private boolean _isLazyDownload;
    private boolean _isMainFile;
    private String _part;
    private ResourcesDesc _parent;

    public JARDesc(URL uRL, String string, boolean bl, boolean bl2, boolean bl3, String string2, int n, ResourcesDesc resourcesDesc) {
        this._location = uRL;
        this._version = string;
        this._isLazyDownload = bl && !this._isMainFile && !Globals.isImportMode();
        this._isNativeLib = bl3;
        this._isMainFile = bl2;
        this._part = string2;
        this._size = n;
        this._parent = resourcesDesc;
    }

    public boolean isNativeLib() {
        return this._isNativeLib;
    }

    public boolean isJavaFile() {
        return !this._isNativeLib;
    }

    public URL getLocation() {
        return this._location;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isLazyDownload() {
        return this._isLazyDownload;
    }

    public boolean isMainJarFile() {
        return this._isMainFile;
    }

    public String getPartName() {
        return this._part;
    }

    public int getSize() {
        return this._size;
    }

    public ResourcesDesc getParent() {
        return this._parent;
    }

    public void visit(ResourceVisitor resourceVisitor) {
        resourceVisitor.visitJARDesc(this);
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("href", this._location);
        xMLAttributeBuilder.add("version", this._version);
        xMLAttributeBuilder.add("part", this._part);
        xMLAttributeBuilder.add("download", this.isLazyDownload() ? "lazy" : "eager");
        xMLAttributeBuilder.add("main", this.isMainJarFile() ? "true" : "false");
        String string = this._isNativeLib ? "nativelib" : "jar";
        return new XMLNode("jar", xMLAttributeBuilder.getAttributeList());
    }

    public String toString() {
        return "JARDesc[" + this._location + ":" + this._version;
    }
}

