/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.font.FontManager;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.NativeStrikeDisposer;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;

class NativeStrike
extends PhysicalStrike {
    NativeFont nativeFont;
    int numGlyphs;
    AffineTransform invertDevTx;
    AffineTransform fontTx;

    private int getNativePointSize() {
        double[] dArray = new double[4];
        this.desc.glyphTx.getMatrix(dArray);
        this.fontTx = new AffineTransform(dArray);
        if (!this.desc.devTx.isIdentity() && this.desc.devTx.getType() != 1) {
            try {
                this.invertDevTx = this.desc.devTx.createInverse();
                this.fontTx.concatenate(this.invertDevTx);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        Point2D.Float float_ = new Point2D.Float(1.0f, 1.0f);
        this.fontTx.deltaTransform(float_, float_);
        double d2 = Math.abs(float_.y);
        int n2 = this.fontTx.getType();
        if ((n2 & 0xFFFFFFFD) != 0 || this.fontTx.getScaleY() <= 0.0) {
            this.fontTx.scale(1.0 / d2, 1.0 / d2);
        } else {
            this.fontTx = null;
        }
        return (int)d2;
    }

    NativeStrike(NativeFont nativeFont, FontStrikeDesc fontStrikeDesc) {
        super(nativeFont, fontStrikeDesc);
        int n2;
        this.nativeFont = nativeFont;
        if (nativeFont.isBitmapDelegate && (((n2 = fontStrikeDesc.glyphTx.getType()) & 0xFFFFFFFD) != 0 || fontStrikeDesc.glyphTx.getScaleX() <= 0.0)) {
            this.numGlyphs = 0;
            return;
        }
        n2 = this.getNativePointSize();
        byte[] byArray = nativeFont.getPlatformNameBytes(n2);
        double d2 = Math.abs(fontStrikeDesc.devTx.getScaleX());
        this.pScalerContext = this.createScalerContext(byArray, n2, d2);
        if (this.pScalerContext == 0L) {
            FontManager.deRegisterBadFont(nativeFont);
            this.pScalerContext = this.createNullScalerContext();
            this.numGlyphs = 0;
            if (FontManager.logging) {
                FontManager.logger.severe("Could not create native strike " + new String(byArray));
            }
            return;
        }
        this.numGlyphs = nativeFont.getMapper().getNumGlyphs();
        this.disposer = new NativeStrikeDisposer(nativeFont, fontStrikeDesc, this.pScalerContext);
    }

    private boolean usingIntGlyphImages() {
        if (this.intGlyphImages != null) {
            return true;
        }
        if (FontManager.longAddresses) {
            return false;
        }
        int n2 = this.getMaxGlyph(this.pScalerContext);
        if (n2 < this.numGlyphs) {
            n2 = this.numGlyphs;
        }
        this.intGlyphImages = new int[n2];
        this.disposer.intGlyphImages = this.intGlyphImages;
        return true;
    }

    private long[] getLongGlyphImages() {
        if (this.longGlyphImages == null && FontManager.longAddresses) {
            int n2 = this.getMaxGlyph(this.pScalerContext);
            if (n2 < this.numGlyphs) {
                n2 = this.numGlyphs;
            }
            this.longGlyphImages = new long[n2];
            this.disposer.longGlyphImages = this.longGlyphImages;
        }
        return this.longGlyphImages;
    }

    NativeStrike(NativeFont nativeFont, FontStrikeDesc fontStrikeDesc, boolean bl2) {
        super(nativeFont, fontStrikeDesc);
        this.nativeFont = nativeFont;
        int n2 = (int)fontStrikeDesc.glyphTx.getScaleY();
        double d2 = fontStrikeDesc.devTx.getScaleX();
        byte[] byArray = nativeFont.getPlatformNameBytes(n2);
        this.pScalerContext = this.createScalerContext(byArray, n2, d2);
        int n3 = nativeFont.getMapper().getNumGlyphs();
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            if (this.pScalerContext != 0L) {
                this.strikeMetrics = this.nativeFont.getFontMetrics(this.pScalerContext);
            }
            if (this.strikeMetrics != null && this.fontTx != null) {
                this.strikeMetrics.convertToUserSpace(this.fontTx);
            }
        }
        return this.strikeMetrics;
    }

    private native long createScalerContext(byte[] var1, int var2, double var3);

    private native int getMaxGlyph(long var1);

    private native long createNullScalerContext();

    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = this.getGlyphImagePtr(nArray[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getGlyphImagePtr(int n2) {
        if (this.usingIntGlyphImages()) {
            long l2 = (long)this.intGlyphImages[n2] & 0xFFFFFFFFL;
            if (l2 != 0L) {
                return l2;
            }
            l2 = this.nativeFont.getGlyphImage(this.pScalerContext, n2);
            NativeStrike nativeStrike = this;
            synchronized (nativeStrike) {
                if (this.intGlyphImages[n2] == 0) {
                    this.intGlyphImages[n2] = (int)l2;
                    return l2;
                }
                StrikeCache.freeIntPointer((int)l2);
                return (long)this.intGlyphImages[n2] & 0xFFFFFFFFL;
            }
        }
        long l3 = this.getLongGlyphImages()[n2];
        if (l3 != 0L) {
            return l3;
        }
        l3 = this.nativeFont.getGlyphImage(this.pScalerContext, n2);
        NativeStrike nativeStrike = this;
        synchronized (nativeStrike) {
            if (this.longGlyphImages[n2] == 0L) {
                this.longGlyphImages[n2] = l3;
                return l3;
            }
            StrikeCache.freeLongPointer(l3);
            return this.longGlyphImages[n2];
        }
    }

    long getGlyphImagePtrNoCache(int n2) {
        return this.nativeFont.getGlyphImageNoDefault(this.pScalerContext, n2);
    }

    void getGlyphImageBounds(int n2, Point2D.Float float_, Rectangle rectangle) {
    }

    Point2D.Float getGlyphMetrics(int n2) {
        Point2D.Float float_ = new Point2D.Float(this.getGlyphAdvance(n2), 0.0f);
        return float_;
    }

    float getGlyphAdvance(int n2) {
        return this.nativeFont.getGlyphAdvance(this.pScalerContext, n2);
    }

    Rectangle2D.Float getGlyphOutlineBounds(int n2) {
        return this.nativeFont.getGlyphOutlineBounds(this.pScalerContext, n2);
    }

    GeneralPath getGlyphOutline(int n2, float f2, float f3) {
        return new GeneralPath();
    }

    GeneralPath getGlyphVectorOutline(int[] nArray, float f2, float f3) {
        return new GeneralPath();
    }
}

