/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import sun.awt.dnd.SunDragSourceContextPeer;

class XMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final long serialVersionUID = -841711780352520383L;
    protected static int motionThreshold;
    protected static final int ButtonMask = 7168;

    protected XMouseDragGestureRecognizer(DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        super(dragSource, component, n2, dragGestureListener);
    }

    protected XMouseDragGestureRecognizer(DragSource dragSource, Component component, int n2) {
        this(dragSource, component, n2, null);
    }

    protected XMouseDragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected XMouseDragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiersEx();
        int n3 = n2 & 0x1C00;
        if (n3 != 1024 && n3 != 2048) {
            return 0;
        }
        return SunDragSourceContextPeer.convertModifiersToDropAction(n2, this.getSourceActions());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            try {
                motionThreshold = DragSource.getDragThreshold();
            }
            catch (Exception exception) {
                motionThreshold = 5;
            }
            this.appendEvent(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int n2;
        if (!this.events.isEmpty() && (n2 = this.mapDragOperationFromModifiers(mouseEvent)) == 0) {
            this.events.clear();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n2 = this.mapDragOperationFromModifiers(mouseEvent);
            if (n2 == 0) {
                return;
            }
            MouseEvent mouseEvent2 = (MouseEvent)this.events.get(0);
            Point point = mouseEvent2.getPoint();
            Point point2 = mouseEvent.getPoint();
            int n3 = Math.abs(point.x - point2.x);
            int n4 = Math.abs(point.y - point2.y);
            if (n3 > motionThreshold || n4 > motionThreshold) {
                this.fireDragGestureRecognized(n2, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

