/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import com.sun.media.sound.SimpleInputDevice;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class SimpleInputDeviceProvider
extends MixerProvider {
    private static InputDeviceInfo[] infos;
    private static SimpleInputDevice[] devices;

    public Mixer.Info[] getMixerInfo() {
        Mixer.Info[] infoArray = new Mixer.Info[infos.length];
        if (infos.length > 0) {
            System.arraycopy(infos, 0, infoArray, 0, infos.length);
        }
        return infoArray;
    }

    public Mixer getMixer(Mixer.Info info) {
        for (int i2 = 0; i2 < infos.length; ++i2) {
            if (info != infos[i2]) continue;
            return this.getDevice(infos[i2]);
        }
        throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
    }

    private Mixer getDevice(InputDeviceInfo inputDeviceInfo) {
        int n2 = inputDeviceInfo.getIndex();
        if (devices[n2] == null) {
            SimpleInputDeviceProvider.devices[n2] = new SimpleInputDevice(inputDeviceInfo);
        }
        return devices[n2];
    }

    private static native int nGetNumDevices();

    private static native String nGetName(int var0);

    private static native String nGetVendor(int var0);

    private static native String nGetDescription(int var0);

    private static native String nGetVersion(int var0);

    static {
        Platform.initialize();
        int n2 = 0;
        if (!Platform.isDirectAudioEnabled()) {
            n2 = SimpleInputDeviceProvider.nGetNumDevices();
        }
        infos = new InputDeviceInfo[n2];
        devices = new SimpleInputDevice[n2];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            String string = SimpleInputDeviceProvider.nGetName(i2);
            String string2 = SimpleInputDeviceProvider.nGetVendor(i2);
            String string3 = SimpleInputDeviceProvider.nGetDescription(i2);
            String string4 = SimpleInputDeviceProvider.nGetVersion(i2);
            SimpleInputDeviceProvider.infos[i2] = new InputDeviceInfo(string, string2, string3, string4, i2, SimpleInputDeviceProvider.class);
        }
    }

    static class InputDeviceInfo
    extends Mixer.Info {
        private int index;
        private Class providerClass;

        private InputDeviceInfo(String string, String string2, String string3, String string4, int n2, Class clazz) {
            super(string, string2, string3, string4);
            this.index = n2;
            this.providerClass = clazz;
        }

        int getIndex() {
            return this.index;
        }
    }
}

