/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Histogram;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

class Coding
implements Constants,
Comparable,
CodingMethod,
Histogram.BitMetric {
    public static final int B_MAX = 5;
    public static final int H_MAX = 256;
    public static final int S_MAX = 2;
    private final int B;
    private final int H;
    private final int L;
    private final int S;
    private final int del;
    private final int min;
    private final int max;
    private final int umin;
    private final int umax;
    private final int[] byteMin;
    private final int[] byteMax;
    private static HashMap codeMap;
    private static final byte[] byteBitWidths;
    static boolean verboseStringForDebug;

    private static int saturate32(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    private static long codeRangeLong(int n2, int n3) {
        return Coding.codeRangeLong(n2, n3, n2);
    }

    private static long codeRangeLong(int n2, int n3, int n4) {
        assert (n4 >= 0 && n4 <= n2);
        assert (n2 >= 1 && n2 <= 5);
        assert (n3 >= 1 && n3 <= 256);
        if (n4 == 0) {
            return 0L;
        }
        if (n2 == 1) {
            return n3;
        }
        int n5 = 256 - n3;
        long l2 = 0L;
        long l3 = 1L;
        for (int i2 = 1; i2 <= n4; ++i2) {
            l2 += l3;
            l3 *= (long)n3;
        }
        l2 *= (long)n5;
        if (n4 == n2) {
            l2 += l3;
        }
        return l2;
    }

    public static int codeMax(int n2, int n3, int n4, int n5) {
        long l2 = Coding.codeRangeLong(n2, n3, n5);
        if (l2 == 0L) {
            return -1;
        }
        if (n4 == 0 || l2 >= 0x100000000L) {
            return Coding.saturate32(l2 - 1L);
        }
        long l3 = l2 - 1L;
        while (Coding.isNegativeCode(l3, n4)) {
            --l3;
        }
        if (l3 < 0L) {
            return -1;
        }
        int n6 = Coding.decodeSign32(l3, n4);
        if (n6 < 0) {
            return Integer.MAX_VALUE;
        }
        return n6;
    }

    public static int codeMin(int n2, int n3, int n4, int n5) {
        long l2 = Coding.codeRangeLong(n2, n3, n5);
        if (l2 >= 0x100000000L && n5 == n2) {
            return Integer.MIN_VALUE;
        }
        if (n4 == 0) {
            return 0;
        }
        int n6 = (1 << n4) - 1;
        long l3 = l2 - 1L;
        while (!Coding.isNegativeCode(l3, n4)) {
            --l3;
        }
        if (l3 < 0L) {
            return 0;
        }
        return Coding.decodeSign32(l3, n4);
    }

    private static long toUnsigned32(int n2) {
        return (long)n2 << 32 >>> 32;
    }

    private static boolean isNegativeCode(long l2, int n2) {
        assert (n2 > 0);
        assert (l2 >= -1L);
        int n3 = (1 << n2) - 1;
        return ((int)l2 + 1 & n3) == 0;
    }

    private static boolean hasNegativeCode(int n2, int n3) {
        assert (n3 > 0);
        return 0 > n2 && n2 >= ~(-1 >>> n3);
    }

    private static int decodeSign32(long l2, int n2) {
        assert (l2 == Coding.toUnsigned32((int)l2)) : Long.toHexString(l2);
        if (n2 == 0) {
            return (int)l2;
        }
        int n3 = Coding.isNegativeCode(l2, n2) ? ~((int)l2 >>> n2) : (int)l2 - ((int)l2 >>> n2);
        assert (n2 != 1 || n3 == ((int)l2 >>> 1 ^ -((int)l2 & 1)));
        return n3;
    }

    private static long encodeSign32(int n2, int n3) {
        if (n3 == 0) {
            return Coding.toUnsigned32(n2);
        }
        int n4 = (1 << n3) - 1;
        long l2 = !Coding.hasNegativeCode(n2, n3) ? (long)n2 + Coding.toUnsigned32(n2) / (long)n4 : (long)((-n2 << n3) - 1);
        l2 = Coding.toUnsigned32((int)l2);
        assert (n2 == Coding.decodeSign32(l2, n3)) : Long.toHexString(l2) + " -> " + Integer.toHexString(n2) + " != " + Integer.toHexString(Coding.decodeSign32(l2, n3));
        return l2;
    }

    public static void writeInt(byte[] byArray, int[] nArray, int n2, int n3, int n4, int n5) {
        long l2 = Coding.encodeSign32(n2, n5);
        assert (l2 == Coding.toUnsigned32((int)l2));
        assert (l2 < Coding.codeRangeLong(n3, n4)) : Long.toHexString(l2);
        int n6 = 256 - n4;
        long l3 = l2;
        int n7 = nArray[0];
        for (int i2 = 0; i2 < n3 - 1 && l3 >= (long)n6; l3 /= (long)n4, ++i2) {
            int n8 = (int)((long)n6 + (l3 -= (long)n6) % (long)n4);
            byArray[n7++] = (byte)n8;
        }
        byArray[n7++] = (byte)l3;
        nArray[0] = n7;
    }

    public static int readInt(byte[] byArray, int[] nArray, int n2, int n3, int n4) {
        int n5 = 256 - n3;
        long l2 = 0L;
        long l3 = 1L;
        int n6 = nArray[0];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n7 = byArray[n6++] & 0xFF;
            l2 += (long)n7 * l3;
            l3 *= (long)n3;
            if (n7 < n5) break;
        }
        nArray[0] = n6;
        return Coding.decodeSign32(l2, n4);
    }

    public static int readIntFrom(InputStream inputStream, int n2, int n3, int n4) throws IOException {
        int n5 = 256 - n3;
        long l2 = 0L;
        long l3 = 1L;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = inputStream.read();
            if (n6 < 0) {
                throw new RuntimeException("unexpected EOF");
            }
            l2 += (long)n6 * l3;
            l3 *= (long)n3;
            if (n6 < n5) break;
        }
        assert (l2 >= 0L && l2 < Coding.codeRangeLong(n2, n3));
        return Coding.decodeSign32(l2, n4);
    }

    private Coding(int n2, int n3, int n4) {
        this(n2, n3, n4, 0);
    }

    private Coding(int n2, int n3, int n4, int n5) {
        this.B = n2;
        this.H = n3;
        this.L = 256 - n3;
        this.S = n4;
        this.del = n5;
        this.min = Coding.codeMin(n2, n3, n4, n2);
        this.max = Coding.codeMax(n2, n3, n4, n2);
        this.umin = Coding.codeMin(n2, n3, 0, n2);
        this.umax = Coding.codeMax(n2, n3, 0, n2);
        this.byteMin = new int[n2];
        this.byteMax = new int[n2];
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.byteMin[i2 - 1] = Coding.codeMin(n2, n3, n4, i2);
            this.byteMax[i2 - 1] = Coding.codeMax(n2, n3, n4, i2);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Coding)) {
            return false;
        }
        Coding coding = (Coding)object;
        if (this.B != coding.B) {
            return false;
        }
        if (this.H != coding.H) {
            return false;
        }
        if (this.S != coding.S) {
            return false;
        }
        return this.del == coding.del;
    }

    public int hashCode() {
        return (this.del << 14) + (this.S << 11) + (this.B << 8) + (this.H << 0);
    }

    private static synchronized Coding of(int n2, int n3, int n4, int n5) {
        Coding coding;
        Coding coding2;
        if (codeMap == null) {
            codeMap = new HashMap();
        }
        if ((coding2 = (Coding)codeMap.get(coding = new Coding(n2, n3, n4, n5))) == null) {
            coding2 = coding;
            codeMap.put(coding, coding2);
        }
        return coding2;
    }

    public static Coding of(int n2, int n3) {
        return Coding.of(n2, n3, 0, 0);
    }

    public static Coding of(int n2, int n3, int n4) {
        return Coding.of(n2, n3, n4, 0);
    }

    public boolean canRepresent(int n2) {
        return n2 >= this.min && n2 <= this.max;
    }

    public boolean canRepresentUnsigned(int n2) {
        return n2 >= this.umin && n2 <= this.umax;
    }

    public int readFrom(byte[] byArray, int[] nArray) {
        return Coding.readInt(byArray, nArray, this.B, this.H, this.S);
    }

    public void writeTo(byte[] byArray, int[] nArray, int n2) {
        Coding.writeInt(byArray, nArray, n2, this.B, this.H, this.S);
    }

    public int readFrom(InputStream inputStream) throws IOException {
        return Coding.readIntFrom(inputStream, this.B, this.H, this.S);
    }

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        byte[] byArray = new byte[this.B];
        int[] nArray = new int[1];
        Coding.writeInt(byArray, nArray, n2, this.B, this.H, this.S);
        outputStream.write(byArray, 0, nArray[0]);
    }

    public void readArrayFrom(InputStream inputStream, int[] nArray, int n2, int n3) throws IOException {
        this.readArrayFrom(inputStream, nArray, n2, n3, null);
    }

    public void readArrayFrom(InputStream inputStream, int[] nArray, int n2, int n3, int[] nArray2) throws IOException {
        int n4;
        for (n4 = n2; n4 < n3; ++n4) {
            nArray[n4] = this.readFrom(inputStream);
        }
        for (n4 = 0; n4 < this.del; ++n4) {
            int n5 = 0;
            if (nArray2 != null) {
                n5 = nArray2[n4];
            }
            for (int i2 = n2; i2 < n3; ++i2) {
                n5 += nArray[i2];
                if (this.isSubrange()) {
                    n5 = this.reduceToUnsignedRange(n5);
                }
                nArray[i2] = n5;
            }
            if (nArray2 == null) continue;
            nArray2[n4] = n5;
        }
    }

    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n2, int n3) throws IOException {
        this.writeArrayTo(outputStream, nArray, n2, n3, null);
    }

    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n2, int n3, int[] nArray2) throws IOException {
        for (int i2 = 0; i2 < this.del; ++i2) {
            assert (i2 == 0);
            int[] nArray3 = Coding.makeDeltas(nArray, n2, n3, nArray2);
            if (this.isSubrange()) {
                for (int i3 = 0; i3 < nArray3.length; ++i3) {
                    nArray3[i3] = this.reduceToSignedRange(nArray3[i3]);
                }
            }
            nArray = nArray3;
            n2 = 0;
            n3 = nArray3.length;
        }
        byte[] byArray = new byte[256];
        int n4 = byArray.length - this.B;
        int[] nArray4 = new int[]{0};
        int n5 = n2;
        while (n5 < n3) {
            while (nArray4[0] <= n4) {
                this.writeTo(byArray, nArray4, nArray[n5++]);
                if (n5 < n3) continue;
            }
            outputStream.write(byArray, 0, nArray4[0]);
            nArray4[0] = 0;
        }
    }

    boolean isSubrange() {
        return this.max < Integer.MAX_VALUE && (long)this.max - (long)this.min + 1L <= Integer.MAX_VALUE;
    }

    boolean isFullRange() {
        return this.max == Integer.MAX_VALUE && this.min == Integer.MIN_VALUE;
    }

    int getRange() {
        assert (this.isSubrange());
        return this.max - this.min + 1;
    }

    Coding setB(int n2) {
        return Coding.of(n2, this.H, this.S, this.del);
    }

    Coding setH(int n2) {
        return Coding.of(this.B, n2, this.S, this.del);
    }

    Coding setS(int n2) {
        return Coding.of(this.B, this.H, n2, this.del);
    }

    Coding setL(int n2) {
        return this.setH(256 - n2);
    }

    Coding setD(int n2) {
        return Coding.of(this.B, this.H, this.S, n2);
    }

    Coding getDeltaCoding() {
        return this.setD(this.del + 1);
    }

    Coding getValueCoding() {
        if (this.isDelta()) {
            return Coding.of(this.B, this.H, 0, this.del - 1);
        }
        return this;
    }

    int reduceToUnsignedRange(int n2) {
        if (this.canRepresentUnsigned(n2)) {
            return n2;
        }
        int n3 = this.getRange();
        assert (n3 > 0);
        if ((n2 %= n3) < 0) {
            n2 += n3;
        }
        assert (this.canRepresentUnsigned(n2));
        return n2;
    }

    int reduceToSignedRange(int n2) {
        if (this.canRepresent(n2)) {
            return n2;
        }
        int n3 = this.getRange();
        assert (n3 > 0);
        n2 -= this.min;
        if ((n2 %= n3) < 0) {
            n2 += n3;
        }
        assert (this.canRepresent(n2 += this.min));
        return n2;
    }

    boolean isSigned() {
        return this.min < 0;
    }

    boolean isDelta() {
        return this.del != 0;
    }

    public int B() {
        return this.B;
    }

    public int H() {
        return this.H;
    }

    public int L() {
        return this.L;
    }

    public int S() {
        return this.S;
    }

    public int del() {
        return this.del;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int umin() {
        return this.umin;
    }

    public int umax() {
        return this.umax;
    }

    public int byteMin(int n2) {
        return this.byteMin[n2 - 1];
    }

    public int byteMax(int n2) {
        return this.byteMax[n2 - 1];
    }

    public int compareTo(Object object) {
        Coding coding = (Coding)object;
        int n2 = this.del - coding.del;
        if (n2 == 0) {
            n2 = this.B - coding.B;
        }
        if (n2 == 0) {
            n2 = this.H - coding.H;
        }
        if (n2 == 0) {
            n2 = this.S - coding.S;
        }
        return n2;
    }

    public int distanceFrom(Coding coding) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.del - coding.del;
        if (n6 < 0) {
            n6 = -n6;
        }
        if ((n5 = this.S - coding.S) < 0) {
            n5 = -n5;
        }
        if ((n4 = this.B - coding.B) < 0) {
            n4 = -n4;
        }
        if (this.H == coding.H) {
            n3 = 0;
        } else {
            n2 = this.getHL();
            int n7 = coding.getHL();
            n3 = (n2 *= n2) > (n7 *= n7) ? Coding.ceil_lg2(1 + (n2 - 1) / n7) : Coding.ceil_lg2(1 + (n7 - 1) / n2);
        }
        n2 = 5 * (n6 + n5 + n4) + n3;
        assert (n2 != 0 || this.compareTo(coding) == 0);
        return n2;
    }

    private int getHL() {
        if (this.H <= 128) {
            return this.H;
        }
        if (this.L >= 1) {
            return 16384 / this.L;
        }
        return 32768;
    }

    static int ceil_lg2(int n2) {
        assert (n2 - 1 >= 0);
        --n2;
        int n3 = 0;
        while (n2 != 0) {
            ++n3;
            n2 >>= 1;
        }
        return n3;
    }

    static int bitWidth(int n2) {
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        int n3 = 0;
        int n4 = n2;
        if (n4 < byteBitWidths.length) {
            return byteBitWidths[n4];
        }
        int n5 = n4 >>> 16;
        if (n5 != 0) {
            n4 = n5;
            n3 += 16;
        }
        if ((n5 = n4 >>> 8) != 0) {
            n4 = n5;
            n3 += 8;
        }
        return n3 += byteBitWidths[n4];
    }

    static int[] makeDeltas(int[] nArray, int n2, int n3, int[] nArray2) {
        int n4 = n3 - n2;
        int[] nArray3 = new int[n4];
        int n5 = 0;
        if (nArray2 != null) {
            n5 = nArray2[0];
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = nArray[n2 + i2];
            nArray3[i2] = n6 - n5;
            n5 = n6;
        }
        if (nArray2 != null) {
            nArray2[0] = n5;
        }
        return nArray3;
    }

    boolean canRepresent(int n2, int n3) {
        assert (n2 <= n3);
        if (this.del > 0) {
            if (this.isSubrange()) {
                return this.canRepresentUnsigned(n3) && this.canRepresentUnsigned(n2);
            }
            return this.isFullRange();
        }
        return this.canRepresent(n3) && this.canRepresent(n2);
    }

    boolean canRepresent(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        if (n5 == 0) {
            return true;
        }
        if (this.isFullRange()) {
            return true;
        }
        int n6 = n4 = nArray[n2];
        for (int i2 = 1; i2 < n5; ++i2) {
            int n7 = nArray[n2 + i2];
            if (n4 < n7) {
                n4 = n7;
            }
            if (n6 <= n7) continue;
            n6 = n7;
        }
        return this.canRepresent(n6, n4);
    }

    public double getBitLength(int n2) {
        return (double)this.getLength(n2) * 8.0;
    }

    public int getLength(int n2) {
        if (this.isDelta() && this.isSubrange()) {
            n2 = this.reduceToSignedRange(n2);
        }
        if (n2 >= 0) {
            for (int i2 = 0; i2 < this.B; ++i2) {
                if (n2 > this.byteMax[i2]) continue;
                return i2 + 1;
            }
        } else {
            for (int i3 = 0; i3 < this.B; ++i3) {
                if (n2 < this.byteMin[i3]) continue;
                return i3 + 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getLength(int[] nArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (this.B == 1) {
            return n4;
        }
        if (this.L == 0) {
            return n4 * this.B;
        }
        if (this.isDelta()) {
            int[] nArray2 = Coding.makeDeltas(nArray, n2, n3, null);
            if (this.isSubrange()) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    nArray2[i2] = this.reduceToSignedRange(nArray2[i2]);
                }
            }
            return Coding.of(this.B, this.H, this.S).getLength(nArray2, 0, n4);
        }
        int n5 = n4;
        for (int i3 = 1; i3 <= this.B; ++i3) {
            int n6 = this.byteMax[i3 - 1];
            int n7 = this.byteMin[i3 - 1];
            int n8 = 0;
            for (int i4 = 0; i4 < n4; ++i4) {
                int n9 = nArray[n2 + i4];
                if (n9 >= 0) {
                    if (n9 <= n6) continue;
                    ++n8;
                    continue;
                }
                if (n9 >= n7) continue;
                ++n8;
            }
            if (n8 == 0) break;
            if (i3 == this.B) {
                return Integer.MAX_VALUE;
            }
            n5 += n8;
        }
        return n5;
    }

    public byte[] getMetaCoding(Coding coding) {
        if (coding == this) {
            return new byte[]{0};
        }
        int n2 = BandStructure.indexOf(this);
        if (n2 > 0) {
            return new byte[]{(byte)n2};
        }
        return new byte[]{116, (byte)(this.del + 2 * this.S + 8 * (this.B - 1)), (byte)(this.H - 1)};
    }

    public static int parseMetaCoding(byte[] byArray, int n2, Coding coding, CodingMethod[] codingMethodArray) {
        int n3;
        if (1 <= (n3 = byArray[n2++] & 0xFF) && n3 <= 115) {
            Coding coding2 = BandStructure.codingForIndex(n3);
            assert (coding2 != null);
            codingMethodArray[0] = coding2;
            return n2;
        }
        if (n3 == 116) {
            int n4 = byArray[n2++] & 0xFF;
            int n5 = byArray[n2++] & 0xFF;
            int n6 = n4 % 2;
            int n7 = n4 / 2 % 4;
            int n8 = n4 / 8 + 1;
            int n9 = n5 + 1;
            if (1 > n8 || n8 > 5 || 0 > n7 || n7 > 2 || 1 > n9 || n9 > 256 || 0 > n6 || n6 > 1 || n8 == 1 && n9 != 256 || n8 == 5 && n9 == 256) {
                throw new RuntimeException("Bad arb. coding: (" + n8 + "," + n9 + "," + n7 + "," + n6);
            }
            codingMethodArray[0] = Coding.of(n8, n9, n7, n6);
            return n2;
        }
        return n2 - 1;
    }

    public String keyString() {
        return "(" + this.B + "," + this.H + "," + this.S + "," + this.del + ")";
    }

    public String toString() {
        String string = "Coding" + this.keyString();
        return string;
    }

    private String stringForDebug() {
        String string = this.min == Integer.MIN_VALUE ? "min" : "" + this.min;
        String string2 = this.max == Integer.MAX_VALUE ? "max" : "" + this.max;
        String string3 = this.keyString() + " L=" + this.L + " r=[" + string + "," + string2 + "]";
        if (this.isSubrange()) {
            string3 = string3 + " subrange";
        } else if (!this.isFullRange()) {
            string3 = string3 + " MIDRANGE";
        }
        if (verboseStringForDebug) {
            string3 = string3 + " {";
            int n2 = 0;
            for (int i2 = 1; i2 <= this.B; ++i2) {
                int n3 = Coding.saturate32((long)this.byteMax[i2 - 1] - (long)this.byteMin[i2 - 1] + 1L);
                assert (n3 == Coding.saturate32(Coding.codeRangeLong(this.B, this.H, i2)));
                n2 = n3 -= n2;
                String string4 = n3 == Integer.MAX_VALUE ? "max" : "" + n3;
                string3 = string3 + " #" + i2 + "=" + string4;
            }
            string3 = string3 + " }";
        }
        return string3;
    }

    static {
        int n2;
        byteBitWidths = new byte[256];
        for (n2 = 0; n2 < byteBitWidths.length; ++n2) {
            Coding.byteBitWidths[n2] = (byte)Coding.ceil_lg2(n2 + 1);
        }
        n2 = 10;
        while (n2 >= 0) {
            assert (Coding.bitWidth(n2) == Coding.ceil_lg2(n2 + 1));
            n2 = (n2 << 1) - (n2 >> 3);
        }
        verboseStringForDebug = false;
    }
}

