/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.CodeSetCache;
import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;

public class CodeSetConversion {
    private static CodeSetConversion implementation;
    private static final int FALLBACK_CODESET = 0;
    private CodeSetCache cache = new CodeSetCache();

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry) {
        int n2 = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(entry, n2);
    }

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry, boolean bl2, boolean bl3) {
        if (entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16CTBConverter(bl2);
        }
        if (entry == OSFCodeSetRegistry.UTF_16) {
            if (bl3) {
                return new UTF16CTBConverter();
            }
            return new UTF16CTBConverter(bl2);
        }
        int n2 = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(entry, n2);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry) {
        return new JavaBTCConverter(entry);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry, boolean bl2) {
        if (entry == OSFCodeSetRegistry.UTF_16 || entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16BTCConverter(bl2);
        }
        return new JavaBTCConverter(entry);
    }

    private int selectEncoding(CodeSetComponentInfo.CodeSetComponent codeSetComponent, CodeSetComponentInfo.CodeSetComponent codeSetComponent2) {
        int n2;
        int n3 = codeSetComponent2.nativeCodeSet;
        if (n3 == 0) {
            if (codeSetComponent2.conversionCodeSets.length > 0) {
                n3 = codeSetComponent2.conversionCodeSets[0];
            } else {
                return 0;
            }
        }
        if (codeSetComponent.nativeCodeSet == n3) {
            return n3;
        }
        for (n2 = 0; n2 < codeSetComponent.conversionCodeSets.length; ++n2) {
            if (n3 != codeSetComponent.conversionCodeSets[n2]) continue;
            return n3;
        }
        for (n2 = 0; n2 < codeSetComponent2.conversionCodeSets.length; ++n2) {
            if (codeSetComponent.nativeCodeSet != codeSetComponent2.conversionCodeSets[n2]) continue;
            return codeSetComponent.nativeCodeSet;
        }
        for (n2 = 0; n2 < codeSetComponent2.conversionCodeSets.length; ++n2) {
            for (int i2 = 0; i2 < codeSetComponent.conversionCodeSets.length; ++i2) {
                if (codeSetComponent2.conversionCodeSets[n2] != codeSetComponent.conversionCodeSets[i2]) continue;
                return codeSetComponent2.conversionCodeSets[n2];
            }
        }
        return 0;
    }

    public CodeSetComponentInfo.CodeSetContext negotiate(CodeSetComponentInfo codeSetComponentInfo, CodeSetComponentInfo codeSetComponentInfo2) {
        int n2;
        int n3 = this.selectEncoding(codeSetComponentInfo.getCharComponent(), codeSetComponentInfo2.getCharComponent());
        if (n3 == 0) {
            n3 = OSFCodeSetRegistry.UTF_8.getNumber();
        }
        if ((n2 = this.selectEncoding(codeSetComponentInfo.getWCharComponent(), codeSetComponentInfo2.getWCharComponent())) == 0) {
            n2 = OSFCodeSetRegistry.UTF_16.getNumber();
        }
        return new CodeSetComponentInfo.CodeSetContext(n3, n2);
    }

    private CodeSetConversion() {
    }

    public static final CodeSetConversion impl() {
        return CodeSetConversionHolder.csc;
    }

    public static abstract class BTCConverter {
        public abstract boolean isFixedWidthEncoding();

        public abstract int getFixedCharWidth();

        public abstract int getNumChars();

        public abstract char[] getChars(byte[] var1, int var2, int var3);
    }

    public static abstract class CTBConverter {
        public abstract void convert(char var1);

        public abstract void convert(String var1);

        public abstract int getNumBytes();

        public abstract float getMaxBytesPerChar();

        public abstract boolean isFixedWidthEncoding();

        public abstract int getAlignment();

        public abstract byte[] getBytes();
    }

    private static class CodeSetConversionHolder {
        static final CodeSetConversion csc = new CodeSetConversion();

        private CodeSetConversionHolder() {
        }
    }

    private class JavaBTCConverter
    extends BTCConverter {
        private ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.encoding");
        private OMGSystemException omgWrapper = OMGSystemException.get("rpc.encoding");
        protected CharsetDecoder btc;
        private char[] buffer;
        private int resultingNumChars;
        private OSFCodeSetRegistry.Entry codeset;

        public JavaBTCConverter(OSFCodeSetRegistry.Entry entry) {
            this.btc = this.getConverter(entry.getName());
            this.codeset = entry;
        }

        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        public final int getFixedCharWidth() {
            return this.codeset.getMaxBytesPerChar();
        }

        public final int getNumChars() {
            return this.resultingNumChars;
        }

        public char[] getChars(byte[] byArray, int n2, int n3) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
                CharBuffer charBuffer = this.btc.decode(byteBuffer);
                this.resultingNumChars = charBuffer.limit();
                if (charBuffer.limit() == charBuffer.capacity()) {
                    this.buffer = charBuffer.array();
                } else {
                    this.buffer = new char[charBuffer.limit()];
                    charBuffer.get(this.buffer, 0, charBuffer.limit()).position(0);
                }
                return this.buffer;
            }
            catch (IllegalStateException illegalStateException) {
                throw this.wrapper.btcConverterFailure(illegalStateException);
            }
            catch (MalformedInputException malformedInputException) {
                throw this.wrapper.badUnicodePair(malformedInputException);
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                throw this.omgWrapper.charNotInCodeset(unmappableCharacterException);
            }
            catch (CharacterCodingException characterCodingException) {
                throw this.wrapper.btcConverterFailure(characterCodingException);
            }
        }

        protected CharsetDecoder getConverter(String string) {
            CharsetDecoder charsetDecoder = null;
            try {
                charsetDecoder = CodeSetConversion.this.cache.getByteToCharConverter(string);
                if (charsetDecoder == null) {
                    Charset charset = Charset.forName(string);
                    charsetDecoder = charset.newDecoder();
                    CodeSetConversion.this.cache.setConverter((Object)string, charsetDecoder);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw this.wrapper.invalidBtcConverterName(illegalCharsetNameException, (Object)string);
            }
            return charsetDecoder;
        }
    }

    private class JavaCTBConverter
    extends CTBConverter {
        private ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.encoding");
        private OMGSystemException omgWrapper = OMGSystemException.get("rpc.encoding");
        private CharsetEncoder ctb;
        private int alignment;
        private char[] chars = null;
        private int numBytes = 0;
        private int numChars = 0;
        private ByteBuffer buffer;
        private OSFCodeSetRegistry.Entry codeset;

        public JavaCTBConverter(OSFCodeSetRegistry.Entry entry, int n2) {
            try {
                this.ctb = CodeSetConversion.this.cache.getCharToByteConverter(entry.getName());
                if (this.ctb == null) {
                    Charset charset = Charset.forName(entry.getName());
                    this.ctb = charset.newEncoder();
                    CodeSetConversion.this.cache.setConverter((Object)entry.getName(), this.ctb);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw this.wrapper.invalidCtbConverterName(illegalCharsetNameException, (Object)entry.getName());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw this.wrapper.invalidCtbConverterName(unsupportedCharsetException, (Object)entry.getName());
            }
            this.codeset = entry;
            this.alignment = n2;
        }

        public final float getMaxBytesPerChar() {
            return this.ctb.maxBytesPerChar();
        }

        public void convert(char c2) {
            if (this.chars == null) {
                this.chars = new char[1];
            }
            this.chars[0] = c2;
            this.numChars = 1;
            this.convertCharArray();
        }

        public void convert(String string) {
            if (this.chars == null || this.chars.length < string.length()) {
                this.chars = new char[string.length()];
            }
            this.numChars = string.length();
            string.getChars(0, this.numChars, this.chars, 0);
            this.convertCharArray();
        }

        public final int getNumBytes() {
            return this.numBytes;
        }

        public final int getAlignment() {
            return this.alignment;
        }

        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        public byte[] getBytes() {
            return this.buffer.array();
        }

        private void convertCharArray() {
            try {
                this.buffer = this.ctb.encode(CharBuffer.wrap(this.chars, 0, this.numChars));
                this.numBytes = this.buffer.limit();
            }
            catch (IllegalStateException illegalStateException) {
                throw this.wrapper.ctbConverterFailure(illegalStateException);
            }
            catch (MalformedInputException malformedInputException) {
                throw this.wrapper.badUnicodePair(malformedInputException);
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                throw this.omgWrapper.charNotInCodeset(unmappableCharacterException);
            }
            catch (CharacterCodingException characterCodingException) {
                throw this.wrapper.ctbConverterFailure(characterCodingException);
            }
        }
    }

    private class UTF16BTCConverter
    extends JavaBTCConverter {
        private boolean defaultToLittleEndian;
        private boolean converterUsesBOM;
        private static final char UTF16_BE_MARKER = '\ufeff';
        private static final char UTF16_LE_MARKER = '\ufffe';

        public UTF16BTCConverter(boolean bl2) {
            super(OSFCodeSetRegistry.UTF_16);
            this.converterUsesBOM = true;
            this.defaultToLittleEndian = bl2;
        }

        public char[] getChars(byte[] byArray, int n2, int n3) {
            if (this.hasUTF16ByteOrderMarker(byArray, n2, n3)) {
                if (!this.converterUsesBOM) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16);
                }
                this.converterUsesBOM = true;
                return super.getChars(byArray, n2, n3);
            }
            if (this.converterUsesBOM) {
                if (this.defaultToLittleEndian) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16LE);
                } else {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16BE);
                }
                this.converterUsesBOM = false;
            }
            return super.getChars(byArray, n2, n3);
        }

        private boolean hasUTF16ByteOrderMarker(byte[] byArray, int n2, int n3) {
            if (n3 >= 4) {
                int n4 = byArray[n2] & 0xFF;
                int n5 = byArray[n2 + 1] & 0xFF;
                char c2 = (char)(n4 << 8 | n5 << 0);
                return c2 == '\ufeff' || c2 == '\ufffe';
            }
            return false;
        }

        private void switchToConverter(OSFCodeSetRegistry.Entry entry) {
            this.btc = super.getConverter(entry.getName());
        }
    }

    private class UTF16CTBConverter
    extends JavaCTBConverter {
        public UTF16CTBConverter() {
            super(OSFCodeSetRegistry.UTF_16, 2);
        }

        public UTF16CTBConverter(boolean bl2) {
            super(bl2 ? OSFCodeSetRegistry.UTF_16LE : OSFCodeSetRegistry.UTF_16BE, 2);
        }
    }
}

