/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class PixelGrabber
implements ImageConsumer {
    int x;
    int y;
    int offset;
    int width;
    int height;
    int scansize;
    boolean forceRGB;
    ColorModel model;
    int hints;
    Hashtable props;
    int[] int_pixel_buffer;
    boolean ints_delivered;
    byte[] byte_pixel_buffer;
    boolean bytes_delivered;
    ImageProducer ip;
    int observerStatus;
    int consumerStatus;
    private Thread grabberThread;
    boolean grabbing;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private /* synthetic */ void finit$() {
        this.width = -1;
        this.height = -1;
        this.scansize = -1;
        this.forceRGB = true;
        this.model = ColorModel.getRGBdefault();
        this.ints_delivered = false;
        this.bytes_delivered = false;
        this.grabbing = false;
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this(img.getSource(), x, y, w, h, pix, off, scansize);
    }

    public PixelGrabber(ImageProducer ip, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this.finit$();
        this.ip = ip;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.offset = off;
        this.scansize = scansize;
        this.int_pixel_buffer = pix;
        this.byte_pixel_buffer = new byte[pix.length * 4];
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, boolean forceRGB) {
        this.finit$();
        this.ip = img.getSource();
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        if (this.width >= 0 && this.height >= 0) {
            this.int_pixel_buffer = new int[this.width * this.height];
            this.byte_pixel_buffer = new byte[this.width * this.height];
        }
        this.forceRGB = forceRGB;
    }

    public synchronized void startGrabbing() {
        if (!this.grabbing) {
            this.grabbing = true;
            this.grabberThread = new Thread(this){
                private /* synthetic */ PixelGrabber this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.ip.startProduction(this.this$0);
                }
            };
            this.grabberThread.start();
        }
    }

    public synchronized void abortGrabbing() {
        if (this.grabbing) {
            Thread moribund = this.grabberThread;
            this.grabberThread = null;
            moribund.interrupt();
            this.imageComplete(4);
        }
    }

    public synchronized boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized boolean grabPixels(long ms) throws InterruptedException {
        if (ms < 0L) {
            return (this.observerStatus & 0x30) != 0;
        }
        this.startGrabbing();
        if (ms > 0L) {
            long time_remaining;
            long stop_time = System.currentTimeMillis() + ms;
            while (this.grabbing && (time_remaining = stop_time - System.currentTimeMillis()) > 0L) {
                this.wait(time_remaining);
            }
            this.abortGrabbing();
        } else {
            this.wait();
        }
        if (this.consumerStatus != 0) {
            return this.setObserverStatus();
        }
        return (this.observerStatus & 0x30) != 0;
    }

    private synchronized boolean setObserverStatus() {
        boolean retval = false;
        if ((this.consumerStatus & 1) != 0) {
            this.observerStatus |= 0x40;
        }
        if ((this.consumerStatus & 4) != 0) {
            this.observerStatus |= 0x80;
        }
        if ((this.consumerStatus & 3) != 0) {
            this.observerStatus |= 0x20;
            retval = true;
        }
        if ((this.consumerStatus & 2) != 0) {
            this.observerStatus |= 0x10;
            retval = true;
        }
        return retval;
    }

    public synchronized int getStatus() {
        return this.observerStatus;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized Object getPixels() {
        if (this.ints_delivered) {
            return this.int_pixel_buffer;
        }
        if (this.bytes_delivered) {
            return this.byte_pixel_buffer;
        }
        return null;
    }

    public synchronized ColorModel getColorModel() {
        return this.model;
    }

    public synchronized void setDimensions(int width, int height) {
        if (this.width < 0) {
            this.width = width - this.x;
        }
        if (this.height < 0) {
            this.height = height - this.y;
        }
        if (this.scansize < 0) {
            this.scansize = this.width;
        }
        if (this.int_pixel_buffer == null) {
            this.int_pixel_buffer = new int[this.width * this.height];
        }
        if (this.byte_pixel_buffer == null) {
            this.byte_pixel_buffer = new byte[this.width * this.height];
        }
    }

    public synchronized void setProperties(Hashtable props) {
        this.props = props;
    }

    public synchronized void setColorModel(ColorModel model) {
        this.model = model;
    }

    public synchronized void setHints(int flags) {
        this.hints = flags;
    }

    public synchronized void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        ColorModel currentModel = model != null ? model : this.model;
        for (int yp = y; yp < y + h; ++yp) {
            for (int xp = x; xp < x + w; ++xp) {
                if (xp < this.x || yp < this.y || xp >= this.x + this.width || yp >= this.y + this.height) continue;
                int i = (yp - this.y) * this.scansize + (xp - this.x) + this.offset;
                int p = (yp - y) * scansize + (xp - x) + offset;
                if (this.forceRGB) {
                    this.ints_delivered = true;
                    if (!($assertionsDisabled || i >= 0 && i < this.int_pixel_buffer.length)) {
                        throw new AssertionError();
                    }
                    if (!($assertionsDisabled || p >= 0 && p < pixels.length)) {
                        throw new AssertionError();
                    }
                    this.int_pixel_buffer[i] = currentModel.getRGB(pixels[p]);
                    continue;
                }
                this.bytes_delivered = true;
                if (!($assertionsDisabled || i >= 0 && i < this.byte_pixel_buffer.length)) {
                    throw new AssertionError();
                }
                if (!($assertionsDisabled || p >= 0 && p < pixels.length)) {
                    throw new AssertionError();
                }
                this.byte_pixel_buffer[i] = pixels[p];
            }
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public synchronized void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        ColorModel currentModel = model != null ? model : this.model;
        this.ints_delivered = true;
        for (int yp = y; yp < y + h; ++yp) {
            for (int xp = x; xp < x + w; ++xp) {
                if (xp < this.x || yp < this.y || xp >= this.x + this.width || yp >= this.y + this.height) continue;
                int i = (yp - this.y) * this.scansize + (xp - this.x) + this.offset;
                int p = (yp - y) * scansize + (xp - x) + offset;
                if (!($assertionsDisabled || i >= 0 && i < this.int_pixel_buffer.length)) {
                    throw new AssertionError();
                }
                if (!($assertionsDisabled || p >= 0 && p < pixels.length)) {
                    throw new AssertionError();
                }
                this.int_pixel_buffer[i] = this.forceRGB ? currentModel.getRGB(pixels[p]) : pixels[p];
            }
        }
    }

    public synchronized void imageComplete(int status) {
        this.consumerStatus = status;
        this.setObserverStatus();
        this.grabbing = false;
        this.ip.removeConsumer(this);
        this.notifyAll();
    }

    public synchronized int status() {
        return this.getStatus();
    }

    static {
        $assertionsDisabled = PixelGrabber.class$("java.awt.image.PixelGrabber").desiredAssertionStatus() ^ true;
    }
}

