/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class GeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final int INIT_SIZE = 20;
    private int rule;
    private byte[] types;
    private float[] points;
    private int subpath;
    private int index;

    private /* synthetic */ void finit$() {
        this.subpath = -1;
    }

    public GeneralPath() {
        this(1, 20);
    }

    public GeneralPath(int rule) {
        this(rule, 20);
    }

    public GeneralPath(int rule, int capacity) {
        this.finit$();
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
        if (capacity < 20) {
            capacity = 20;
        }
        this.types = new byte[capacity >> 1];
        this.points = new float[capacity];
    }

    public GeneralPath(Shape s) {
        this.finit$();
        this.types = new byte[10];
        this.points = new float[20];
        PathIterator pi = s.getPathIterator(null);
        this.setWindingRule(pi.getWindingRule());
        this.append(pi, false);
    }

    public void moveTo(float x, float y) {
        this.subpath = this.index;
        this.ensureSize(this.index + 2);
        this.types[this.index >> 1] = 0;
        this.points[this.index++] = x;
        this.points[this.index++] = y;
    }

    public void lineTo(float x, float y) {
        this.ensureSize(this.index + 2);
        this.types[this.index >> 1] = 1;
        this.points[this.index++] = x;
        this.points[this.index++] = y;
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.ensureSize(this.index + 4);
        this.types[this.index >> 1] = 2;
        this.points[this.index++] = x1;
        this.points[this.index++] = y1;
        this.points[this.index++] = x2;
        this.points[this.index++] = y2;
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.ensureSize(this.index + 6);
        this.types[this.index >> 1] = 3;
        this.points[this.index++] = x1;
        this.points[this.index++] = y1;
        this.points[this.index++] = x2;
        this.points[this.index++] = y2;
        this.points[this.index++] = x3;
        this.points[this.index++] = y3;
    }

    public void closePath() {
        this.ensureSize(this.index + 2);
        this.types[this.index >> 1] = 4;
        this.points[this.index++] = this.points[this.subpath];
        this.points[this.index++] = this.points[this.subpath + 1];
    }

    public void append(Shape s, boolean connect) {
        this.append(s.getPathIterator(null), connect);
    }

    public void append(PathIterator iter, boolean connect) {
        float[] f = new float[6];
        while (!iter.isDone()) {
            switch (iter.currentSegment(f)) {
                case 0: {
                    if (!connect || this.index == 0) {
                        this.moveTo(f[0], f[1]);
                        break;
                    }
                    if (this.index >= 2 && this.types[this.index - 2 >> 2] == 4 && f[0] == this.points[this.index - 2] && f[1] == this.points[this.index - 1]) break;
                }
                case 1: {
                    this.lineTo(f[0], f[1]);
                    break;
                }
                case 2: {
                    this.quadTo(f[0], f[1], f[2], f[3]);
                    break;
                }
                case 3: {
                    this.curveTo(f[0], f[1], f[2], f[3], f[4], f[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            connect = false;
            iter.next();
        }
    }

    public int getWindingRule() {
        return this.rule;
    }

    public void setWindingRule(int rule) {
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
    }

    public Point2D getCurrentPoint() {
        if (this.subpath < 0) {
            return null;
        }
        return new Point2D.Float(this.points[this.index - 2], this.points[this.index - 1]);
    }

    public void reset() {
        this.subpath = -1;
        this.index = 0;
    }

    public void transform(AffineTransform xform) {
        xform.transform(this.points, 0, this.points, 0, this.index >> 1);
    }

    public Shape createTransformedShape(AffineTransform xform) {
        GeneralPath p = new GeneralPath(this);
        p.transform(xform);
        return p;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        throw new Error("not implemented");
    }

    public boolean contains(double x, double y) {
        throw new Error("not implemented");
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(double x, double y, double w, double h) {
        throw new Error("not implemented");
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        throw new Error("not implemented");
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new GeneralPathIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        return new GeneralPath(this);
    }

    private void ensureSize(int size) {
        if (this.subpath < 0) {
            throw new IllegalPathStateException("need initial moveto");
        }
        if (size <= this.points.length) {
            return;
        }
        byte[] b = new byte[this.points.length];
        System.arraycopy(this.types, 0, b, 0, this.index >> 1);
        this.types = b;
        float[] f = new float[this.points.length << 1];
        System.arraycopy(this.points, 0, f, 0, this.index);
        this.points = f;
    }

    private static class GeneralPathIterator
    implements PathIterator {
        private static final int[] NUM_COORDS = new int[]{2, 2, 4, 6, 0};
        private final GeneralPath path;
        private final AffineTransform transform;
        private int pos;

        GeneralPathIterator(GeneralPath path, AffineTransform transform) {
            this.path = path;
            this.transform = transform;
        }

        public int getWindingRule() {
            return this.path.rule;
        }

        public boolean isDone() {
            return this.pos >= this.path.index;
        }

        public void next() {
            byte seg = this.path.types[this.pos >> 1];
            this.pos = seg == 4 ? (this.pos += 2) : (this.pos += NUM_COORDS[seg]);
        }

        public int currentSegment(float[] coords) {
            byte seg = this.path.types[this.pos >> 1];
            int numCoords = NUM_COORDS[seg];
            if (numCoords > 0) {
                if (this.transform == null) {
                    System.arraycopy(this.path.points, this.pos, coords, 0, numCoords);
                } else {
                    this.transform.transform(this.path.points, this.pos, coords, 0, numCoords >> 1);
                }
            }
            return seg;
        }

        public int currentSegment(double[] coords) {
            byte seg = this.path.types[this.pos >> 1];
            int numCoords = NUM_COORDS[seg];
            if (numCoords > 0) {
                if (this.transform == null) {
                    for (int i = 0; i < numCoords; ++i) {
                        coords[i] = this.path.points[this.pos + i];
                    }
                } else {
                    this.transform.transform(this.path.points, this.pos, coords, 0, numCoords >> 1);
                }
            }
            return seg;
        }
    }
}

