/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import com.sun.media.sound.JDK13Services;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;

    private AudioSystem() {
    }

    public static Mixer.Info[] getMixerInfo() {
        List list = AudioSystem.getMixerInfoList();
        Mixer.Info[] infoArray = list.toArray(new Mixer.Info[list.size()]);
        return infoArray;
    }

    public static Mixer getMixer(Mixer.Info info) {
        int n2;
        Object var1_1 = null;
        List list = AudioSystem.getMixerProviders();
        for (n2 = 0; n2 < list.size(); ++n2) {
            try {
                return ((MixerProvider)list.get(n2)).getMixer(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (info == null) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                try {
                    MixerProvider mixerProvider = (MixerProvider)list.get(n2);
                    Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
                    for (int i2 = 0; i2 < infoArray.length; ++i2) {
                        try {
                            return mixerProvider.getMixer(infoArray[i2]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Mixer not supported: " + (info != null ? info.toString() : "null"));
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        int n2;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i2]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            for (n2 = 0; n2 < infoArray2.length; ++n2) {
                vector.addElement(infoArray2[n2]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n2 = 0; n2 < infoArray3.length; ++n2) {
            infoArray3[n2] = (Line.Info)vector.get(n2);
        }
        return infoArray3;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        int n2;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i2]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            for (n2 = 0; n2 < infoArray2.length; ++n2) {
                vector.addElement(infoArray2[n2]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n2 = 0; n2 < infoArray3.length; ++n2) {
            infoArray3[n2] = (Line.Info)vector.get(n2);
        }
        return infoArray3;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer;
            if (infoArray[i2] == null || !(mixer = AudioSystem.getMixer(infoArray[i2])).isLineSupported(info)) continue;
            return true;
        }
        return false;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer mixer;
        int n2;
        Mixer.Info[] infoArray;
        MixerProvider mixerProvider;
        int n3;
        LineUnavailableException lineUnavailableException = null;
        List list = AudioSystem.getMixerProviders();
        try {
            Mixer mixer2 = AudioSystem.getDefaultMixer(list, info);
            if (mixer2 != null && mixer2.isLineSupported(info)) {
                return mixer2.getLine(info);
            }
        }
        catch (LineUnavailableException lineUnavailableException2) {
            lineUnavailableException = lineUnavailableException2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (n3 = 0; n3 < list.size(); ++n3) {
            mixerProvider = (MixerProvider)list.get(n3);
            infoArray = mixerProvider.getMixerInfo();
            for (n2 = 0; n2 < infoArray.length; ++n2) {
                try {
                    mixer = mixerProvider.getMixer(infoArray[n2]);
                    if (!AudioSystem.isAppropriateMixer(mixer, info, true)) continue;
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException lineUnavailableException3) {
                    lineUnavailableException = lineUnavailableException3;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        for (n3 = 0; n3 < list.size(); ++n3) {
            mixerProvider = (MixerProvider)list.get(n3);
            infoArray = mixerProvider.getMixerInfo();
            for (n2 = 0; n2 < infoArray.length; ++n2) {
                try {
                    mixer = mixerProvider.getMixer(infoArray[n2]);
                    if (!AudioSystem.isAppropriateMixer(mixer, info, false)) continue;
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException lineUnavailableException4) {
                    lineUnavailableException = lineUnavailableException4;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (lineUnavailableException != null) {
            throw lineUnavailableException;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static Clip getClip() throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true);
        DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
        return (Clip)AudioSystem.getLine(info);
    }

    public static Clip getClip(Mixer.Info info) throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true);
        DataLine.Info info2 = new DataLine.Info(Clip.class, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        return (Clip)mixer.getLine(info2);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        return (SourceDataLine)AudioSystem.getLine(info);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        DataLine.Info info2 = new DataLine.Info(SourceDataLine.class, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        return (SourceDataLine)mixer.getLine(info2);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        return (TargetDataLine)AudioSystem.getLine(info);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        DataLine.Info info2 = new DataLine.Info(TargetDataLine.class, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        return (TargetDataLine)mixer.getLine(info2);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        List list = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding> vector = new Vector<AudioFormat.Encoding>();
        AudioFormat.Encoding[] encodingArray = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i2);
            if (!formatConversionProvider.isSourceEncodingSupported(encoding)) continue;
            encodingArray = formatConversionProvider.getTargetEncodings();
            for (int i3 = 0; i3 < encodingArray.length; ++i3) {
                vector.addElement(encodingArray[i3]);
            }
        }
        AudioFormat.Encoding[] encodingArray2 = vector.toArray(new AudioFormat.Encoding[0]);
        return encodingArray2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        List list = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> vector = new Vector<AudioFormat.Encoding[]>();
        int n2 = 0;
        int n3 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            encodingArray = ((FormatConversionProvider)list.get(i2)).getTargetEncodings(audioFormat);
            n2 += encodingArray.length;
            vector.addElement(encodingArray);
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n2];
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            encodingArray = (AudioFormat.Encoding[])vector.get(i3);
            for (int i4 = 0; i4 < encodingArray.length; ++i4) {
                encodingArray2[n3++] = encodingArray[i4];
            }
        }
        return encodingArray2;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        List list = AudioSystem.getFormatConversionProviders();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i2);
            if (!formatConversionProvider.isConversionSupported(encoding, audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        List list = AudioSystem.getFormatConversionProviders();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i2);
            if (!formatConversionProvider.isConversionSupported(encoding, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(encoding, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + encoding + " from " + audioInputStream.getFormat());
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        List list = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat[]> vector = new Vector<AudioFormat[]>();
        int n2 = 0;
        int n3 = 0;
        AudioFormat[] audioFormatArray = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i2);
            audioFormatArray = formatConversionProvider.getTargetFormats(encoding, audioFormat);
            n2 += audioFormatArray.length;
            vector.addElement(audioFormatArray);
        }
        AudioFormat[] audioFormatArray2 = new AudioFormat[n2];
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            audioFormatArray = (AudioFormat[])vector.get(i3);
            for (int i4 = 0; i4 < audioFormatArray.length; ++i4) {
                audioFormatArray2[n3++] = audioFormatArray[i4];
            }
        }
        return audioFormatArray2;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        List list = AudioSystem.getFormatConversionProviders();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i2);
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioFormat2)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().matches(audioFormat)) {
            return audioInputStream;
        }
        List list = AudioSystem.getFormatConversionProviders();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i2);
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + audioFormat + " from " + audioInputStream.getFormat());
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i2);
            try {
                audioFileFormat = audioFileReader.getAudioFileFormat(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i2);
            try {
                audioFileFormat = audioFileReader.getAudioFileFormat(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i2);
            try {
                audioFileFormat = audioFileReader.getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i2);
            try {
                audioInputStream = audioFileReader.getAudioInputStream(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i2);
            try {
                audioInputStream = audioFileReader.getAudioInputStream(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input URL");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i2);
            try {
                audioInputStream = audioFileReader.getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input file");
        }
        return audioInputStream;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        List list = AudioSystem.getAudioFileWriters();
        HashSet<AudioFileFormat.Type> hashSet = new HashSet<AudioFileFormat.Type>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i2);
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes();
            for (int i3 = 0; i3 < typeArray.length; ++i3) {
                hashSet.add(typeArray[i3]);
            }
        }
        AudioFileFormat.Type[] typeArray = hashSet.toArray(new AudioFileFormat.Type[0]);
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        List list = AudioSystem.getAudioFileWriters();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i2);
            if (!audioFileWriter.isFileTypeSupported(type)) continue;
            return true;
        }
        return false;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        List list = AudioSystem.getAudioFileWriters();
        HashSet<AudioFileFormat.Type> hashSet = new HashSet<AudioFileFormat.Type>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i2);
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes(audioInputStream);
            for (int i3 = 0; i3 < typeArray.length; ++i3) {
                hashSet.add(typeArray[i3]);
            }
        }
        AudioFileFormat.Type[] typeArray = hashSet.toArray(new AudioFileFormat.Type[0]);
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        List list = AudioSystem.getAudioFileWriters();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i2);
            if (!audioFileWriter.isFileTypeSupported(type, audioInputStream)) continue;
            return true;
        }
        return false;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        List list = AudioSystem.getAudioFileWriters();
        int n2 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i2);
            try {
                n2 = audioFileWriter.write(audioInputStream, type, outputStream);
                bl2 = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n2;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        List list = AudioSystem.getAudioFileWriters();
        int n2 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i2);
            try {
                n2 = audioFileWriter.write(audioInputStream, type, file);
                bl2 = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n2;
    }

    private static List getMixerProviders() {
        return AudioSystem.getProviders(MixerProvider.class);
    }

    private static List getFormatConversionProviders() {
        return AudioSystem.getProviders(FormatConversionProvider.class);
    }

    private static List getAudioFileReaders() {
        return AudioSystem.getProviders(AudioFileReader.class);
    }

    private static List getAudioFileWriters() {
        return AudioSystem.getProviders(AudioFileWriter.class);
    }

    private static Mixer getDefaultMixer(List list, Line.Info info) {
        Mixer mixer;
        MixerProvider mixerProvider;
        Class<?> clazz = info.getLineClass();
        String string = JDK13Services.getDefaultProviderClassName(clazz);
        String string2 = JDK13Services.getDefaultInstanceName(clazz);
        if (string != null && (mixerProvider = AudioSystem.getNamedProvider(string, list)) != null && (string2 != null ? (mixer = AudioSystem.getNamedMixer(string2, mixerProvider, info)) != null : (mixer = AudioSystem.getFirstMixer(mixerProvider, info, false)) != null)) {
            return mixer;
        }
        if (string2 != null && (mixer = AudioSystem.getNamedMixer(string2, list, info)) != null) {
            return mixer;
        }
        return null;
    }

    private static MixerProvider getNamedProvider(String string, List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MixerProvider mixerProvider = (MixerProvider)list.get(i2);
            if (!mixerProvider.getClass().getName().equals(string)) continue;
            return mixerProvider;
        }
        return null;
    }

    private static Mixer getNamedMixer(String string, MixerProvider mixerProvider, Line.Info info) {
        Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer;
            if (!infoArray[i2].getName().equals(string) || !AudioSystem.isAppropriateMixer(mixer = mixerProvider.getMixer(infoArray[i2]), info, false)) continue;
            return mixer;
        }
        return null;
    }

    private static Mixer getNamedMixer(String string, List list, Line.Info info) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MixerProvider mixerProvider = (MixerProvider)list.get(i2);
            Mixer mixer = AudioSystem.getNamedMixer(string, mixerProvider, info);
            if (mixer == null) continue;
            return mixer;
        }
        return null;
    }

    private static Mixer getFirstMixer(MixerProvider mixerProvider, Line.Info info, boolean bl2) {
        Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer = mixerProvider.getMixer(infoArray[i2]);
            if (!AudioSystem.isAppropriateMixer(mixer, info, bl2)) continue;
            return mixer;
        }
        return null;
    }

    private static boolean isAppropriateMixer(Mixer mixer, Line.Info info, boolean bl2) {
        if (!mixer.isLineSupported(info)) {
            return false;
        }
        Class<?> clazz = info.getLineClass();
        if (bl2 && (SourceDataLine.class.isAssignableFrom(clazz) || Clip.class.isAssignableFrom(clazz))) {
            int n2 = mixer.getMaxLines(info);
            return n2 == -1 || n2 > 1;
        }
        return true;
    }

    private static List getMixerInfoList() {
        List list = AudioSystem.getMixerProviders();
        return AudioSystem.getMixerInfoList(list);
    }

    private static List getMixerInfoList(List list) {
        ArrayList<Mixer.Info> arrayList = new ArrayList<Mixer.Info>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Mixer.Info[] infoArray = ((MixerProvider)list.get(i2)).getMixerInfo();
            for (int i3 = 0; i3 < infoArray.length; ++i3) {
                arrayList.add(infoArray[i3]);
            }
        }
        return arrayList;
    }

    private static List getProviders(Class clazz) {
        return JDK13Services.getProviders(clazz);
    }
}

