/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private final ReentrantLock qlock;
    private final WaitQueue waitingProducers;
    private final WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean bl2) {
        if (bl2) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e2) throws InterruptedException {
        Node node;
        if (e2 == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                bl2 = node == null;
                if (bl2) {
                    node = this.waitingProducers.enq(e2);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl2) continue;
            node.waitForTake();
            return;
        } while (!node.setItem(e2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        Node node;
        if (e2 == null) {
            throw new NullPointerException();
        }
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                bl2 = node == null;
                if (bl2) {
                    node = this.waitingProducers.enq(e2);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl2) continue;
            return node.waitForTake(l3);
        } while (!node.setItem(e2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Node node;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                bl2 = node == null;
                if (bl2) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl2) continue;
            object = node.waitForPut();
            return (E)object;
        } while ((object = node.getItem()) == null);
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        Node node;
        Object object;
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.qlock;
        do {
            boolean bl2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                bl2 = node == null;
                if (bl2) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            finally {
                reentrantLock.unlock();
            }
            if (!bl2) continue;
            object = node.waitForPut(l3);
            return (E)object;
        } while ((object = node.getItem()) == null);
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2) {
        Node node;
        if (e2 == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
            }
            finally {
                reentrantLock.unlock();
            }
            if (node != null) continue;
            return false;
        } while (!node.setItem(e2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Node node;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
            }
            finally {
                reentrantLock.unlock();
            }
            if (node != null) continue;
            return null;
        } while ((object = node.getItem()) == null);
        return (E)object;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return collection.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return new EmptyIterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length > 0) {
            TArray[0] = null;
        }
        return TArray;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        E e2;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while ((e2 = this.poll()) != null) {
            collection.add(e2);
            ++n2;
        }
        return n2;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        E e2;
        int n3;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        for (n3 = 0; n3 < n2 && (e2 = this.poll()) != null; ++n3) {
            collection.add(e2);
        }
        return n3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyIterator<E>
    implements Iterator<E> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    static final class FifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3623113410248163686L;
        private transient Node head;
        private transient Node last;

        FifoWaitQueue() {
        }

        Node enq(Object object) {
            Node node = new Node(object);
            this.last = this.last == null ? (this.head = node) : (this.last.next = node);
            return node;
        }

        Node deq() {
            Node node = this.head;
            if (node != null) {
                this.head = node.next;
                if (this.head == null) {
                    this.last = null;
                }
                node.next = null;
            }
            return node;
        }
    }

    static final class LifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3633113410248163686L;
        private transient Node head;

        LifoWaitQueue() {
        }

        Node enq(Object object) {
            this.head = new Node(object, this.head);
            return this.head;
        }

        Node deq() {
            Node node = this.head;
            if (node != null) {
                this.head = node.next;
                node.next = null;
            }
            return node;
        }
    }

    static final class Node
    extends AbstractQueuedSynchronizer {
        private static final int ACK = 1;
        private static final int CANCEL = -1;
        Object item;
        Node next;

        Node(Object object) {
            this.item = object;
        }

        Node(Object object, Node node) {
            this.item = object;
            this.next = node;
        }

        protected boolean tryAcquire(int n2) {
            return this.getState() != 0;
        }

        protected boolean tryRelease(int n2) {
            return this.compareAndSetState(0, n2);
        }

        private Object extract() {
            Object object = this.item;
            this.item = null;
            return object;
        }

        private void checkCancellationOnInterrupt(InterruptedException interruptedException) throws InterruptedException {
            if (this.release(-1)) {
                throw interruptedException;
            }
            Thread.currentThread().interrupt();
        }

        boolean setItem(Object object) {
            this.item = object;
            return this.release(1);
        }

        Object getItem() {
            return this.release(1) ? this.extract() : null;
        }

        void waitForTake() throws InterruptedException {
            try {
                this.acquireInterruptibly(0);
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
        }

        Object waitForPut() throws InterruptedException {
            try {
                this.acquireInterruptibly(0);
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }

        boolean waitForTake(long l2) throws InterruptedException {
            try {
                if (!this.tryAcquireNanos(0, l2) && this.release(-1)) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return true;
        }

        Object waitForPut(long l2) throws InterruptedException {
            try {
                if (!this.tryAcquireNanos(0, l2) && this.release(-1)) {
                    return null;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }
    }

    static abstract class WaitQueue
    implements Serializable {
        WaitQueue() {
        }

        abstract Node enq(Object var1);

        abstract Node deq();
    }
}

