/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.GenCollectedHeap;
import sun.jvm.hotspot.memory.GenerationIsInClosure;
import sun.jvm.hotspot.memory.GenerationSpec;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.VirtualSpace;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public abstract class Generation
extends VMObject {
    private static long reservedFieldOffset;
    private static long virtualSpaceFieldOffset;
    private static CIntegerField levelField;
    protected static final int K = 1024;
    private static Field statRecordField;
    private static CIntegerField invocationField;
    private static int NAME_DEF_NEW;
    private static int NAME_PAR_NEW;
    private static int NAME_MARK_SWEEP_COMPACT;
    private static int NAME_TRAIN_GEN;
    private static int NAME_CONCURRENT_MARK_SWEEP;
    private static int NAME_OTHER;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Generation");
        reservedFieldOffset = type.getField("_reserved").getOffset();
        virtualSpaceFieldOffset = type.getField("_virtual_space").getOffset();
        levelField = type.getCIntegerField("_level");
        statRecordField = type.getField("_stat_record");
        type = db.lookupType("Generation::StatRecord");
        invocationField = type.getCIntegerField("invocations");
        NAME_DEF_NEW = db.lookupIntConstant("Generation::DefNew");
        NAME_PAR_NEW = db.lookupIntConstant("Generation::ParNew");
        NAME_MARK_SWEEP_COMPACT = db.lookupIntConstant("Generation::MarkSweepCompact");
        NAME_TRAIN_GEN = db.lookupIntConstant("Generation::TrainGen");
        NAME_CONCURRENT_MARK_SWEEP = db.lookupIntConstant("Generation::ConcurrentMarkSweep");
        NAME_OTHER = db.lookupIntConstant("Generation::Other");
    }

    public Generation(Address addr) {
        super(addr);
    }

    public Name kind() {
        return Name.OTHER;
    }

    static Name nameForEnum(int value) {
        if (value == NAME_DEF_NEW) {
            return Name.DEF_NEW;
        }
        if (value == NAME_PAR_NEW) {
            return Name.PAR_NEW;
        }
        if (value == NAME_MARK_SWEEP_COMPACT) {
            return Name.MARK_SWEEP_COMPACT;
        }
        if (value == NAME_TRAIN_GEN) {
            return Name.TRAIN_GEN;
        }
        if (value == NAME_CONCURRENT_MARK_SWEEP) {
            return Name.CONCURRENT_MARK_SWEEP;
        }
        if (value == NAME_OTHER) {
            return Name.OTHER;
        }
        throw new RuntimeException("should not reach here");
    }

    public GenerationSpec spec() {
        return ((GenCollectedHeap)VM.getVM().getUniverse().heap()).spec(this.level());
    }

    public int level() {
        return (int)levelField.getValue(this.addr);
    }

    public int invocations() {
        return this.getStatRecord().getInvocations();
    }

    public abstract long capacity();

    public abstract long used();

    public abstract long free();

    public abstract long contiguousAvailable();

    public MemRegion reserved() {
        return new MemRegion(this.addr.addOffsetTo(reservedFieldOffset));
    }

    public MemRegion usedRegion() {
        return this.reserved();
    }

    public boolean isIn(Address p) {
        GenerationIsInClosure blk = new GenerationIsInClosure(p);
        this.spaceIterate(blk);
        return blk.space() != null;
    }

    public boolean isInReserved(Address p) {
        return this.reserved().contains(p);
    }

    protected VirtualSpace virtualSpace() {
        return (VirtualSpace)VMObjectFactory.newObject(VirtualSpace.class, this.addr.addOffsetTo(virtualSpaceFieldOffset));
    }

    public abstract String name();

    public void spaceIterate(SpaceClosure blk) {
        this.spaceIterate(blk, false);
    }

    public abstract void spaceIterate(SpaceClosure var1, boolean var2);

    public void print() {
        this.printOn(System.out);
    }

    public abstract void printOn(PrintStream var1);

    private StatRecord getStatRecord() {
        return (StatRecord)VMObjectFactory.newObject(StatRecord.class, this.addr.addOffsetTo(statRecordField.getOffset()));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Generation.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static class StatRecord
    extends VMObject {
        public StatRecord(Address addr) {
            super(addr);
        }

        public int getInvocations() {
            return (int)invocationField.getValue(this.addr);
        }
    }

    public static class Name {
        public static final Name DEF_NEW = new Name("DefNew");
        public static final Name PAR_NEW = new Name("ParNew");
        public static final Name MARK_SWEEP_COMPACT = new Name("MarkSweepCompact");
        public static final Name TRAIN_GEN = new Name("TrainGen");
        public static final Name CONCURRENT_MARK_SWEEP = new Name("ConcurrentMarkSweep");
        public static final Name OTHER = new Name("Other");
        private String value;

        private Name(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

