/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.OneContigSpaceCardGeneration;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class CompactingPermGenGen
extends OneContigSpaceCardGeneration {
    private static AddressField unsharedBottomField;
    private static AddressField unsharedEndField;
    private static AddressField sharedBottomField;
    private static AddressField sharedEndField;
    private static AddressField readOnlyBottomField;
    private static AddressField readOnlyEndField;
    private static AddressField readWriteBottomField;
    private static AddressField readWriteEndField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CompactingPermGenGen");
        unsharedBottomField = type.getAddressField("unshared_bottom");
        unsharedEndField = type.getAddressField("unshared_end");
        sharedBottomField = type.getAddressField("shared_bottom");
        sharedEndField = type.getAddressField("shared_end");
        readOnlyBottomField = type.getAddressField("readonly_bottom");
        readOnlyEndField = type.getAddressField("readonly_end");
        readWriteBottomField = type.getAddressField("readwrite_bottom");
        readWriteEndField = type.getAddressField("readwrite_end");
    }

    public CompactingPermGenGen(Address addr) {
        super(addr);
    }

    public String name() {
        return "compacting permanent generation";
    }

    public static Address unsharedBottom() {
        return unsharedBottomField.getValue();
    }

    public static Address unsharedEnd() {
        return unsharedEndField.getValue();
    }

    public static Address sharedBottom() {
        return sharedBottomField.getValue();
    }

    public static Address sharedEnd() {
        return sharedEndField.getValue();
    }

    public static Address readOnlyBottom() {
        return readOnlyBottomField.getValue();
    }

    public static Address readOnlyEnd() {
        return readOnlyEndField.getValue();
    }

    public static Address readWriteBottom() {
        return readWriteBottomField.getValue();
    }

    public static Address readWriteEnd() {
        return readWriteEndField.getValue();
    }

    public static boolean isShared(Address p) {
        return CompactingPermGenGen.sharedBottom().lessThanOrEqual(p) && CompactingPermGenGen.sharedEnd().greaterThan(p);
    }

    public static boolean isSharedReadOnly(Address p) {
        return CompactingPermGenGen.readOnlyBottom().lessThanOrEqual(p) && CompactingPermGenGen.readOnlyEnd().greaterThan(p);
    }

    public static boolean isSharedReadWrite(Address p) {
        return CompactingPermGenGen.readWriteBottom().lessThanOrEqual(p) && CompactingPermGenGen.readWriteEnd().greaterThan(p);
    }

    public boolean isIn(Address p) {
        return CompactingPermGenGen.unsharedBottom().lessThanOrEqual(p) && CompactingPermGenGen.sharedEnd().greaterThan(p);
    }

    public void printOn(PrintStream tty) {
        tty.print("  perm");
        this.theSpace().printOn(tty);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CompactingPermGenGen.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

