.\" $XdotOrg: xc/programs/Xserver/hw/xfree86/doc/man/XF86Misc.man,v 1.1.4.2.4.2 2004/04/02 21:47:18 eich Exp $
.\" $TOG: XF86Misc.man /main/7 1997/07/19 10:30:32 kaleb $
.\"
.\"
.\"
.\" Copyright (c) 1996  Joe Moss, The XFree86 Project
.\" 
.\" $XFree86: xc/programs/Xserver/hw/xfree86/doc/man/XF86Misc.man,v 3.12 2002/12/22 00:46:54 dawes Exp $
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.TH XF86MISC __libmansuffix__ __vendorversion__ "X FUNCTIONS"
.SH NAME
XF86MiscQueryExtension, XF86MiscQueryVersion, XF86MiscGetMouseSettings, XF86MiscSetMouseSettings, XF86MiscGetKbdSettings, XF86MiscSetKbdSettings \- Extension library for the XFree86-Misc X extension.
.SH SYNTAX
.nf
.LP
\&#include <X11/extensions/xf86misc.h>
.LP
Bool XF86MiscQueryExtension(
    Display *\fIdisplay\fP\^,
    int *\fIevent_base_return\fP\^,
    int *\fIerror_base_return\fP\^);
.LP
Bool XF86MiscQueryVersion(
    Display *\fIdisplay\fP\^,
    int *\fImajor_version_return\fP\^,
    int *\fIminor_version_return\fP\^);
.ig
.LP
Status XF86MiscGetSaver(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIsuspend_time_return\fP\^,
    int *\fIoff_time_return\fP\^);
.LP
Status XF86MiscSetSaver(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIsuspend_time\fP\^,
    int \fIoff_time\fP\^);
..
.LP
Status XF86MiscGetMouseSettings(
    Display *\fIdisplay\fP\^,
    XF86MiscMouseSettings *\fImseinfo\fP\^);
.LP
Status XF86MiscSetMouseSettings(
    Display *\fIdisplay\fP\^,
    XF86MiscMouseSettings *\fImseinfo\fP\^);
.LP
Status XF86MiscGetKbdSettings(
    Display *\fIdisplay\fP\^,
    XF86MiscKbdSettings *\fIkbdinfo\fP\^);
.LP
Status XF86MiscSetKbdSettings(
    Display *\fIdisplay\fP\^,
    XF86MiscKbdSettings *\fIkbdinfo\fP\^);
.fi
.SH ARGUMENTS
.IP \fIdisplay\fP 2i
Specifies the connection to the X server.
.IP \fIscreen\fP 2i
Specifies which screen number the setting apply to.
.IP \fIevent_base_return\fP 2i
Returns the base event number for the extension.
.IP \fIerror_base_return\fP 2i
Returns the base error number for the extension.
.IP \fImajor_version_return\fP 2i
Returns the major version number of the extension.
.IP \fIminor_version_return\fP 2i
Returns the minor version number of the extension.
.ig
.IP \fIsuspend_time_return\fP 2i
Returns the number of seconds of idle time the server
will wait before activating the monitor's suspend mode.
.IP \fIoff_time_return\fP 2i
Returns the number of seconds of idle time the server
will wait before causing the monitor to powerdown.
.IP \fIsuspend_time\fP 2i
Specifies the number of seconds of idle time the server
should wait before activating the monitor's suspend mode.
.IP \fIoff_time\fP 2i
Specifies the number of seconds of idle time the server
should wait before causing the monitor to powerdown.
..
.IP \fImseinfo\fP 2i
Specifies a structure which contains the mouse parameters.
.IP \fIkbdinfo\fP 2i
Specifies a structure which contains the keyboard parameters.
.SH STRUCTURES
.nf
.ta 3i
\fIMouse:\fP
typedef struct {
    char *device; 	/\(** returned path to device */
    int type;	/\(** mouse protocol */
    int baudrate;	/\(** 1200, 2400, 4800, or 9600 */
    int samplerate;	/\(** samples per second */
    int resolution;	/\(** resolution, count per inch */
    int buttons;	/\(** number of buttons */
    Bool emulate3buttons;	/\(** Button1+Button3 -> Button2 ? */
    int emulate3timeout;	/\(** in milliseconds */
    Bool chordmiddle;	/\(** Button1+Button3 == Button2 ? */
    int flags;	/\(** Device open flags */
} XF86MiscMouseSettings;
.LP
\fIKeyboard:\fP
typedef struct {
    int type;	/\(** of keyboard: 84-key, 101-key, Xqueue  */
    int rate;	/\(** repeat rate */
    int delay;	/\(** delay until repeat starts */
    Bool servnumlock;	/\(** Server handles NumLock ? */
} XF86MiscKbdSettings;
.fi
.SH DESCRIPTION
These functions provide an interface to the
\fIXFree86-Misc\fP extension
which allows various server settings to be
queried and changed dynamically.
Applications that use these functions must be linked with
.ZN -lXxf86misc
.SS "POWER-SAVER FUNCTIONS"
The
.ZN XF86MiscGetSaver
and
.ZN XF86MiscSetSaver
functions have been removed.  This functionality is now provided by
the DPMS extension.
.SS "MOUSE FUNCTIONS"
Mouse parameters can be queried using the function
.ZN XF86MiscGetMouseSettings .
The structure pointed to by its second argument is filled in
with the current mouse settings.
.PP
Not all fields are valid in all cases.
For example, when the protocol indicates a bus mouse (i.e. the
type field has value
.ZN MTYPE_BUSMOUSE
as defined in
.ZN xf86misc.h ),
then the value in the
.ZN baudrate
field should be ignored as it does not apply to bus mice.
.PP
The
.ZN samplerate
field contains the resolution in lines per inch when
using the Hitachi tablet protocol.
.PP
The device field of the structure points to dynamically
allocated storage which should be freed by the caller.
.PP
Any of the fields of the structure can be altered and then passed
to the
.ZN XF86MiscSetMouseSettings
function to change their value in the server,
with the following restrictions:
.RS 5
.IP 1) 3
The device can not be changed
.IP 2) 3
The protocol can not be changed to or from Xqueue or OsMouse
.IP 3) 3
The buttons field can not be changed 
.IP 4) 3
Invalid combinations of parameters are not allowed
.RE
.PP
The server will generate an error if any of the above is attempted,
except the first \- the contents of the device field are simply ignored.
.PP
A change of the protocol causes the device to be closed and reopened.
Changes to the baud rate, sample rate, resolution or flags, 
when applicable to the
selected protocol, also cause a reopen of the device.
A reopen can be forced by using the MF_REOPEN flag, except in the
case of the OsMouse and Xqueue protocols which ignore all attempts
to reopen the device.
.SS "KEYBOARD FUNCTIONS"
The
.ZN XF86MiscGetKbdSettings
function allows you to retrieve the current keyboard-related
settings from the server.
.PP
Using the
.ZN XF86MiscSetKbdSettings
function, the keyboard autorepeat delay and rate can be set.
Requests to change the
.ZN type
and
.ZN servnumlock
fields are ignored (except for checking for an invalid keyboard type).
This is expected to change in a future release.
.SS "OTHER FUNCTIONS"
Two functions,
.ZN XF86MiscQueryExtension
and
.ZN XF86MiscQueryVersion ,
are provided which allow the client to query some information
regarding the extension itself.
.SH PREDEFINED VALUES
The header file
.ZN X11/extensions/xf86misc.h
contains definitions for
.IP \fBMTYPE_\fP* 1i
Mouse protocols
.IP \fBKTYPE_\fP* 1i
Keyboard types
.IP \fBMF_\fP* 1i
Mouse flags
.SH "SEE ALSO"
xset(__appmansuffix__), __xconfigfile__(__filemansuffix__)
.SH AUTHORS
Joe Moss and David Dawes, The XFree86 Project, Inc.

