/* $Id: weatherservice.cpp,v 1.30 2004/01/10 11:57:39 mueller Exp $ */
#include <kdebug.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include "weatherlib.h"
#include "weatherservice.h"
#include "stationdatabase.h"
#include "sun.h"

WeatherService::WeatherService() : QObject (0,"WeatherService"),  DCOPObject("WeatherService")
{
	kdDebug(12006) << "Starting new service... " << endl;

	stationDB = new StationDatabase();
	if ( !stationDB->loadDatabase() )
	{
		delete stationDB;
		stationDB = 0L;
	}

	m_weatherLib = new WeatherLib(stationDB);
	connect(m_weatherLib, SIGNAL(fileUpdating( const QString&)),
			SLOT(updating( const QString&)));
	connect(m_weatherLib, SIGNAL(fileUpdate( const QString&)),
			SLOT(updated( const QString&)));
  connect(m_weatherLib, SIGNAL(stationRemoved(const QString&)),
      SLOT(slotStationRemoved(const QString&)));

	KConfig *conf = kapp->config();

	conf->setGroup("WEATHERSTATIONS");
	QStringList stations =conf->readListEntry("stations");
	for ( QStringList::Iterator it = stations.begin (); it != stations.end(); ++it )
		m_weatherLib->update(*it);
}

WeatherService::~WeatherService()
{
	kdDebug(12006) << "Going away... " << endl;
	saveSettings();
}

void WeatherService::updated(const QString &stationID)
{
	kdDebug(12006) << "Sending update for " << stationID << endl;
	emit fileUpdate( stationID );
}

void WeatherService::updateAll()
{
	kdDebug(12006) << "Sending for all" << endl;
	QStringList stations =  m_weatherLib->stations();
	for  ( QStringList::Iterator it = stations.begin(); it != stations.end(); ++it ) {
		update(*it);
    	}

}

void WeatherService::updating(const QString &stationID)
{
	kdDebug(12006) << "Sending updating for " << stationID << endl;
	emit fileUpdating( stationID );
}

void WeatherService::slotStationRemoved(const QString &stationID)
{
  kdDebug(12006) << "Sending stationRemoved for " << stationID << endl;
  emit stationRemoved( stationID );
}

QString WeatherService::temperature(const QString &stationID)
{
	kdDebug (12006) << "Returning " << stationID << endl;
	return m_weatherLib->temperature(stationID);
}

QString WeatherService::dewPoint(const QString &stationID)
{
	return m_weatherLib->dewPoint(stationID);
}

QString WeatherService::relativeHumidity(const QString &stationID)
{
	return m_weatherLib->relHumidity(stationID);
}

QString WeatherService::heatIndex(const QString &stationID)
{
	return m_weatherLib->heatIndex(stationID);
}

QString WeatherService::windChill(const QString &stationID)
{
	return m_weatherLib->windChill(stationID);
}

QString WeatherService::wind(const QString &stationID)
{
	return m_weatherLib->wind(stationID);
}

QString WeatherService::pressure(const QString &stationID)
{
	return m_weatherLib->pressure(stationID);
}

QPixmap WeatherService::currentIcon(const QString &stationID)
{
    return icon( stationID );
}

QPixmap WeatherService::icon(const QString &stationID)
{
	kdDebug(12006) << "Get the current weather icon.." << endl;
	QString icon  = iconFileName(stationID);
	QPixmap theIcon = QPixmap(icon);
	return theIcon;
}

QString WeatherService::currentIconString(const QString &stationID)
{
	return m_weatherLib->iconName(stationID);
}

QString WeatherService::iconFileName(const QString &stationID)
{
	QString icon  = m_weatherLib->iconName(stationID);
	icon = locate( "data", "kweather/" + icon + ".png" );
	return icon;
}

QString WeatherService::date(const QString &stationID)
{
	return m_weatherLib->date(stationID);
}

QString WeatherService::visibility(const QString &stationID)
{
	return m_weatherLib->visibility(stationID);
}

QStringList WeatherService::cover(const QString &stationID)
{
	return m_weatherLib->cover(stationID);
}

QStringList WeatherService::weather(const QString &stationID)
{
	return m_weatherLib->weather(stationID);
}
void WeatherService::update(const QString &stationID)
{
	m_weatherLib->update(stationID);
}

void WeatherService::forceUpdate(const QString &stationID)
{
	m_weatherLib->forceUpdate(stationID);
}

void WeatherService::removeStation(const QString &stationID)
{
	m_weatherLib->remove(stationID);
	saveSettings();
}

void WeatherService::addStation(const QString &stationID)
{
	m_weatherLib->update(stationID);
	saveSettings();
}

void WeatherService::exit()
{
	saveSettings();
	kapp->quit();
}

QStringList WeatherService::listStations()
{
	return m_weatherLib->stations();
}

void WeatherService::saveSettings()
{
	KConfig *conf = kapp->config();
	conf->setGroup("WEATHERSTATIONS");
	conf->writeEntry( "stations", m_weatherLib->stations());
	conf->sync();
}

QString WeatherService::stationName(const QString &stationID)
{
	if ( stationDB )
		return stationDB->stationNameFromID(stationID);
	else
		return stationID;
}
QString WeatherService::stationCountry(const QString &stationID)
{

	if ( stationDB )
		return stationDB->stationCountryFromID(stationID);
	else
		return stationID;
}
QString WeatherService::longitude(const QString &stationID)
{
	if ( stationDB )
		return stationDB->stationLongitudeFromID(stationID);
	else
		return "None";
}
QString WeatherService::latitude(const QString &stationID)
{
	if ( stationDB )
		return stationDB->stationLatitudeFromID(stationID);
	else
		return "None";
}

QStringList WeatherService::findStations(float lon, float lat)
{
	QStringList stationList;
	stationList << "KMKE" << "KPNE" << "KTPW";
	return stationList;
}

QString WeatherService::sunRiseTime(const QString &stationID)
{
	Sun thesun;

	QString latitude  = stationDB->stationLatitudeFromID(stationID);
	QString longitude = stationDB->stationLongitudeFromID(stationID);

	QTime   rise_time = thesun.computeRiseTime(latitude, longitude);

	kdDebug(12006) << "rise time: " << rise_time << endl;

	return KGlobal::locale()->formatTime(rise_time);
}

QString WeatherService::sunSetTime(const QString &stationID)
{
	Sun thesun;

	QString latitude  = stationDB->stationLatitudeFromID(stationID);
	QString longitude = stationDB->stationLongitudeFromID(stationID);

	QTime   set_time  = thesun.computeSetTime(latitude, longitude);

	kdDebug(12006) << "set time: " << set_time << endl;

	return KGlobal::locale()->formatTime(set_time);
}


#include "weatherservice.moc"
