/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef PREFERENCESWIDGET_H
#define PREFERENCESWIDGET_H

#include "searchengine.h"

class PWidget;

class AuxiliaryPreferencesWidget : public PrefWidget
{
    Q_OBJECT

public:
    AuxiliaryPreferencesWidget(QWidget *parent=0, const char* name=0);
    virtual ~AuxiliaryPreferencesWidget();

    virtual void apply();
    virtual void cancel();
    virtual void standard();

    void setURL(const QString url);
    QString url();

    void setIgnoreFuzzy(bool);
    bool ignoreFuzzy();

    bool settingsChanged() const;
    
signals:
    void restoreSettings();
    void applySettings();
    
public:
    PWidget *prefWidget;

protected slots:
    void setChanged();

private:
    bool changed;

};

#endif
