/* ****************************************************************************
  This file is part of KBabel

  Copyright (C)      2002 by Stanislav Visnovsky
                            <visnovsky@kde.org>
                2002-2003 by Marco Wegner 
                            <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef LINGUISTEXPORT_H
#define LINGUISTEXPORT_H

#include <qdom.h>

#include "catalogfileplugin.h"

class QString;
class QStringList;

namespace KBabel {
class Catalog;
}

class LinguistExportPlugin : public KBabel::CatalogExportPlugin
{
  public:
    LinguistExportPlugin( QObject * parent, const char * name, const QStringList& );
    virtual KBabel::ConversionStatus save( const QString& filename, const QString& mimetype, const KBabel::Catalog * catalog );
    
  private:
    const QString extractComment( QDomDocument& doc, const QString& s );
    void createMessage( QDomDocument& doc, const QString& msgid, const QString& msgstr, 
                        const QString& comment, bool obsolete = false );
    void setContext( QDomDocument& doc, QString newContext );
    
  private:
    QString context;
    QDomElement contextElement;
};

#endif // LINGUISTEXPORT_H
