// eventhandling.cs - qt-csharp Hello World
//
// Author: Adam Treat <manyoso@yahoo.com>
//
// (c) 2002 Adam Treat
//
// Licensed under the terms of the GNU GPL

namespace QtSamples {

	using Qt;
 	using System;

	public class EventHandling : QVBox {

		public static void Main (String[] args)
		{
			QApplication app = new QApplication (args);
			EventHandling evh = new EventHandling ();
			app.SetMainWidget (evh);
			evh.Show ();
			app.Exec ();
		}

		public EventHandling () : base (null)
		{
			// This is the global event handler for QMouseEvents
			mouseHandler += new QMouseHandler(mouseEvents);

			MyButton pb = new MyButton (this);
		}

		public void mouseEvents (QObject sender, QEventArgs e)
		{
			Console.WriteLine ("Mouse event: " + e.Name);
		}

		class MyButton : QPushButton {

			public MyButton (QWidget parent) : base ("Hello Qt-CSharp-0.4!", parent)
			{
				// This is the local event handler for mousePressEvents
				mousePressEvent += new MousePressEvent (pressEvent);
			}

			public void pressEvent (QMouseEvent e)
			{
				Console.WriteLine ("I've been clicked");
			}
		}
	}
}
