/***************************************************************************
                            KShellCompletion.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHELLCOMPLETION_H
#define KSHELLCOMPLETION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KURLCompletion.h>

/**

 This class does shell-like completion of file names.
 A string passed to -makeCompletion will be interpreted as a shell 
 command line. Completion will be done on the last argument on the line. 
 Returned matches consist of the first arguments (uncompleted) plus the 
 completed last argument.

 @author David Smith <dsmith@algonet.se>

 @version $Id:
 
 @short Shell-like completion of file names.
*/

@interface KShellCompletion : KURLCompletion 

/** 
 Constructs a KShellCompletion object.
         
*/
- init;

/** 
 Finds completions to the given text.
 The first match is returned and emitted in the signal -match 
	 
*/
- (NSString *) makeCompletion: (NSString *)arg1;
- postProcessMatch: (NSString *)match;
- postProcessMatches: (NSArray *)matches;
//- postProcessCompletionMatches: (KCompletionMatches*)matches;
@end

/** Override these methods in subclasses of KShellCompletion to customise event handling behaviour */
@protocol KShellCompletionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
