/***************************************************************************
                            KLibLoader.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLIBLOADER_H
#define KLIBLOADER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 The KLibLoader allows you to load libraries dynamically at runtime.
 Dependent libraries are loaded automatically.

 KLibLoader follows the singleton pattern. You can not create multiple
 instances. Use @ref  #--self to get a pointer to the loader.

 @author Torben Weis <weis@kde.org>
 
 @short 
 The KLibLoader allows you to load libraries dynamically at runtime.
*/
@class KInstance; 
@class KLibFactory; 
@class KLibrary; 

@interface KLibLoader : QObject 

/** 
 You should NEVER destruct an instance of KLibLoader
 until you know what you are doing. This will release
 the loaded libraries.
     
*/
- (void) dealloc;

/** 
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.

 This is a convenience function that returns the factory immediately

*/
- (KLibFactory*) factory: (NSString *)libname;

/** 
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)

*/
- (KLibrary*) library: (NSString *)libname;

/** 
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.   The library is loaded such that the symbols are
 globally accessible so libraries with dependencies can be loaded
 sequentially.

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)

*/
- (KLibrary*) globalLibrary: (NSString *)name;
- (NSString *) lastErrorMessage;
- unloadLibrary: (NSString *)libname;

/** 

*/
+ (KLibLoader*) self;

/** 

 This is what makes it possible to rely on ~KLibFactory
 being called in all cases, whether the library is unloaded
 while the application is running or when exiting.
     
*/
+ cleanUp;

/** 
 Helper method which looks for a library in the standard paths
 ("module" and "lib" resources)
 Made public for code that doesn't use KLibLoader itself, but still
 wants to open modules.
     
*/
+ (NSString *) findLibrary: (NSString *)name instance: (KInstance*)instance;
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;
@end

/** Override these methods in subclasses of KLibLoader to customise event handling behaviour */
@protocol KLibLoaderEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
