/***************************************************************************
                            KHistoryCombo.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KHISTORYCOMBO_H
#define KHISTORYCOMBO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KComboBox.h>

/**

 A combobox which implements a history like a unix shell. You can navigate
 through all the items by using the Up or Down arrows (configurable of
 course). Additionally, weighted completion is available. So you should
 load and save the completion list to preserve the weighting between
 sessions.

 @author Carsten Pfeiffer <pfeiffer@kde.org>

 @short A combobox for offering a history and completion.
*/
@class KPixmapProvider; 

@interface KHistoryCombo : KComboBox 

/** 
 Constructs a "read-write" combobox. A read-only history combobox
 doesn't make much sense, so it is only available as read-write.
 Completion will be used automatically for the items in the combo.

 The insertion-policy is set to NoInsertion, you have to add the items
 yourself via the slot @ref addToHistory. If you want every item added,
 use

 <pre>
 connect( combo, SIGNAL( activated( const QString& )),
          combo, SLOT( addToHistory( const QString& )));
 </pre>

 Use @ref -[QComboBox setMaxCount] to limit the history.

 @p parent the parent object of this widget.
 @p name the name of this widget.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Same as the previous constructor, but additionally has the option
 to specify whether you want to let KHistoryCombo handle completion
 or not. If set to @p true, KHistoryCombo will sync the completion to the
 contents of the combobox.
     
*/
- initWithBOOL: (BOOL)useCompletion parent: (QWidget *)parent name: (NSString *)name;
- initWithBOOL: (BOOL)useCompletion ;

/** 
 Destructs the combo, the completion-object and the pixmap-provider
     
*/
- (void) dealloc;

/** 
 Inserts @p items into the combobox. @p items might get
 truncated if it is longer than @ref -maxCount

*/
- setHistoryItems: (NSArray *)items;

/** 
 Inserts @p items into the combobox. @p items might get
 truncated if it is longer than @ref -maxCount

 Set @p setCompletionList to true, if you don't have a list of
 completions. This tells KHistoryCombo to use all the items for the
 completion object as well.
 You won't have the benefit of weighted completion though, so normally
 you should do something like
 <pre>
 KConfig *config = -[kapp config];
 QStringList list;

 // load the history and completion list after creating the history combo
 list = -[config readListEntry]( "Completion list" );
 -[combo completionObject]->setItems( list );
 list = -[config readListEntry]( "History list" );
 -[combo setHistoryItems]( list );

 [...]

 // save the history and completion list when the history combo is
 // destroyed
 list = -[combo completionObject]->-items
 -[config writeEntry]( "Completion list", list );
 list = -[combo historyItems];
 -[config writeEntry]( "History list", list );
 </pre>

 Be sure to use different names for saving with KConfig if you have more
 than one KHistoryCombo.

 Note: When @p setCompletionList is true, the items are inserted into the
 KCompletion object with mode -[KCompletion Insertion]and the mode is set
 to -[KCompletion Weighted]afterwards.

*/
- setHistoryItems: (NSArray *)items setCompletionList: (BOOL)setCompletionList;

/** 
 Returns the list of history items. Empty, when this is not a read-write
 combobox.

*/
- (NSArray *) historyItems;

/** 
 Removes all items named @p item.

*/
- (BOOL) removeFromHistory: (NSString *)item;

/** 
 Sets a pixmap provider, so that items in the combobox can have a pixmap.
 @ref KPixmapProvider is just an abstract class with the one pure virtual
 method @ref -[KPixmapProvider pixmapFor]. This method is called whenever
 an item is added to the KHistoryComboBox. Implement it to return your
 own custom pixmaps, or use the @ref KURLPixmapProvider from libkio,
 which uses @ref -[KMimeType pixmapForURL]to resolve icons.

 Set @p prov to 0L if you want to disable pixmaps. Default no pixmaps.

*/
- setPixmapProvider: (KPixmapProvider*)prov;

/** 

*/
- (KPixmapProvider*) pixmapProvider;

/** 
 Resets the current position of the up/down history. Call this
 when you manually call @ref -setCurrentItem or @ref -clearEdit.
     
*/
- reset;

/** 
 Adds an item to the end of the history list and to the completion list.
 If @ref -maxCount is reached, the first item of the list will be
 removed.

 If the last inserted item is the same as @p item, it will not be
 inserted again.

 If @ref -duplicatesEnabled is false, any equal existing item will be
 removed before @p item is added.

 Note: By using this method and not the Q and KComboBox -insertItem
 methods, you make sure that the combobox stays in sync with the
 completion. It would be annoying if completion would give an item
 not in the combobox, and vice versa.

*/
- addToHistory: (NSString *)item;

/** 
 Clears the history and the completion list.
     
*/
- clearHistory;

/** 
 Inserts @p items into the combo, honouring @ref -pixmapProvider
 Does not update the completionObject.

 Note: @ref -duplicatesEnabled is not honored here.

 Called from @ref -setHistoryItems and @ref -setPixmapProvider
     
*/
- insertItems: (NSArray *)items;

/** 

*/
- (BOOL) useCompletion;
@end

/** Override these methods in subclasses of KHistoryCombo to customise event handling behaviour */
@protocol KHistoryComboEventHandling

/** 
 Handling key-events, the shortcuts to rotate the items.
     
*/
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
