//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMainWindow;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QPopupMenu;
import org.kde.qt.QPixmap;
import org.kde.qt.QSize;
import org.kde.qt.QSizePolicy;
import org.kde.qt.QMouseEvent;
import org.kde.qt.QShowEvent;
import org.kde.qt.QEvent;
import org.kde.qt.QIconSet;
import org.kde.qt.QWidget;
import org.kde.qt.QResizeEvent;
import org.kde.qt.QDomElement;
import org.kde.qt.QChildEvent;
import org.kde.qt.QToolBar;

/**

 A KDE-style toolbar.
 KToolBar can be dragged around in and between different docks.
 A KToolBar can contain all sorts of widgets.
 KToolBar can be used as a standalone widget, but KMainWindow
 provides easy factories and management of one or more toolbars.
 Once you have a KToolBar object, you can insert items into it with the
 insert... methods, or remove them with the removeItem() method. This
 can be done at any time; the toolbar will be automatically updated.
 There are also many methods to set per-child properties like alignment
 and toggle behavior.
 KToolBar uses a global config group to load toolbar settings on
 construction. It will reread this config group on a
 KApplication.appearanceChanged() signal.
 See {@link KToolBarSignals} for signals emitted by KToolBar
		@author Reginald Stadlbauer <reggie@kde.org>, Stephan Kulow <coolo@kde.org>, Sven Radej <radej@kde.org>.
  
		@version  ktoolbar.h,v 1.176 2003/11/05 11:43:22 tokoe

		@short Floatable toolbar with auto resize.

*/
public class KToolBar extends QToolBar  {
	protected KToolBar(Class dummy){super((Class) null);}
	public static final int IconOnly = 0;
	public static final int IconTextRight = 1;
	public static final int TextOnly = 2;
	public static final int IconTextBottom = 3;

	/**	
		 Possible bar positions.
		   		@short    Possible bar positions.
	*/
	public static final int Unmanaged = 0;
	public static final int Floating = 1;
	public static final int Top = 2;
	public static final int Bottom = 3;
	public static final int Right = 4;
	public static final int Left = 5;
	public static final int Flat = 6;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Normal constructor.
		 This constructor is used by the XML-GUI. If you use it, you need
		 to call QMainWindow.addToolBar to specify the position of the toolbar.
		 So it's simpler to use the other constructor.
			 The toolbar will read in various global config settings for
		 things like icon size and text position, etc.  However, some of
		 the settings will be honored only if <code>honorStyle</code> is set to
		 true.  All other toolbars will be IconOnly and use Medium icons.
			@param parent The standard toolbar parent (usually a
		 KMainWindow)
			@param name The standard internal name
			@param honorStyle If true, then global settings for IconSize and IconText will be honored
			@param readConfig whether to apply the configuration (global and application-specific)
		   		@short    Normal constructor.
	*/
	public KToolBar(QWidget parent, String name, boolean honorStyle, boolean readConfig) {
		super((Class) null);
		newKToolBar(parent,name,honorStyle,readConfig);
	}
	private native void newKToolBar(QWidget parent, String name, boolean honorStyle, boolean readConfig);
	public KToolBar(QWidget parent, String name, boolean honorStyle) {
		super((Class) null);
		newKToolBar(parent,name,honorStyle);
	}
	private native void newKToolBar(QWidget parent, String name, boolean honorStyle);
	public KToolBar(QWidget parent, String name) {
		super((Class) null);
		newKToolBar(parent,name);
	}
	private native void newKToolBar(QWidget parent, String name);
	public KToolBar(QWidget parent) {
		super((Class) null);
		newKToolBar(parent);
	}
	private native void newKToolBar(QWidget parent);
	/**	
		 Constructor for non-XML-GUI applications.
			 The toolbar will read in various global config settings for
		 things like icon size and text position, etc.  However, some of
		 the settings will be honored only if <code>honorStyle</code> is set to
		 true.  All other toolbars will be IconOnly and use Medium icons.
			@param parentWindow The window that should be the parent of this toolbar
			@param dock The position of the toolbar. Usually QMainWindow.Top.
			@param newLine If true, start a new line in the dock for this toolbar.
			@param name The standard internal name
			@param honorStyle If true, then global settings for IconSize and IconText will be honored
			@param readConfig whether to apply the configuration (global and application-specific)
		   		@short    Constructor for non-XML-GUI applications.
	*/
	public KToolBar(QMainWindow parentWindow, int dock, boolean newLine, String name, boolean honorStyle, boolean readConfig) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine,name,honorStyle,readConfig);
	}
	private native void newKToolBar(QMainWindow parentWindow, int dock, boolean newLine, String name, boolean honorStyle, boolean readConfig);
	public KToolBar(QMainWindow parentWindow, int dock, boolean newLine, String name, boolean honorStyle) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine,name,honorStyle);
	}
	private native void newKToolBar(QMainWindow parentWindow, int dock, boolean newLine, String name, boolean honorStyle);
	public KToolBar(QMainWindow parentWindow, int dock, boolean newLine, String name) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine,name);
	}
	private native void newKToolBar(QMainWindow parentWindow, int dock, boolean newLine, String name);
	public KToolBar(QMainWindow parentWindow, int dock, boolean newLine) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine);
	}
	private native void newKToolBar(QMainWindow parentWindow, int dock, boolean newLine);
	public KToolBar(QMainWindow parentWindow, int dock) {
		super((Class) null);
		newKToolBar(parentWindow,dock);
	}
	private native void newKToolBar(QMainWindow parentWindow, int dock);
	/**	
		 Constructor for non-XML-GUI applications.
			 The toolbar will read in various global config settings for
		 things like icon size and text position, etc.  However, some of
		 the settings will be honored only if <code>honorStyle</code> is set to
		 true.  All other toolbars will be IconOnly and use Medium icons.
			@param parentWindow The window that should be the parent of this toolbar
			@param dock Another widget than the mainwindow to dock toolbar to.
			@param newLine If true, start a new line in the dock for this toolbar.
			@param name The standard internal name
			@param honorStyle If true, then global settings for IconSize and IconText will be honored
			@param readConfig whether to apply the configuration (global and application-specific)
		   		@short    Constructor for non-XML-GUI applications.
	*/
	public KToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine, String name, boolean honorStyle, boolean readConfig) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine,name,honorStyle,readConfig);
	}
	private native void newKToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine, String name, boolean honorStyle, boolean readConfig);
	public KToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine, String name, boolean honorStyle) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine,name,honorStyle);
	}
	private native void newKToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine, String name, boolean honorStyle);
	public KToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine, String name) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine,name);
	}
	private native void newKToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine, String name);
	public KToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine) {
		super((Class) null);
		newKToolBar(parentWindow,dock,newLine);
	}
	private native void newKToolBar(QMainWindow parentWindow, QWidget dock, boolean newLine);
	public KToolBar(QMainWindow parentWindow, QWidget dock) {
		super((Class) null);
		newKToolBar(parentWindow,dock);
	}
	private native void newKToolBar(QMainWindow parentWindow, QWidget dock);
	/**	
		 Insert a button (a KToolBarButton) with a pixmap.  The
		 pixmap is loaded by the button itself based on the global icon
		 settings.
			 You should connect to one or more signals in KToolBar:
		 clicked() , pressed() , released() , or
		 highlighted()  and if the button is a toggle button
		 ( setToggle() ) toggled() .  Those signals have <code>id</code>
		 of a button that caused the signal.  If you want to bind a popup
		 to button, see setButton().
			@param icon The name of the icon to use as the active pixmap
			@param id The id of this button
			@param enabled Enable or disable the button at startup
			@param text The tooltip or toolbar text (depending on state)
			@param index The position of the button. (-1 = at end).
				@return The item index.
   
		@short    Insert a button (a KToolBarButton) with a pixmap.
	*/
	public native int insertButton(String icon, int id, boolean enabled, String text, int index, KInstanceInterface _instance);
	public native int insertButton(String icon, int id, boolean enabled, String text, int index);
	public native int insertButton(String icon, int id, boolean enabled, String text);
	public native int insertButton(String icon, int id, boolean enabled);
	public native int insertButton(String icon, int id);
	/**	
		 This is the same as above, but with specified signals and
		 slots to which this button will be connected.
			 You can add more signals with addConnection().
			@param icon The name of the icon to use as the active pixmap
			@param id The id of this button
			@param signal The signal to connect to
			@param receiver The slot's parent
			@param slot The slot to receive the signal specified in that argument.
			@param enabled Enable or disable the button at startup
			@param text The tooltip or toolbar text (depending on state)
			@param index The position of the button. (-1 = at end).
				@return The item index.
   
		@short    This is the same as above, but with specified signals and  slots to which this button will be connected.
	*/
	public native int insertButton(String icon, int id, String signal, QObject receiver, String slot, boolean enabled, String text, int index, KInstanceInterface _instance);
	public native int insertButton(String icon, int id, String signal, QObject receiver, String slot, boolean enabled, String text, int index);
	public native int insertButton(String icon, int id, String signal, QObject receiver, String slot, boolean enabled, String text);
	public native int insertButton(String icon, int id, String signal, QObject receiver, String slot, boolean enabled);
	public native int insertButton(String icon, int id, String signal, QObject receiver, String slot);
	/**	
		 Inserts a button (a KToolBarButton) with the specified
		 pixmap.  This pixmap will be used as the "active" one and the
		 disabled and default ones will be autogenerated.
			 It is recommended that you use the insertButton function that
		 allows you to specify the icon name rather then the pixmap
		 itself.  Specifying the icon name is much more flexible.
			 You should connect to one or more signals in KToolBar:
		 clicked() , pressed() , released() , or
		 highlighted()  and if the button is a toggle button
		 ( setToggle() ) toggled() .  Those signals have <code>id</code>
		 of a button that caused the signal.  If you want to bind a popup
		 to button, see setButton().
			@param pixmap The active pixmap
			@param id The id of this button
			@param enabled Enable or disable the button at startup
			@param text The tooltip or toolbar text (depending on state)
			@param index The position of the button. (-1 = at end).
				@return The item index.
   
		@short    Inserts a button (a KToolBarButton) with the specified  pixmap.
	*/
	public native int insertButton(QPixmap pixmap, int id, boolean enabled, String text, int index);
	public native int insertButton(QPixmap pixmap, int id, boolean enabled, String text);
	public native int insertButton(QPixmap pixmap, int id, boolean enabled);
	public native int insertButton(QPixmap pixmap, int id);
	/**	
		 This is the same as above, but with specified signals and
		 slots to which this button will be connected.
			 You can add more signals with addConnection().
			@param pixmap The name of the icon to use as the active pixmap
			@param id The id of this button
			@param signal The signal to connect to
			@param receiver The slot's parent
			@param slot The slot to receive the signal specified in that argument.
			@param enabled Enable or disable the button at startup
			@param text The tooltip or toolbar text (depending on state)
			@param index The position of the button. (-1 = at end).
				@return The item index.
   
		@short    This is the same as above, but with specified signals and  slots to which this button will be connected.
	*/
	public native int insertButton(QPixmap pixmap, int id, String signal, QObject receiver, String slot, boolean enabled, String text, int index);
	public native int insertButton(QPixmap pixmap, int id, String signal, QObject receiver, String slot, boolean enabled, String text);
	public native int insertButton(QPixmap pixmap, int id, String signal, QObject receiver, String slot, boolean enabled);
	public native int insertButton(QPixmap pixmap, int id, String signal, QObject receiver, String slot);
	/**	
		 Inserts a button with popupmenu.
			 Button will have small
		 triangle. You have to connect to popup's signals. The
		 signals KButton.pressed(), KButton.released(),
		 KButton.clicked() or KButton.doubleClicked() are <code>not</code>
		 emmited by
		 this button (see setDelayedPopup() for that).
		 You can add custom popups which inherit QPopupMenu to get popups
		 with tables, drawings etc. Just don't fiddle with events there.
		   		@short    Inserts a button with popupmenu.
	*/
	public native int insertButton(String icon, int id, QPopupMenu popup, boolean enabled, String _text, int index);
	public native int insertButton(String icon, int id, QPopupMenu popup, boolean enabled, String _text);
	/**	
		 Inserts a button with popupmenu.
			 Button will have small
		 triangle. You have to connect to popup's signals. The
		 signals KButton.pressed(), KButton.released(),
		 KButton.clicked() or KButton.doubleClicked() are <code>not</code>
		 emmited by
		 this button (see setDelayedPopup() for that).
		 You can add custom popups which inherit QPopupMenu to get popups
		 with tables, drawings etc. Just don't fiddle with events there.
		   		@short    Inserts a button with popupmenu.
	*/
	public native int insertButton(QPixmap pixmap, int id, QPopupMenu popup, boolean enabled, String _text, int index);
	public native int insertButton(QPixmap pixmap, int id, QPopupMenu popup, boolean enabled, String _text);
	/**	
		 Inserts a KLineEdit. You have to specify signals and slots to
		 which KLineEdit will be connected. KLineEdit has all slots QLineEdit
		 has, plus signals KLineEdit.completion and KLineEdit.textRotation
		 KLineEdit can be set to autoresize itself to full free width
		 in toolbar, that is to last right aligned item. For that,
		 toolbar must be set to full width (which it is by default).
				@return Item index.
   
		@short    Inserts a KLineEdit.
		@see #setFullWidth
		@see #setItemAutoSized
		@see KLineEdit
	*/
	public native int insertLined(String text, int id, String signal, QObject receiver, String slot, boolean enabled, String toolTipText, int size, int index);
	public native int insertLined(String text, int id, String signal, QObject receiver, String slot, boolean enabled, String toolTipText, int size);
	public native int insertLined(String text, int id, String signal, QObject receiver, String slot, boolean enabled, String toolTipText);
	public native int insertLined(String text, int id, String signal, QObject receiver, String slot, boolean enabled);
	public native int insertLined(String text, int id, String signal, QObject receiver, String slot);
	/**	
		 Inserts a KComboBox with list.
			 Can be writable, but cannot contain
		 pixmaps. By default inserting policy is AtBottom, i.e. typed items
		 are placed at the bottom of the list. Can be autosized. If the size
		 argument is specified as -1, the width of the combobox is automatically
		 computed.
				@return Item index.
   
		@short    Inserts a KComboBox with list.
		@see #setFullWidth
		@see #setItemAutoSized
		@see KComboBox
	*/
	public native int insertCombo(String[] list, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext, int size, int index, int policy);
	public native int insertCombo(String[] list, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext, int size, int index);
	public native int insertCombo(String[] list, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext, int size);
	public native int insertCombo(String[] list, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext);
	public native int insertCombo(String[] list, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled);
	public native int insertCombo(String[] list, int id, boolean writable, String signal, QObject receiver, String slot);
	/**	
		 Insert a KComboBox with text.
			 The rest is the same as above.
				@return Item index.
   
		@short    Insert a KComboBox with text.
		@see #setItemAutoSized
		@see KComboBox
	*/
	public native int insertCombo(String text, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext, int size, int index, int policy);
	public native int insertCombo(String text, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext, int size, int index);
	public native int insertCombo(String text, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext, int size);
	public native int insertCombo(String text, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext);
	public native int insertCombo(String text, int id, boolean writable, String signal, QObject receiver, String slot, boolean enabled);
	public native int insertCombo(String text, int id, boolean writable, String signal, QObject receiver, String slot);
	/**	
		 Inserts a separator into the toolbar with the given <code>id.</code>
				@return the separator's index
     
		@short    Inserts a separator into the toolbar with the given <code>id.</code>
	*/
	public native int insertSeparator(int index, int id);
	public native int insertSeparator(int index);
	public native int insertSeparator();
	/**	
		 Inserts a line separator into the toolbar with the given <code>id.</code>
				@return the separator's index
     
		@short    Inserts a line separator into the toolbar with the given <code>id.</code>
	*/
	public native int insertLineSeparator(int index, int id);
	public native int insertLineSeparator(int index);
	public native int insertLineSeparator();
	/**	
		 Inserts a user-defined widget.  The widget <code>must</code> have this
		 toolbar as its parent.
			 Widget must have a QWidget for base class.  Widget can be
		 autosized to full width. If you forget about it, you can get a
		 pointer to this widget with getWidget().
				@return Item index.
   
		@short    Inserts a user-defined widget.
		@see #setItemAutoSized
	*/
	public native int insertWidget(int id, int width, QWidget _widget, int index);
	public native int insertWidget(int id, int width, QWidget _widget);
	/**	
		 Inserts an animated widget.  A KAnimWidget will be created
		 internally using the icon name you provide.
		 This will emit a signal (clicked()) whenever the
		 animation widget is clicked.
			@param id The id for this toolbar item
			@param receiver The parent of your slot
			@param slot The slot to receive the clicked() signal
			@param icons The name of the animation icon group to use
			@param index The item index
				@return The item index
   
		@short    Inserts an animated widget.
		@see #animatedWidget
	*/
	public native int insertAnimatedWidget(int id, QObject receiver, String slot, String icons, int index);
	public native int insertAnimatedWidget(int id, QObject receiver, String slot, String icons);
	/**	
		 This will return a pointer to the animated widget with the
		 given <code>id</code>, if it exists.
			@param id The id for the widget you want to get a pointer to
				@return A pointer to the current animated widget or 0L
   
		@short    This will return a pointer to the animated widget with the  given <code>id</code>, if it exists.
		@see #insertAnimatedWidget
	*/
	public native KAnimWidget animatedWidget(int id);
	/**	
		 Adds connections to items.
			 It is important that you
		 know the <code>id</code> of particular item. Nothing happens if you forget <code>id.</code>
		   		@short    Adds connections to items.
	*/
	public native void addConnection(int id, String signal, QObject receiver, String slot);
	/**	
		 Enables/disables item.
		   		@short    Enables/disables item.
	*/
	public native void setItemEnabled(int id, boolean enabled);
	/**	
		 Sets the icon for a button.
			 Can be used while button is visible.
		   		@short    Sets the icon for a button.
	*/
	public native void setButtonIcon(int id, String _icon);
	/**	
		 Sets button pixmap.
			 Can be used while button is visible.
		   		@short    Sets button pixmap.
	*/
	public native void setButtonPixmap(int id, QPixmap _pixmap);
	/**	
		 Sets a button icon from a QIconSet.
			 Can be used while button is visible.
		   		@short    Sets a button icon from a QIconSet.
	*/
	public native void setButtonIconSet(int id, QIconSet iconset);
	/**	
		 Sets a delayed popup for a button.
			 Delayed popup is what you see in
		 Netscape Navigator's Previous and Next buttons: If you click them you
		 go back
		 or forth. If you press them long enough, you get a history-menu.
		 This is exactly what we do here.
			 You will insert a normal button with connection (or use signals from
		 toolbar):
		 <pre>
		 bar.insertButton(icon, id, SIGNAL("clicked ()"), this,
		                   SLOT (slotClick()), true, "click or wait for popup");
		 </pre>
		 And then add a delayed popup:
		 <pre>
		 bar.setDelayedPopup (id, historyPopup);
		 </pre>
			 Don't add delayed popups to buttons which have normal popups.
			 You may add popups which are derived from QPopupMenu. You may
		 add popups that are already in the menu bar or are submenus of
		 other popups.
		   		@short    Sets a delayed popup for a button.
	*/
	public native void setDelayedPopup(int id, QPopupMenu _popup, boolean toggle);
	public native void setDelayedPopup(int id, QPopupMenu _popup);
	/**	
		 Turns a button into an autorepeat button.
			 Toggle buttons, buttons with menus, or
		 buttons with delayed menus cannot be made into autorepeat buttons.
		 Moreover, you can and will receive
		 only the signal clicked(), but not pressed() or released().
		 When the user presses this button, you will receive the signal clicked(),
		 and if the button is still pressed after some time,
		 you will receive more clicked() signals separated by regular
		 intervals.  Since this uses QButton.setAutoRepeat() ,
		 I can't quantify 'some'.
		   		@short    Turns a button into an autorepeat button.
	*/
	public native void setAutoRepeat(int id, boolean flag);
	public native void setAutoRepeat(int id);
	/**	
		 Turns button into a toggle button if <code>flag</code> is true.
		   		@short    Turns button into a toggle button if <code>flag</code> is true.
	*/
	public native void setToggle(int id, boolean flag);
	public native void setToggle(int id);
	/**	
		 Toggles a togglebutton.
			 If the button is a toggle button  (see setToggle())
		 the button state will be toggled. This will also cause the toolbar to
		 emit the signal KButton.toggled() with parameter <code>id.</code> You must connect to
		 this signal, or use addConnection() to connect directly to the
		 button signal KButton.toggled().
		   		@short    Toggles a togglebutton.
	*/
	public native void toggleButton(int id);
	/**	
		 Sets a toggle button state.
			 If the button is a toggle button (see setToggle())
		 this will set its state flag. This will also emit the signal
		 KButton.toggled().
				@short    Sets a toggle button state.
		@see #setToggle
	*/
	public native void setButton(int id, boolean flag);
	/**	
		 Returns <code>true</code> if button is on and is a toggle button
				@return <code>true</code> if button is on and is a toggle button

		@short    Returns <code>true</code> if button is on and is a toggle button 
		@see #setToggle
	*/
	public native boolean isButtonOn(int id);
	/**	
		 Sets the text of a line editor.
			 Cursor is set at end of text.
		   		@short    Sets the text of a line editor.
	*/
	public native void setLinedText(int id, String text);
	/**	
		 Returns the line editor text.
				@return the line editor text.
   
		@short    Returns the line editor text.
	*/
	public native String getLinedText(int id);
	/**	
		 Inserts <code>text</code> in combobox <code>id</code> at position <code>index.</code>
		   		@short    Inserts <code>text</code> in combobox <code>id</code> at position <code>index.</code>
	*/
	public native void insertComboItem(int id, String text, int index);
	/**	
		 Inserts <code>list</code> in combobox <code>id</code> at position <code>index.</code>
		   		@short    Inserts <code>list</code> in combobox <code>id</code> at position <code>index.</code>
	*/
	public native void insertComboList(int id, String[] list, int index);
	/**	
		 Removes item <code>index</code> from combobox <code>id.</code>
		   		@short    Removes item <code>index</code> from combobox <code>id.</code>
	*/
	public native void removeComboItem(int id, int index);
	/**	
		 Sets item <code>index</code> to be current item in combobox <code>id.</code>
		   		@short    Sets item <code>index</code> to be current item in combobox <code>id.</code>
	*/
	public native void setCurrentComboItem(int id, int index);
	/**	
		 Changes item <code>index</code> in combobox <code>id</code> to text.
			 <code>index</code> = -1 refers current item (one displayed in the button).
		   		@short    Changes item <code>index</code> in combobox <code>id</code> to text.
	*/
	public native void changeComboItem(int id, String text, int index);
	public native void changeComboItem(int id, String text);
	/**	
		 Clears the combobox <code>id.</code>
			 Does not delete it or hide it.
		   		@short    Clears the combobox <code>id.</code>
	*/
	public native void clearCombo(int id);
	/**	
		 Returns text of item <code>index</code> from combobox <code>id.</code>
			 <code>index</code> = -1 refers to current item.
		   		@return text of item <code>index</code> from combobox <code>id.</code>

		@short    Returns text of item <code>index</code> from combobox <code>id.</code>
	*/
	public native String getComboItem(int id, int index);
	public native String getComboItem(int id);
	/**	
		 Returns a pointer to the combobox with <code>id.</code>
			 Example:
		 <pre>
		 KComboBox combo = toolbar.getCombo(combo_id);
		 </pre>
		 That way you can get access to other public methods
		 that KComboBox provides.
		   		@return a pointer to the combobox with <code>id.</code>

		@short    Returns a pointer to the combobox with <code>id.</code>
	*/
	public native KComboBox getCombo(int id);
	/**	
		 Returns a pointer to KToolBarLined with <code>id.</code>
			 Example:
		 <pre>
		 KLineEdit  lined = toolbar.getKToolBarLined(lined_id);
		 </pre>
		 That way you can get access to other public methods
		 that KLineEdit provides. KLineEdit is the same thing
		 as QLineEdit plus completion signals.
		   		@return a pointer to KToolBarLined with <code>id.</code>

		@short    Returns a pointer to KToolBarLined with <code>id.</code>
	*/
	public native KLineEdit getLined(int id);
	/**	
		 Returns a pointer to KToolBarButton.
			 Example:
		 <pre>
		 KToolBarButton  button = toolbar.getButton(button_id);
		 </pre>
		 That way you can get access to other public methods
		 that KToolBarButton provides.
			  Using this method is not recommended.
		   		@short    Returns a pointer to KToolBarButton.
	*/
	public native KToolBarButton getButton(int id);
	/**	
		 Align item to the right.
			 This works only if toolbar is set to full width.
				@short    Align item to the right.
		@see #setFullWidth
	*/
	public native void alignItemRight(int id, boolean right);
	public native void alignItemRight(int id);
	/**	
		 Returns a pointer to the widget corresponding to <code>id.</code>
			 Wrong ids are not tested.
		 You can do with this whatever you want,
		 except change its height (hardcoded). If you change its width
		 you will probably have to call QToolBar.updateRects(true)
				@return a pointer to the widget corresponding to <code>id.</code>

		@short    Returns a pointer to the widget corresponding to <code>id.</code>
		@see org.kde.qt.QWidget
		@see #updateRects
	*/
	public native QWidget getWidget(int id);
	/**	
		 Set item autosized.
			 This works only if the toolbar is set to full width.
		 Only <code>one</code> item can be autosized, and it has to be
		 the last left-aligned item. Items that come after this must be right
		 aligned. Items that can be right aligned are Lineds, Frames, Widgets and
		 Combos. An autosized item will resize itself whenever the toolbar geometry
		 changes to the last right-aligned item (or to end of toolbar if there
		 are no right-aligned items.)
				@short    Set item autosized.
		@see #setFullWidth
		@see #alignItemRight
	*/
	public native void setItemAutoSized(int id, boolean yes);
	public native void setItemAutoSized(int id);
	/**	
		 Remove all items.
			 The toolbar is redrawn after it.
		   		@short    Remove all items.
	*/
	public native void clear();
	/**	
		 Remove item <code>id.</code>
			 Item is deleted. Toolbar is redrawn after it.
		   		@short    Remove item <code>id.</code>
	*/
	public native void removeItem(int id);
	/**	
		 Remove item <code>id.</code>
			 Item is deleted when toolbar is redrawn.
		   		@short    Remove item <code>id.</code>
	*/
	public native void removeItemDelayed(int id);
	/**	
		 Hide item <code>id.</code>
		   		@short    Hide item <code>id.</code>
	*/
	public native void hideItem(int id);
	/**	
		 Show item <code>id.</code>
		   		@short    Show item <code>id.</code>
	*/
	public native void showItem(int id);
	/**	
		 Returns the index of the item <code>id.</code>
				@return the index of the item <code>id.</code>

		@short    Returns the index of the item <code>id.</code>
	*/
	public native int itemIndex(int id);
	/**	
		 Returns the id of the item at the given index.
				@short    Returns the id of the item at the given index.
	*/
	public native int idAt(int index);
	/**	
		 Set toolbar to full parent size (default).
			 In full size mode the bar extends over the parent's full width or height.
		 If the mode is disabled the toolbar tries to take as much space as it
		 needs without wrapping, but it does not exceed the parent box. You can
		 force a certain width or height with setMaxWidth() or
		 setMaxHeight().
			 If you want to use right-aligned items or auto-sized items you must use
		 full size mode.
		   		@short    Set toolbar to full parent size (default).
	*/
	public native void setFullSize(boolean flag);
	public native void setFullSize();
	/**	
		 Returns the full-size mode enabled flag.
				@return <code>true</code> if the full-size mode is enabled.
   
		@short    Returns the full-size mode enabled flag.
	*/
	public native boolean fullSize();
	/**	
		 Set position of toolbar.
				@short    Set position of toolbar.
		@see BarPosition
	*/
	public native void setBarPos(int bpos);
	/**	
		 Returns the toolbar position.
				@return position of toolbar.
   
		@short    Returns the toolbar position.
	*/
	public native int barPos();
	/**	
		 Set title for toolbar when it floats.
			 Titles are however not (yet)
		 visible. You can't change toolbar's title while it's floating.
		   		@short    Set title for toolbar when it floats.
	*/
	public native void setTitle(String _title);
	/**	
		 Set the kind of painting for buttons.
			 Choose from:
		
			<li>
			IconOnly (only icons),
			</li>
			
			<li>
			IconTextRight (icon and text, text is left from icons),
			</li>
			
			<li>
			TextOnly (only text),
			</li>
			
			<li>
			IconTextBottom (icons and text, text is under icons).
			</li>
				   		@short    Set the kind of painting for buttons.
		@see IconText
	*/
	public native void setIconText(int it);
	/**	
		 Similar to setIconText(IconText it) but allows you to
		 disable or enable updating.  If <code>update</code> is false, then the
		 buttons will not be updated.  This is useful only if you know
		 that you will be forcing an update later.
		   		@short    Similar to setIconText(IconText it) but allows you to  disable or enable updating.
	*/
	public native void setIconText(int it, boolean update);
	/**	
		 Returns the current text style for buttons.
				@return the current text style for buttons.
   
		@short    Returns the current text style for buttons.
	*/
	public native int iconTextId();
	/**	
		 Set the icon size to load. Usually you should not call
		 this, the icon size is taken care of by KIconLoader
		 and globally configured.
		 By default, the toolbar will load icons of size 32 for main
		 toolbars and 22 for other toolbars
			@param size The size to use
		   		@short    Set the icon size to load.
		@see KIconLoader#
	*/
	public native void setIconSize(int size);
	/**	
		 Same as setIconText(int size) but allows you
		 to disable the toolbar update.
			@param size The size to use
			@param update If true, then the toolbar will be updated after
		               this
		   		@short    Same as setIconText(int size) but allows you  to disable the toolbar update.
	*/
	public native void setIconSize(int size, boolean update);
	/**	
		 Returns the current icon size for buttons.
				@return the current icon size for buttons.
   
		@short    Returns the current icon size for buttons.
	*/
	public native int iconSize();
	/**	
		 This allows you to enable or disable the context menu.
			@param enable If false, then the context menu will be disabled
		   		@short    This allows you to enable or disable the context menu.
	*/
	public native void setEnableContextMenu(boolean enable);
	public native void setEnableContextMenu();
	/**	
		 Returns the context menu enabled flag
				@return true if the context menu is disabled
   
		@short    Returns the context menu enabled flag
	*/
	public native boolean contextMenuEnabled();
	/**	
		 This will inform a toolbar button to ignore certain style
		 changes.  Specifically, it will ignore IconText (always IconOnly)
		 and will not allow image effects to apply.
			@param id The button to exclude from styles
			@param no_style If true, then it is excluded (default: true).
		   		@short    This will inform a toolbar button to ignore certain style  changes.
	*/
	public native void setItemNoStyle(int id, boolean no_style);
	public native void setItemNoStyle(int id);
	public native void setFlat(boolean flag);
	/**	
		 Returns the total number of items in the toolbar
				@return the total number of items in the toolbar
   
		@short    Returns the total number of items in the toolbar
	*/
	public native int count();
	/**	
		 Instruct the toolbar to save it's current state to either the app
		 config file or to the XML-GUI resource file (whichever has
		 precedence).
		   		@short    Instruct the toolbar to save it's current state to either the app  config file or to the XML-GUI resource file (whichever has  precedence).
	*/
	public native void saveState();
	/**	
		 Save the toolbar settings to group <code>configGroup</code> in <code>config.</code>
		   		@short    Save the toolbar settings to group <code>configGroup</code> in <code>config.</code>
	*/
	public native void saveSettings(KConfig config, String configGroup);
	/**	
		 Read the toolbar settings from group <code>configGroup</code> in <code>config</code>
		 and apply them.
		   		@short    Read the toolbar settings from group <code>configGroup</code> in <code>config</code>  and apply them.
	*/
	public native void applySettings(KConfig config, String configGroup);
	public native void setXMLGUIClient(KXMLGUIClientInterface client);
	/**	
		 Assign a (translated) text to this toolbar. This is used
		 for the tooltip on the handle, and when listing the toolbars.
		   		@short    Assign a (translated) text to this toolbar.
	*/
	public native void setText(String txt);
	/**	
		 Returns the toolbar's text.
				@return the toolbar's text.
   
		@short    Returns the toolbar's text.
	*/
	public native String text();
	public native void setStretchableWidget(QWidget w);
	public native QSizePolicy sizePolicy();
	public native boolean highlight();
	public native QSize sizeHint();
	public native QSize minimumSizeHint();
	public native QSize minimumSize();
	public native void hide();
	public native void show();
	public native void updateRects(boolean arg1);
	public native void updateRects();
	public native void loadState(QDomElement e);
	public native void saveState(QDomElement e);
	/**	
			     		@short
	*/
	public native void positionYourself(boolean force);
	public native void positionYourself();
	public native void setIconText(String txt);
	/**	
		 Returns the global setting for "Highlight buttons under mouse"
				@return global setting for "Highlight buttons under mouse"
     
		@short    Returns the global setting for "Highlight buttons under mouse"
	*/
	public static native boolean highlightSetting();
	/**	
		 Returns the global setting for "Toolbars transparent when moving"
				@return global setting for "Toolbars transparent when moving"
     
		@short    Returns the global setting for "Toolbars transparent when moving"
	*/
	public static native boolean transparentSetting();
	/**	
		 Returns the global setting for "Icon Text"
				@return global setting for "Icon Text"
     
		@short    Returns the global setting for "Icon Text"
	*/
	public static native int iconTextSetting();
	protected native void mousePressEvent(QMouseEvent arg1);
	protected native void childEvent(QChildEvent e);
	public native void showEvent(QShowEvent e);
	protected native void resizeEvent(QResizeEvent e);
	public native boolean event(QEvent e);
	protected native void applyAppearanceSettings(KConfig config, String _configGroup, boolean forceGlobal);
	protected native void applyAppearanceSettings(KConfig config, String _configGroup);
	protected native String settingsGroup();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
