//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QPopupMenu;
import org.kde.qt.QMouseEvent;
import org.kde.qt.QKeyEvent;
import org.kde.qt.QDropEvent;
import org.kde.qt.QEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QResizeEvent;
import org.kde.qt.QLineEdit;

/**

 An enhanced QLineEdit widget for inputting text.
 <li><b>Detail </b></li>
 This widget inherits from QLineEdit and implements the following
 additional functionalities: a completion object that provides both
 automatic and manual text completion as well as multiple match iteration
 features, configurable key-bindings to activate these features and a
 popup-menu item that can be used to allow the user to set text completion
 modes on the fly based on their preference.
 To support these new features KLineEdit also emits a few more
 additional signals.  These are: completion( String ),
 textRotation( KeyBindingType ), and returnPressed( String ).
 The completion signal can be connected to a slot that will assist the
 user in filling out the remaining text.  The text rotation signal is
 intended to be used to iterate through the list of all possible matches
 whenever there is more than one match for the entered text.  The
 <code>returnPressed</code>( String ) signals are the same as QLineEdit's
 except it provides the current text in the widget as its argument whenever
 appropriate.
 This widget by default creates a completion object when you invoke
 the completionObject( boolean ) member function for the first time or
 use setCompletionObject( KCompletion, boolean ) to assign your own
 completion object.  Additionally, to make this widget more functional,
 KLineEdit will by default handle the text rotation and completion
 events internally when a completion object is created through either one
 of the methods mentioned above.  If you do not need this functionality,
 simply use KCompletionBase.setHandleSignals( boolean ) or set the
 booleanean parameter in the above functions to false.
 The default key-bindings for completion and rotation is determined
 from the global settings in KStdAccel.  These values, however,
 can be overridden locally by invoking KCompletionBase.setKeyBinding().
 The values can easily be reverted back to the default setting, by simply
 calling useGlobalSettings(). An alternate method would be to default
 individual key-bindings by usning setKeyBinding() with the default
 second argument.
 If <code>EchoMode</code> for this widget is set to something other than <code>QLineEdit</code>.Normal, 
 the completion mode will always be defaulted to KGlobalSettings.CompletionNone.  
 This is done purposefully to guard against protected entries such as passwords being
 cached in KCompletion's list. Hence, if the <code>EchoMode</code> is not QLineEdit.Normal, the
 completion mode is automatically disabled.
 A read-only KLineEdit will have the same background color as a 
 disabled KLineEdit, but its foreground color will be the one used 
 for the read-write mode. This differs from QLineEdit's implementation
 and is done to give visual distinction between the three different modes: 
 disabled, read-only, and read-write.
 <li><b>Usage </b></li>
 To enable the basic completion feature :
 <pre>
 KLineEdit edit = new KLineEdit( this, "mywidget" );
 KCompletion comp = edit.completionObject();
 // Connect to the return pressed signal - optional
 connect(edit,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");
 </pre>
 To use a customized completion objects or your
 own completion object :
 <pre>
 KLineEdit edit = new KLineEdit( this,"mywidget" );
 KURLCompletion comp = new KURLCompletion();
 edit.setCompletionObject( comp );
 // Connect to the return pressed signal - optional
 connect(edit,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");
 </pre>
 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );
 <li><b>Miscellaneous function calls :</b></li>
 <pre>
 // Tell the widget not to handle completion and
 // iteration internally.
 edit.setHandleSignals( false );
 // Set your own completion key for manual completions.
 edit.setKeyBinding( KCompletionBase.TextCompletion, Qt.End );
 // Hide the context (popup) menu
 edit.setContextMenuEnabled( false );
 // Temporarly disable signal emitions
 // (both completion & iteration signals)
 edit.disableSignals();
 // Default the key-bindings to system settings.
 edit.useGlobalKeyBindings();
 </pre>
 See {@link KLineEditSignals} for signals emitted by KLineEdit
		@author Dawit Alemayehu <adawit@kde.org>
 
		@short An enhanced single line input widget.

*/
public class KLineEdit extends QLineEdit implements KCompletionBaseInterface {
	protected KLineEdit(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs a KLineEdit object with a default text, a parent,
		 and a name.
			@param string Text to be shown in the edit widget.
			@param parent The parent object of this widget.
			@param name the name of this widget
		     		@short    Constructs a KLineEdit object with a default text, a parent,  and a name.
	*/
	public KLineEdit(String string, QWidget parent, String name) {
		super((Class) null);
		newKLineEdit(string,parent,name);
	}
	private native void newKLineEdit(String string, QWidget parent, String name);
	public KLineEdit(String string, QWidget parent) {
		super((Class) null);
		newKLineEdit(string,parent);
	}
	private native void newKLineEdit(String string, QWidget parent);
	/**	
		 Constructs a KLineEdit object with a parent and a name.
			@param parent The parent object of this widget.
			@param name The name of this widget.
		     		@short    Constructs a KLineEdit object with a parent and a name.
	*/
	public KLineEdit(QWidget parent, String name) {
		super((Class) null);
		newKLineEdit(parent,name);
	}
	private native void newKLineEdit(QWidget parent, String name);
	public KLineEdit(QWidget parent) {
		super((Class) null);
		newKLineEdit(parent);
	}
	private native void newKLineEdit(QWidget parent);
	public KLineEdit() {
		super((Class) null);
		newKLineEdit();
	}
	private native void newKLineEdit();
	/**	
		 Sets <code>url</code> into the lineedit. It uses KURL.prettyURL() so
		 that the url is properly decoded for displaying.
		     		@short    Sets <code>url</code> into the lineedit.
	*/
	public native void setURL(KURL url);
	/**	
		 Re-implemented from KCompletionBase for internal reasons.
			 This function is re-implemented in order to make sure that
		 the EchoMode is acceptable before we set the completion mode.
			 See KCompletionBase.setCompletionMode
		     		@short    Re-implemented from KCompletionBase for internal reasons.
	*/
	public native void setCompletionMode(int mode);
	/**	
		 Enables/disables the popup (context) menu.
			 Note that when this function is invoked with its argument
		 set to <code>true</code>, then both the context menu and the completion
		 menu item are enabled.  If you do not want to the completion
		 item to be visible simply invoke hideModechanger() right
		 after calling this method.  Also by default, the context
		 menu is automatically created if this widget is editable. Thus
		 you need to call this function with the argument set to false
		 if you do not want this behavior.
			@param showMenu If <code>true</code>, show the context menu.
		    		@short    Enables/disables the popup (context) menu.
	*/
	public native void setContextMenuEnabled(boolean showMenu);
	/**	
		 Returns <code>true</code> when the context menu is enabled.
		     		@short    Returns <code>true</code> when the context menu is enabled.
	*/
	public native boolean isContextMenuEnabled();
	/**	
		 Enables/Disables handling of URL drops. If enabled and the user
		 drops an URL, the decoded URL will be inserted. Otherwise the default
		 behavior of QLineEdit is used, which inserts the encoded URL.
			@param enable If <code>true</code>, insert decoded URLs
		     		@short    Enables/Disables handling of URL drops.
	*/
	public native void setURLDropsEnabled(boolean enable);
	/**	
		 Returns <code>true</code> when decoded URL drops are enabled
		     		@short    Returns <code>true</code> when decoded URL drops are enabled
	*/
	public native boolean isURLDropsEnabled();
	/**	
		 By default, KLineEdit recognizes <code>Key_Return</code> and <code>Key_Enter</code> and emits
		 the returnPressed() signals, but it also lets the event pass,
		 for example causing a dialog's default-button to be called.
			 Call this method with <code>trap</code> = <code>true</code> to make <code>KLineEdit</code> stop these
		 events. The signals will still be emitted of course.
				@short    By default, KLineEdit recognizes <code>Key_Return</code> and <code>Key_Enter</code> and emits  the returnPressed() signals, but it also lets the event pass,  for example causing a dialog's default-button to be called.
		@see #trapReturnKey
	*/
	public native void setTrapReturnKey(boolean trap);
	/**	
				@return <code>true</code> if keyevents of <code>Key_Return</code> or
 <code>Key_Enter</code> will be stopped or if they will be propagated.

		@short   
		@see #setTrapReturnKey
	*/
	public native boolean trapReturnKey();
	/**	
		 Re-implemented for internal reasons.  API not affected.
			     		@short    Re-implemented for internal reasons.
	*/
	public native boolean eventFilter(QObject arg1, QEvent arg2);
	/**	
			@param create Set this to false if you don't want the box to be created
		               i.e. to test if it is available.
		     		@return the completion-box, that is used in completion mode
 KGlobalSettings.CompletionPopup.
 This method will create a completion-box if none is there, yet.

		@short
	*/
	public native KCompletionBox completionBox(boolean create);
	public native KCompletionBox completionBox();
	/**	
		 Reimplemented for internal reasons, the API is not affected.
		     		@short    Reimplemented for internal reasons, the API is not affected.
	*/
	public native void setCompletionObject(KCompletion arg1, boolean hsig);
	public native void setCompletionObject(KCompletion arg1);
	/**	
		 Reimplemented for internal reasons, the API is not affected.
		     		@short    Reimplemented for internal reasons, the API is not affected.
	*/
	public native void copy();
	/**	
		 Enable text squeezing in read-only line edits if text too long.
		 This only works when the widget is in read-only mode.
				@short    Enable text squeezing in read-only line edits if text too long.
	*/
	public native void setEnableSqueezedText(boolean enable);
	/**	
		 Returns true if text squeezing is enabled.
		 This is only valid when the widget is in read-only mode.
				@short    Returns true if text squeezing is enabled.
	*/
	public native boolean isSqueezedTextEnabled();
	/**	
		 Re-implemented for internal reasons. API not changed.
		     		@short    Re-implemented for internal reasons.
	*/
	public native void setReadOnly(boolean arg1);
	/**	
		 Iterates through all possible matches of the completed text or
		 the history list.
			 This function simply iterates over all possible matches in case
		 multimple matches are found as a result of a text completion request.
		 It will have no effect if only a single match is found.
			@param type The key-binding invoked.
		     		@short    Iterates through all possible matches of the completed text or  the history list.
	*/
	public native void rotateText(int type);
	/**	
		 See KCompletionBase.setCompletedText.
		     		@short    See KCompletionBase.setCompletedText.
	*/
	public native void setCompletedText(String arg1);
	/**	
		 Sets <code>items</code> into the completion-box if completionMode() is
		 CompletionPopup. The popup will be shown immediately.
		     		@short    Sets <code>items</code> into the completion-box if completionMode() is  CompletionPopup.
	*/
	public native void setCompletedItems(String[] items);
	/**	
		 Reimplemented to workaround a buggy QLineEdit.clear()
		 (changing the clipboard to the text we just had in the lineedit)
		     		@short    Reimplemented to workaround a buggy QLineEdit.clear()  (changing the clipboard to the text we just had in the lineedit)
	*/
	public native void clear();
	/**	
		 Squeezes <code>text</code> into the line edit.
		 This can only be used with read-only line-edits.
				@short    Squeezes <code>text</code> into the line edit.
	*/
	public native void setSqueezedText(String text);
	/**	
		 Re-implemented to enable text squeezing. API is not affected.
		     		@short    Re-implemented to enable text squeezing.
	*/
	public native void setText(String arg1);
	/**	
		 Re-implemented for internal reasons.  API not affected.
			 See QLineEdit.resizeEvent().
		    		@short    Re-implemented for internal reasons.
	*/
	protected native void resizeEvent(QResizeEvent arg1);
	/**	
		 Re-implemented for internal reasons.  API not affected.
			 See QLineEdit.keyPressEvent().
		    		@short    Re-implemented for internal reasons.
	*/
	protected native void keyPressEvent(QKeyEvent arg1);
	/**	
		 Re-implemented for internal reasons.  API not affected.
			 See QLineEdit.mousePressEvent().
		    		@short    Re-implemented for internal reasons.
	*/
	protected native void mousePressEvent(QMouseEvent arg1);
	/**	
		 Re-implemented for internal reasons.  API not affected.
			 See QWidget.mouseDoubleClickEvent().
		    		@short    Re-implemented for internal reasons.
	*/
	protected native void mouseDoubleClickEvent(QMouseEvent arg1);
	/**	
		 Re-implemented for internal reasons.  API not affected.
			 See QLineEdit.createPopupMenu().
		    		@short    Re-implemented for internal reasons.
	*/
	protected native QPopupMenu createPopupMenu();
	/**	
		 Re-implemented to handle URI drops.
			 See QLineEdit.dropEvent().
		    		@short    Re-implemented to handle URI drops.
	*/
	protected native void dropEvent(QDropEvent arg1);
	protected native void setCompletedText(String arg1, boolean arg2);
	/**	
		 Sets the widget in userSelection mode or in automatic completion
		 selection mode. This changes the colors of selections.
		     		@short    Sets the widget in userSelection mode or in automatic completion  selection mode.
	*/
	protected native void setUserSelection(boolean userSelection);
	/**	
		 Reimplemented for internal reasons, the API is not affected.
		     		@short    Reimplemented for internal reasons, the API is not affected.
	*/
	protected native void create(long arg1, boolean initializeWindow, boolean destroyOldWindow);
	protected native void create(long arg1, boolean initializeWindow);
	protected native void create(long arg1);
	protected native void create();
	/**	
		 Completes the remaining text with a matching one from
		 a given list.
		    		@short    Completes the remaining text with a matching one from  a given list.
	*/
	protected native void makeCompletion(String arg1);
	protected native void userCancelled(String cancelText);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
	/**	
		 Returns a pointer to the current completion object.
			 If the object does not exist, it is automatically
		 created.  Note that the completion object created
		 here is used by default to handle the signals
		 internally.  It is also deleted when this object's
		 destructor is invoked.  If you do not want these
		 default settings, use setAutoDeleteCompletionObject
		 and setHandleSignals to change the behavior.
		 Alternatively, you can set the booleanean parameter to
		 false to disable the automatic handling of the signals
		 by this object.  Note that the booleanean argument will be
		 ignored if there already exists a completion object since
		 no new object needs to be created. You need to use either
		 setHandleSignals or setCompletionObject for
		 such cases depending on your requirement.
			@param hsig if true, handles signals internally.
				@return a pointer the completion object.
     
		@short    Returns a pointer to the current completion object.
	*/
	public native KCompletion completionObject(boolean hsig);
	public native KCompletion completionObject();
	/**	
		 Enables this object to handle completion and rotation
		 events internally.
			 This function simply assigns a booleanean value that
		 indicates whether it should handle rotation and
		 completion events or not.  Note that this does not
		 stop the object from emitting signals when these
		 events occur.
			@param handle if true, handle completion & rotation internally.
		     		@short    Enables this object to handle completion and rotation  events internally.
	*/
	public native void setHandleSignals(boolean handle);
	/**	
		 Returns true if the completion object is deleted
		 upon this widget's destruction.
			 See setCompletionObject() and enableCompletion()
		 for details.
				@return true if the completion object will be deleted
              automatically
     
		@short    Returns true if the completion object is deleted  upon this widget's destruction.
	*/
	public native boolean isCompletionObjectAutoDeleted();
	/**	
		 Sets the completion object when this widget's destructor
		 is called.
			 If the argument is set to true, the completion object
		 is deleted when this widget's destructor is called.
			@param autoDelete if true, delete completion object on destruction.
		     		@short    Sets the completion object when this widget's destructor  is called.
	*/
	public native void setAutoDeleteCompletionObject(boolean autoDelete);
	/**	
		 Sets the widget's ability to emit text completion and
		 rotation signals.
			 Invoking this function with <code>enable</code> set to <code>false</code> will
		 cause the completion & rotation signals not to be emitted.
		 However, unlike setting the completion object to <code>NULL</code>
		 using setCompletionObject, disabling the emition of
		 the signals through this method does not affect the current
		 completion object.
			 There is no need to invoke this function by default.  When a
		 completion object is created through completionObject or
		 setCompletionObject, these signals are set to emit
		 automatically.  Also note that disabling this signals will not
		 necessarily interfere with the objects ability to handle these
		 events internally.  See setHandleSignals.
			@param enable if false, disables the emition of completion & rotation signals.
		     		@short    Sets the widget's ability to emit text completion and  rotation signals.
	*/
	public native void setEnableSignals(boolean enable);
	/**	
		 Returns true if the object handles the signals.
				@return true if this signals are handled internally.
     
		@short    Returns true if the object handles the signals.
	*/
	public native boolean handleSignals();
	/**	
		 Returns true if the object emits the signals.
				@return true if signals are emitted
     
		@short    Returns true if the object emits the signals.
	*/
	public native boolean emitSignals();
	/**	
		 Returns the current completion mode.
			 The return values are of type KGlobalSettings.Completion.
		 See setCompletionMode() for details.
				@return the completion mode.
     
		@short    Returns the current completion mode.
	*/
	public native int completionMode();
	/**	
		 Sets the key-binding to be used for manual text
		 completion, text rotation in a history list as
		 well as a completion list.
			 When the keys set by this function are pressed, a
		 signal defined by the inheriting widget will be activated.
		 If the default value or 0 is specified by the second
		 parameter, then the key-binding as defined in the global
		 setting should be used.  This method returns false value
		 for <code>key</code> is negative or the supplied key-binding conflicts
		 with the ones set for one of the other features.
			 NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
		 the key-binding simply simply <code>sum</code> up the values of the
		 modifier and the actual key.  For example, to use CTRL+E as
		 a key binding for one of the items, you would simply supply
		 <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
		 function.
			@param item the feature whose key-binding needs to be set:
		
			<li>
			TextCompletion the manual completion key-binding.
			</li>
			
			<li>
			PrevCompletionMatch    the previous match key for multiple completion.
			</li>
			
			<li>
			NextCompletionMatch    the next match key for for multiple completion.
			</li>
			
			<li>
			SubstringCompletion  the key for substring completion
			</li>
				@param key key-binding used to rotate down in a list.
				@return true if key-binding can successfully be set.

		@short    Sets the key-binding to be used for manual text  completion, text rotation in a history list as  well as a completion list.
		@see #getKeyBinding
	*/
	public native boolean setKeyBinding(int item, KShortcut key);
	/**	
		 Returns the key-binding used for the specified item.
			 This methods returns the key-binding used to activate
		 the feature feature given by <code>item.</code>  If the binding
		 contains modifier key(s), the SUM of the modifier key
		 and the actual key code are returned.
			@param item the item to check
				@return the key-binding used for the feature given by <code>item.</code>

		@short    Returns the key-binding used for the specified item.
		@see #setKeyBinding
	*/
	public native KShortcut getKeyBinding(int item);
	/**	
		 Sets this object to use global values for key-bindings.
			 This method changes the values of the key bindings for
		 rotation and completion features to the default values
		 provided in KGlobalSettings.
			 NOTE: By default inheriting widgets should uses the
		 global key-bindings so that there will be no need to
		 call this method.
		     		@short    Sets this object to use global values for key-bindings.
	*/
	public native void useGlobalKeyBindings();
	/**	
		 Returns a pointer to the completion object.
			 This method is only different from completionObject()
		 in that it does not create a new KCompletion object even if
		 the internal pointer is <code>NULL.</code> Use this method to get the
		 pointer to a completion object when inheriting so that you
		 won't inadvertently create it!!
				@return the completion object or NULL if one does not exist.
     
		@short    Returns a pointer to the completion object.
	*/
	public native KCompletion compObj();
	/**	
		 Returns a key-binding map.
			 This method is the same as getKeyBinding() except it
		 returns the whole keymap containing the key-bindings.
				@return the key-binding used for the feature given by <code>item.</code>
     
		@short    Returns a key-binding map.
	*/
	// KCompletionBase::KeyBindingMap getKeyBindings(); >>>> NOT CONVERTED
	/**	
		 Sets or removes the delegation object. If a delegation object is
		 set, all function calls will be forwarded to the delegation object.
			@param delegate the delegation object, or 0 to remove it
		     		@short    Sets or removes the delegation object.
	*/
	protected native void setDelegate(KCompletionBaseInterface delegate);
	/**	
		 Returns the delegation object.
				@return the delegation object, or 0 if there is none

		@short    Returns the delegation object.
		@see #setDelegate
	*/
	protected native KCompletionBaseInterface delegate();
}
