/***************************************************************************
                            kde_KSystemTray.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSYSTEMTRAY
#define KDE_KSYSTEMTRAY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
  KDE System Tray Window class

 This class implements system tray windows.

 A tray window is a small window (typically 24x24 pixel) that docks
 into the system tray in the desktop panel. It usually displays an
 icon or an animated icon there. The icon serves as representative
 for the application, similar to a taskbar button, but consumes less
 screen space.

 When the user clicks with the left mouse button on the icon, the
 main application window is shown/raised and activated. With the
 right mouse button, she gets a popupmenu with application specific
 commands, including "Minimize/Restore" and "Quit".

 Docking happens magically when calling show(). The window undocks
 with either hide() or when it is destroyed.

 KSystemTray inherits methods such as @ref setPixmap() and @ref setMovie() to
 specify an icon or movie (animated icon) respectively. It is
 designed to be usable "as is", without the need to subclass it. In
 case you need to provide something special (such as an additional
 popupmenu on a click with the left mouse button), you can subclass
 anyway, of course.

 Having an icon on the system tray is a useful technique for
 daemon-like applications that may run for some time without user
 interaction but have to be there immediately when the user needs
 them. Examples are kppp, kisdn, kscd, kmix or knotes. With kppp and
 kisdn, the docked icon even provides real-time information about
 the network status.

 @author Matthias Ettrich <ettrich@kde.org>

 @short KDE System Tray Window class.
*/

/** *
 Construct a KSystemTray widget just like any other widget.

 The parent widget @p parent has a special meaning:
 Besides owning the tray window, the parent widget will
 dissappear from taskbars when it is iconified while the tray
 window is visible. This is the desired behaviour. After all,
 the tray window @p is the parent's taskbar icon.

 Furthermore, the parent widget is shown or raised respectively
 when the user clicks on the trray window with the left mouse
 button.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KSystemTray * kde_new_KSystemTray(qt_QWidget * parent, char* name);
void kde_del_KSystemTray( kde_KSystemTray* p );

/** *
       Reimplemented to provide the standard show/raise behaviour
       for the parentWidget() and the context menu.

       Feel free to reimplement this if you need something special.
     
*/

/** *
       Reimplemented to provide the standard show/raise behaviour
       for the parentWidget() and the context menu.

       Feel free to reimplement this if you need something special.
     
*/

/** *
       Access to the context menu. This makes it easy to add new items
       to it.
     
*/
kde_KPopupMenu* kde_KSystemTray_contextMenu(kde_KSystemTray* instPointer);

/** *
       Makes it easy to adjust some menu items right before the
       context menu becomes visible.
     
*/
void kde_KSystemTray_contextMenuAboutToShow(kde_KSystemTray* instPointer,kde_KPopupMenu* menu);

/** *
       Easy access to the actions in the context menu
       Currently includes KStdAction::Quit and minimizeRestore

*/
kde_KActionCollection* kde_KSystemTray_actionCollection(kde_KSystemTray* instPointer);

/** *
       Reimplemented for internal reasons.
     
*/

/** *
       Reimplemented for internal reasons.
     
*/
void kde_KSystemTray_virtual_hook(kde_KSystemTray* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
