/***************************************************************************
                            kde_KFontDialog.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFONTDIALOG
#define KDE_KFONTDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KFontDialog provides a dialog for interactive font selection.
 It is basically a thin wrapper around the @ref KFontChooser widget,
 which can also be used standalone. In most cases, the simplest
 use of this class is the static method @ref KFontDialog::getFont(),
 which pops up the dialog, allows the user to select a font, and
 returns when the dialog is closed.

 Example:

 <pre>
      QFont myFont;
      int result = KFontDialog::getFont( myFont );
      if ( result == KFontDialog::Accepted )
            ...
 </pre>

 \image html kfontdialog.png "KDE Font Dialog"

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: kde_KFontDialog.h,v 1.6 2002/12/30 14:37:06 geiseri Exp $
 
 @short A font selection dialog.

*/

/** *
 Constructs a font selection dialog.

   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KFontDialog * kde_new_KFontDialog(qt_QWidget * parent, char* name, int onlyFixed, int modal, qt_QStringList* fontlist, int makeFrame, int diff, int* sizeIsRelativeState);

/** *
 Sets the currently selected font in the dialog.

*/
void kde_KFontDialog_setFont(kde_KFontDialog* instPointer,qt_QFont * font, int onlyFixed);

/** *

*/
qt_QFont * kde_KFontDialog_font(kde_KFontDialog* instPointer);

/** *
 Sets the state of the checkbox indicating whether the font size
 is to be interpreted as relative size.
 NOTE: If parameter sizeIsRelative was not set in the constructor
       of the dialog this setting will be ignored.
   
*/

/** *

*/

/** *
 Creates a modal font dialog, lets the user choose a font,
 and returns when the dialog is closed.

*/
int kde_KFontDialog_getFont( qt_QFont * theFont, int onlyFixed, qt_QWidget * parent, int makeFrame, int* sizeIsRelativeState);

/** *
 Creates a modal font difference dialog, lets the user choose a selection
 of changes that should be made to a set of fonts, and returns when the
 dialog is closed. Useful for choosing slight adjustments to the font set
 when the user would otherwise have to manually edit a number of fonts.

*/
int kde_KFontDialog_getFontDiff( qt_QFont * theFont, int diffFlags, int onlyFixed, qt_QWidget * parent, int makeFrame, int* sizeIsRelativeState);

/** *
 When you are not only interested in the font selected, but also
 in the example string typed in, you can call this method.

*/
int kde_KFontDialog_getFontAndText( qt_QFont * theFont, qt_QString * theString, int onlyFixed, qt_QWidget * parent, int makeFrame, int* sizeIsRelativeState);
void kde_KFontDialog_virtual_hook(kde_KFontDialog* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
