/***************************************************************************
                            kde_KAction.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KACTION
#define KDE_KACTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KAction class (and derived and super classes) provides a way to
 easily encapsulate a "real" user-selected action or event in your
 program.

 For instance, a user may want to @p paste the contents of
 the clipboard or @p scroll @p down a document or @p quit the
 application.  These are all @p actions -- events that the
 user causes to happen.  The KAction class allows the developer to
 deal with these actions in an easy and intuitive manner.

 Specifically, the KAction class encapsulated the various attributes
 to an event/action.  For instance, an action might have an icon
 that goes along with it (a clipboard for a "paste" action or
 scissors for a "cut" action).  The action might have some text to
 describe the action.  It will certainly have a method or function
 that actually @p executes the action!  All these attributes
 are contained within the KAction object.

 The advantage of dealing with Actions is that you can manipulate
 the Action without regard to the GUI representation of it.  For
 instance, in the "normal" way of dealing with actions like "cut",
 you would manually insert a item for Cut into a menu and a button
 into a toolbar.  If you want to disable the cut action for a moment
 (maybe nothing is selected), you woud have to hunt down the pointer
 to the menu item and the toolbar button and disable both
 individually.  Setting the menu item and toolbar item up uses very
 similar code - but has to be done twice!

 With the Action concept, you simply "plug" the Action into whatever
 GUI element you want.  The KAction class will then take care of
 correctly defining the menu item (with icons, accelerators, text,
 etc) or toolbar button.. or whatever.  From then on, if you
 manipulate the Action at all, the effect will propogate through all
 GUI representations of it.  Back to the "cut" example: if you want
 to disable the Cut Action, you would simply do
 'cutAction->setEnabled(false)' and the menuitem and button would
 instantly be disabled!

 This is the biggest advantage to the Action concept -- there is a
 one-to-one relationship between the "real" action and @p all
 GUI representations of it.

 KAction emits the activated() signal if the user activated the 
 corresponding GUI element ( menu item, toolbar button, etc. )

 If you are in the situation of wanting to map the activated() 
 signal of multiple action objects to one slot, with a special 
 argument bound to each action, then you might consider using 
 @ref QSignalMapper . A tiny example:

 <PRE>
 QSignalMapper *desktopNumberMapper = new QSignalMapper( this );
 connect( desktopNumberMapper, SIGNAL( mapped( int ) ),
          this, SLOT( moveWindowToDesktop( int ) ) );

 for ( uint i = 0; i < numberOfDesktops; ++i ) {
     KAction *desktopAction = new KAction( i18n( "Move Window To Desktop %i" ).arg( i ), ... );
     connect( desktopAction, SIGNAL( activated() ), desktopNumberMapper, SLOT( map() ) );
     desktopNumberMapper->setMapping( desktopAction, i );
 }
 </PRE>

 The steps to using actions are roughly as follows

 Here is an example of enabling a "New [document]" action
 <PRE>
 KAction *newAct = new KAction(i18n("&New"), "filenew",
                               KStdAccel::shortcut(KStdAccel::New),
                               this, SLOT(fileNew()),
                               actionCollection(), "new");
 </PRE>
 This line creates our action.  It says that wherever this action is
 displayed, it will use "&New" as the text, the standard icon, and
 the standard shortcut.  It further says that whenever this action
 is invoked, it will use the fileNew() slot to execute it.

 <PRE>
 QPopupMenu *file = new QPopupMenu;
 newAct->plug(file);
 </PRE>
 That just inserted the action into the File menu.  The point is, it's not
 important in which menu it is: all manipulation of the item is
 done through the newAct object.

 <PRE>
 newAct->plug(toolBar());
 </PRE>
 And this inserted the Action into the main toolbar as a button.

 That's it!

 If you want to disable that action sometime later, you can do so
 with
 <PRE>
 newAct->setEnabled(false)
 </PRE>
 and both the menuitem in File and the toolbar button will instantly
 be disabled.

 Note: if you are using a "standard" action like "new", "paste",
 "quit", or any other action described in the KDE UI Standards,
 please use the methods in the @ref KStdAction class rather than
 defining your own.

 If you are using KAction within the context of the XML menu and
 toolbar building framework, then there are a few tiny changes.  The
 first is that you must insert your new action into an action
 collection.  The action collection (a @ref KActionCollection) is,
 logically enough, a central collection of all of the actions
 defined in your application.  The XML UI framework code in KXMLGUI
 classes needs access to this collection in order to build up the
 GUI (it's how the builder code knows which actions are valid and
 which aren't).

 Also, if you use the XML builder framework, then you do not ever
 have to plug your actions into containers manually.  The framework
 does that for you.

 @short Class to encapsulate user-driven action or event.
*/

/** *
 Constructs an action with text, potential keyboard
 shortcut, and a SLOT to call when this action is invoked by
 the user.

 If you do not want or have a keyboard shortcut,
 set the @p cut param to 0.

 This is the most common KAction used when you do not have a
 corresponding icon (note that it won't appear in the current version
 of the "Edit ToolBar" dialog, because an action needs an icon to be
 plugged in a toolbar...).

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KAction * kde_new_KAction(qt_QString * text, kde_KShortcut* cut, qt_QObject * receiver, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Constructs an action with text, icon, potential keyboard
 shortcut, and a SLOT to call when this action is invoked by
 the user.

 If you do not want or have a keyboard shortcut, set the
 @p cut param to 0.

 This is the other common KAction used.  Use it when you
 @p do have a corresponding icon.

*/
kde_KAction * kde_new_KAction1(qt_QString * text, qt_QIconSet* pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Constructs an action with text, icon, potential keyboard
 shortcut, and a SLOT to call when this action is invoked by
 the user.  The icon is loaded on demand later based on where it
 is plugged in.

 If you do not want or have a keyboard shortcut, set the
 @p cut param to 0.

 This is the other common KAction used.  Use it when you
 @p do have a corresponding icon.

*/
kde_KAction * kde_new_KAction2(qt_QString * text, qt_QString * pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, kde_KActionCollection* parent, char* name);

/** *
 The same as the above constructor, but with a KGuiItem providing
 the text and icon.

*/
kde_KAction * kde_new_KAction3(kde_KGuiItem* item, kde_KShortcut* cut, qt_QObject * receiver, char* slot, kde_KActionCollection* parent, char* name);

/** *
 @obsolete
	 
*/
kde_KAction * kde_new_KAction4(qt_QString * text, kde_KShortcut* cut, qt_QObject * parent, char* name);

/** *
 @obsolete
	 
*/
kde_KAction * kde_new_KAction5(qt_QString * text, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name);

/** *
 @obsolete
	 
*/
kde_KAction * kde_new_KAction6(qt_QString * text, qt_QIconSet* pix, kde_KShortcut* cut, qt_QObject * parent, char* name);

/** *
 @obsolete
	 
*/
kde_KAction * kde_new_KAction7(qt_QString * text, qt_QString * pix, kde_KShortcut* cut, qt_QObject * parent, char* name);

/** *
 @obsolete
	 
*/
kde_KAction * kde_new_KAction8(qt_QString * text, qt_QIconSet* pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name);

/** *
 @obsolete
	 
*/
kde_KAction * kde_new_KAction9(qt_QString * text, qt_QString * pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name);

/** *
 @obsolete
	 
*/
kde_KAction * kde_new_KAction10(qt_QObject * parent, char* name);

/** *
 Standard destructor
     
*/
void kde_del_KAction( kde_KAction* p );

/** *
 "Plug" or insert this action into a given widget.

 This will
 typically be a menu or a toolbar.  From this point on, you will
 never need to directly manipulate the item in the menu or
 toolbar.  You do all enabling/disabling/manipulation directly
 with your KAction object.

*/
int kde_KAction_plug(kde_KAction* instPointer,qt_QWidget * w, int index);

/** *

 "Plug" or insert this action into a given KAccel.

*/
void kde_KAction_plugAccel(kde_KAction* instPointer,kde_KAccel* accel, int configurable);

/** *
 "Unplug" or remove this action from a given widget.

 This will typically be a menu or a toolbar.  This is rarely
 used in "normal" application.  Typically, it would be used if
 your application has several views or modes, each with a
 completely different menu structure.  If you simply want to
 disable an action for a given period, use @ref setEnabled()
 instead.

*/
void kde_KAction_unplug(kde_KAction* instPointer,qt_QWidget * w);

/** *

 Disconnect this action from the KAccel.
     
*/
void kde_KAction_unplugAccel(kde_KAction* instPointer);

/** *
 returns whether the action is plugged into any container widget or not.

*/
int kde_KAction_isPlugged(kde_KAction* instPointer);

/** *
 returns whether the action is plugged into the given container
     
*/
int kde_KAction_isPlugged1(kde_KAction* instPointer,qt_QWidget * container);

/** *
 returns whether the action is plugged into the given container with the given, container specific, id (often
 menu or toolbar id ) .
     
*/
int kde_KAction_isPlugged2(kde_KAction* instPointer,qt_QWidget * container, int identifier);

/** *
 returns whether the action is plugged into the given container with the given, container specific, representative
 container widget item.
     
*/
int kde_KAction_isPlugged3(kde_KAction* instPointer,qt_QWidget * container, qt_QWidget * _representative);
qt_QWidget * kde_KAction_container(kde_KAction* instPointer,int index);
int kde_KAction_itemId(kde_KAction* instPointer,int index);
qt_QWidget * kde_KAction_representative(kde_KAction* instPointer,int index);
int kde_KAction_containerCount(kde_KAction* instPointer);
unsigned int kde_KAction_kaccelCount(kde_KAction* instPointer);
int kde_KAction_hasIcon(kde_KAction* instPointer);
int kde_KAction_hasIconSet(kde_KAction* instPointer);
qt_QString * kde_KAction_plainText(kde_KAction* instPointer);

/** *
 Get the text associated with this action.
     
*/
qt_QString * kde_KAction_text(kde_KAction* instPointer);

/** *
 Get the keyboard shortcut associated with this action.
     
*/
kde_KShortcut* kde_KAction_shortcut(kde_KAction* instPointer);

/** *
 Get the default shortcut for this action.
     
*/
kde_KShortcut* kde_KAction_shortcutDefault(kde_KAction* instPointer);
qt_QString * kde_KAction_shortcutText(kde_KAction* instPointer);
void kde_KAction_setShortcutText(kde_KAction* instPointer,qt_QString * arg1);

/** *
 Returns true if this action is enabled.
     
*/
int kde_KAction_isEnabled(kde_KAction* instPointer);

/** *
 Returns true if this action's shortcut is configurable.
     
*/
int kde_KAction_isShortcutConfigurable(kde_KAction* instPointer);
qt_QString * kde_KAction_group(kde_KAction* instPointer);

/** *
 Get the What's this text for the action.
     
*/
qt_QString * kde_KAction_whatsThis(kde_KAction* instPointer);

/** *
 Get the tooltip text for the action.
     
*/
qt_QString * kde_KAction_toolTip(kde_KAction* instPointer);

/** *
 Get the QIconSet from which the icons used to display this action will
 be chosen.
     
*/
qt_QIconSet* kde_KAction_iconSet(kde_KAction* instPointer,int group, int size);
qt_QIconSet* kde_KAction_iconSet1(kde_KAction* instPointer);
qt_QString * kde_KAction_icon(kde_KAction* instPointer);
kde_KActionCollection* kde_KAction_parentCollection(kde_KAction* instPointer);
void kde_KAction_unplugAll(kde_KAction* instPointer);

/** *

 Get the keyboard accelerator associated with this action.
     
*/
int kde_KAction_accel(kde_KAction* instPointer);
qt_QString * kde_KAction_statusText(kde_KAction* instPointer);

/** *

 Sets the keyboard accelerator associated with this action.
     
*/
void kde_KAction_setAccel(kde_KAction* instPointer,int key);

/** *

     
*/
void kde_KAction_setStatusText(kde_KAction* instPointer,qt_QString * text);

/** *

     
*/
int kde_KAction_menuId(kde_KAction* instPointer,int i);

/** *
 Sets the text associated with this action. The text is used for menu
 and toolbar labels etc.
     
*/
void kde_KAction_setText(kde_KAction* instPointer,qt_QString * text);

/** *
 Sets the keyboard shortcut associated with this action.
     
*/
int kde_KAction_setShortcut(kde_KAction* instPointer,kde_KShortcut* arg1);
void kde_KAction_setGroup(kde_KAction* instPointer,qt_QString * arg1);

/** *
 Sets the What's this text for the action. This text will be displayed when
 a widget that has been created by plugging this action into a container
 is clicked on in What's this mode.

 The What's this text can include QML markup as well as raw text.
     
*/
void kde_KAction_setWhatsThis(kde_KAction* instPointer,qt_QString * text);

/** *
 Sets the tooltip text for the action.
 This will be used as a tooltip for a toolbar button, as a
 statusbar help-text for a menu item, and it also appears
 in the toolbar editor, to describe the action.
     
*/
void kde_KAction_setToolTip(kde_KAction* instPointer,qt_QString * arg1);

/** *
 Sets the QIconSet from which the icons used to display this action will
 be chosen.
     
*/
void kde_KAction_setIconSet(kde_KAction* instPointer,qt_QIconSet* iconSet);
void kde_KAction_setIcon(kde_KAction* instPointer,qt_QString * icon);

/** *
 Enables or disables this action. All uses of this action (eg. in menus
 or toolbars) will be updated to reflect the state of the action.
     
*/
void kde_KAction_setEnabled(kde_KAction* instPointer,int enable);

/** *
 Indicate whether the user may configure the action's shortcut.
     
*/
void kde_KAction_setShortcutConfigurable(kde_KAction* instPointer,int arg1);

/** *
 Emulate user's interaction programmatically, by activating the action.
 The implementation simply emits activated().
     
*/
void kde_KAction_activate(kde_KAction* instPointer);

/** *

 Generate a toolbar button id. Made public for reimplementations.
     
*/
int kde_KAction_getToolButtonID( );
kde_KToolBar* kde_KAction_toolBar(kde_KAction* instPointer,int index);
qt_QPopupMenu* kde_KAction_popupMenu(kde_KAction* instPointer,int index);
void kde_KAction_removeContainer(kde_KAction* instPointer,int index);
int kde_KAction_findContainer(kde_KAction* instPointer,qt_QWidget * widget);
void kde_KAction_plugMainWindowAccel(kde_KAction* instPointer,qt_QWidget * w);
void kde_KAction_addContainer(kde_KAction* instPointer,qt_QWidget * parent, int identifier);
void kde_KAction_addContainer1(kde_KAction* instPointer,qt_QWidget * parent, qt_QWidget * representative);
void kde_KAction_updateShortcut(kde_KAction* instPointer,int i);
void kde_KAction_updateShortcut1(kde_KAction* instPointer,qt_QPopupMenu* menu, int identifier);
void kde_KAction_updateGroup(kde_KAction* instPointer,int identifier);
void kde_KAction_updateText(kde_KAction* instPointer,int i);
void kde_KAction_updateEnabled(kde_KAction* instPointer,int i);
void kde_KAction_updateIconSet(kde_KAction* instPointer,int i);
void kde_KAction_updateIcon(kde_KAction* instPointer,int i);
void kde_KAction_updateToolTip(kde_KAction* instPointer,int identifier);
void kde_KAction_updateWhatsThis(kde_KAction* instPointer,int i);
qt_QString * kde_KAction_whatsThisWithIcon(kde_KAction* instPointer);
void kde_KAction_virtual_hook(kde_KAction* instPointer,int identifier, void* data);
void kde_KAction_slotDestroyed(kde_KAction* instPointer);
void kde_KAction_slotKeycodeChanged(kde_KAction* instPointer);
void kde_KAction_slotActivated(kde_KAction* instPointer);

#ifdef __cplusplus
}
#endif
#endif
