#include "common.h"
#include "gnomeicu.h"
#include "listwindow.h"
#include "notify.h"

#include <gtk/gtk.h>
#include <string.h>

static void modify_notify_list( GtkWidget *widget, gpointer data );

static gboolean is_notify (CONTACT_PTR contact);

gboolean is_notify (CONTACT_PTR contact)
{
	return (contact ? contact->online_notify : FALSE);
}

void notify_list_dialog( void )
{
	static GtkWidget *dlg = NULL;
	
	if( dlg == NULL )
	{
		dlg = list_window_new(
			_("Online Notify List"),
			_("Drag the users you wish to add to your\n"
			  "notify list into this window, and then click\n"
			  "the \"Ok\" button below."),
			GTK_STOCK_OK, NULL,
			G_CALLBACK (modify_notify_list),
			is_notify
		);
		gtk_widget_show_all( dlg );
		g_object_add_weak_pointer (G_OBJECT (dlg), (gpointer *)&dlg);
	} else {
		gtk_window_present (GTK_WINDOW (dlg));
	}
}

void modify_notify_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "modify_notify_list\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		kontakt->online_notify = FALSE;
		contact = contact->next;
	}

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &uin );
		contact = Contacts;
		while( contact != NULL )
		{
			if( !strcmp(uin, kontakt->uin) )
			{
				kontakt->online_notify = TRUE;
			}

			contact = contact->next;
		}
	}

	Save_RC();
}
