/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_clist.c - callbacks for the clist widget
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "callbacks_clist.h"
#include "interface.h"
#include "support.h"
#include "types.h"
#include "utils.h"
#include "log.h"
#include "dxcc.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern statetype state;
extern gchar **bandsplit;
extern gchar **modesplit;
extern preferencestype preferences;
extern GList *logwindowlist;


/* a row is selected, update the qso frame */
void
on_log_select_row (GtkCList * clist, gint row, gint column, GdkEvent * event,
		   gpointer user_data)
{
  GtkWidget *dateentry, *gmtentry, *endentry, *callentry, *rstentry,
    *myrstentry, *remarksentry, *bandentry, *modeentry, *outcheckbutton,
    *incheckbutton, *powerentry, *nameentry, *qthentry, *locatorentry,
    *unknownentry1, *unknownentry2, *modeoptionmenu, *bandoptionmenu,
    *qsoframe, *widget;
  gchar *frametext, *bandcopy, *label, *entry;
  guint i, bandindex = 0, modeindex = 0, column_nr;
  logtype *logwindow;

  dateentry = lookup_widget (mainwindow, "dateentry");
  gmtentry = lookup_widget (mainwindow, "gmtentry");
  endentry = lookup_widget (mainwindow, "endentry");
  callentry = lookup_widget (mainwindow, "callentry");
  bandentry = lookup_widget (mainwindow, "bandentry");
  modeentry = lookup_widget (mainwindow, "modeentry");
  rstentry = lookup_widget (mainwindow, "rstentry");
  myrstentry = lookup_widget (mainwindow, "myrstentry");
  remarksentry = lookup_widget (mainwindow, "remarksentry");
  modeoptionmenu = lookup_widget (mainwindow, "modeoptionmenu");
  bandoptionmenu = lookup_widget (mainwindow, "bandoptionmenu");
  outcheckbutton = lookup_widget (mainwindow, "outcheckbutton");
  incheckbutton = lookup_widget (mainwindow, "incheckbutton");
  powerentry = lookup_widget (mainwindow, "powerentry");
  nameentry = lookup_widget (mainwindow, "nameentry");
  qthentry = lookup_widget (mainwindow, "qthentry");
  locatorentry = lookup_widget (mainwindow, "locatorentry");
  unknownentry1 = lookup_widget (mainwindow, "unknownentry1");
  unknownentry2 = lookup_widget (mainwindow, "unknownentry2");

  /* unselect rows in other logs */
  for (i = 0; i < g_list_length (logwindowlist); i++)
    {
      logwindow = g_list_nth_data (logwindowlist, i);
      if ((GTK_CLIST (logwindow->clist)) != GTK_CLIST (clist))
	while (GTK_CLIST (logwindow->clist)->selection)
	  gtk_clist_unselect_all (GTK_CLIST (logwindow->clist));
    }

  column_nr = GTK_CLIST (clist)->columns;
  for (i = 0; i < column_nr; i++)
    {
      widget = gtk_clist_get_column_widget (GTK_CLIST (clist), i);
      gtk_label_get (GTK_LABEL (widget), &label);
      if (!g_strcasecmp (label, "DATE"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (dateentry), entry);
	}
      else if (!g_strcasecmp (label, "GMT"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (gmtentry), entry);
	}
      else if (!g_strcasecmp (label, "CALL"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (callentry), entry);
	}
      else if (!g_strcasecmp (label, "BAND"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (bandentry), entry);
	  if (preferences.bandseditbox == 0)
	    {
	      if (strlen (entry) <= 2)
		bandcopy = g_strdup (entry);
	      else
		bandcopy = finddot (entry);
	      for (;;)
		{
		  if (!bandsplit[bandindex])
		    break;
		  if (g_strcasecmp (bandcopy, bandsplit[bandindex]) == 0)
		    {
		      gtk_option_menu_set_history (GTK_OPTION_MENU
						   (bandoptionmenu),
						   bandindex);
		      break;
		    }
		  bandindex++;
		}
	      g_free (bandcopy);
	    }
	}
      else if (!g_strcasecmp (label, "MODE"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (modeentry), entry);
	  if (preferences.modeseditbox == 0)
	    {
	      for (;;)
		{
		  if (!modesplit[modeindex])
		    break;
		  if (g_strcasecmp (entry, modesplit[modeindex]) == 0)
		    {
		      gtk_option_menu_set_history (GTK_OPTION_MENU
						   (modeoptionmenu),
						   modeindex);
		      break;
		    }
		  modeindex++;
		}
	    }
	}
      else if (!g_strcasecmp (label, "POWER"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (powerentry), entry);
	}
      else if (!g_strcasecmp (label, "RST"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (rstentry), entry);
	}
      else if (!g_strcasecmp (label, "MYRST"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (myrstentry), entry);
	}
      else if (!g_strcasecmp (label, "GMTEND"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (endentry), entry);
	}
      else if (!g_strcasecmp (label, "QSLOUT"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  if (!g_strcasecmp (entry, "x") || !g_strcasecmp (entry, "y"))
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outcheckbutton),
					  TRUE);
	  else
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outcheckbutton),
					  FALSE);
	}
      else if (!g_strcasecmp (label, "QSLIN"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  if (!g_strcasecmp (entry, "x") || !g_strcasecmp (entry, "y"))
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton),
					  TRUE);
	  else
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton),
					  FALSE);
	}
      else if (!g_strcasecmp (label, "NAME"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (nameentry), entry);
	}
      else if (!g_strcasecmp (label, "QTH"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (qthentry), entry);
	}
      else if (!g_strcasecmp (label, "LOCATOR"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (locatorentry), entry);
	}
      else if (!g_strcasecmp (label, preferences.freefield1))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (unknownentry1), entry);
	}
      else if (!g_strcasecmp (label, preferences.freefield2))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (unknownentry2), entry);
	}
      else if (!g_strcasecmp (label, "REMARKS"))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), row, i, &entry);
	  gtk_entry_set_text (GTK_ENTRY (remarksentry), entry);
	}
    }

  gtk_clist_get_text (GTK_CLIST (clist), row, NR, &entry);
  qsoframe = lookup_widget (mainwindow, "qsoframe");
  frametext = g_strdup_printf ("QSO %s", entry);
  gtk_frame_set_label (GTK_FRAME (qsoframe), frametext);
  g_free (frametext);
}
