# Dependencies and Licenses

There are

- External dependencies as linkable libraries or externally installed headers, and
- Internal dependencies as the part of code from external libraries
  backported/copied in main repo.

Both these dependencies are listed here:

## Internal dependencies

- [nostd::variant](/api/include/opentelemetry/nostd/internal/absl/types/variant.h):
  This is backported from [Abseil C++
  libraries](https://github.com/abseil/abseil-cpp) and used as default variant
  implementation. License: `Apache License 2.0`
- [TraceLoggingDynamic](/exporters/etw/include/opentelemetry/exporters/etw/TraceLoggingDynamic.h):
  Dynamic TraceLogging Provider API for C++ used by ETW exporter. License: `MIT License`

## External dependencies

- [API](/api)
  &
  [SDK](/sdk):
  - Uses Standard C++ library for latest features (std::string_view,
    std::variant, std::span, std::shared_ptr, std::unique_ptr) with  C++14/17/20
    compiler if cmake option `WITH_STL` is enabled
    or macro `OPENTELEMETRY_STL_VERSION` is defined.
    License: `GNU General Public License`
    - For C++14/17 compilers, fallback to gsl::span if [GSL C++
      library](https://github.com/microsoft/GSL) is installed. License: `MIT
      License`
    - libc++ 14.0.0 do not support construct std::span from a range or container
      .We don't use the std::span in this situation.Users can also define
      `OPENTELEMETRY_OPTION_USE_STD_SPAN=0` to indicate nostd:span will always
      not be a alias for std::span.
  - Uses Abseil C++ Library for `absl::variant` as default `nostd::variant` if
    `WITH_ABSEIL` cmake option (always enabled with bazel)
    License: `Apache License 2.0`

- [OTLP/HTTP+JSON](/exporters/otlp)
  exporter:
  - [protobuf](https://github.com/protocolbuffers/protobuf):  Library to
    serialize structured data.
    - OTLP messages are constructed as protobuf payloads.
    - `protoc` compiler is used to generate C++ stubs for proto files provided
      by `opentelemetry-proto`.
    - `libprotobuf` library is used for generating serialized trace/metrics/log
      data to be sent to opentelemetry collector.
    - License: The library is licensed
      [here](https://github.com/protocolbuffers/protobuf/blob/master/LICENSE).
      The  code generated by protoc compiler is owned by the owner of `.proto`
      file.
  - [libcurl](https://curl.se/libcurl/) : the multiprotocol file transfer
    library.
    - Export connects with opentelemetry collector over HTTP protocol using
      libcurl library
    - License: Inspired by `MIT/X` but not same.
      <https://curl.se/docs/copyright.html>
  - [nlohmann/json](https://github.com/nlohmann/json): JSON for Modern C++.
    - protobuf serialized otlp messages are encoded in JSON format using this
      library.
    - License: `MIT License`
  - [zlib](https://www.zlib.net/): A Massively Spiffy Yet Delicately
    Unobtrusive Compression Library.
    - The `http_client` utilizes zlib to compress the message body and send
      it in gzip format.
    - License: The library is licensed
      [here](https://www.zlib.net/zlib_license.html)

- [OTLP/gRPC](/exporters/otlp)
  exporter:
  - `protobuf`  OTLP messages are constructed as protobuf payloads.
  - [gRPC](https://github.com/grpc/grpc): An RPC library and framework
    - Exporter communicates with OTLP collector using gRPC transport mechanism.
    - License: `Apache License 2.0`

- [Zipkin](/exporters/zipkin)
  exporter:
  - `libcurl` for connecting with Zipkin server over HTTP protocol.
  - `nlohmann/json` for encoding Zipkin messages.

- [ETW](/exporters/etw)
  exporter:
  - `nlohmann/json` for generating MessagePack serialization for message to be
    transmitted to ETW.

- [Prometheus](/exporters/prometheus)
  exporter:
  - [`prometheus-cpp`](https://github.com/jupp0r/prometheus-cpp) Prometheus
    Client Library for Modern C++
    - License: `MIT License`

- [ElasticSearch](/exporters/elasticsearch)
  exporter:
  - `libcurl` for connecting with Elasticsearch server over HTTP protocol.
  - `nlohmann/json` for encoding Elastic Search messages.

- [Opentracing](/opentracing-shim)
  shim:
  - [`opentracing-cpp`](https://github.com/opentracing/opentracing-cpp)
    OpenTracing API for C++
    - A bridge layer implementing the OpenTracing API using the OpenTelemetry API
    - License: `Apache License 2.0`
