# Node Foundation TSC Meeting 2015-07-01

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-07-01
* **GitHub Issue**: https://github.com/nodejs/node-convergence-archive/issues/60
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1TN3Ks0fC4ciY3jeS0VxXxXRkT_dq8-tfs-bWQqZGRoE

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests prior to meeting.

### nodejs/io.js

* Policy for PR blocking? [#2078](https://github.com/nodejs/io.js/issues/2078)
* International WG
* lts: strawman LTS cycle [lts#13](https://github.com/nodejs/LTS/pull/13) / Proposal: Release Process [#1997](https://github.com/nodejs/io.js/issues/1997)

## Minutes

### Present

* James Snell (TSC)
* Bert Belder (TSC)
* Steven Loomis (TSC)
* Chris Dickinson (TSC)
* Mikeal Rogers
* Trevor Norris (TSC)
* Brian White (TSC)
* Jeremiah Senkpiel (TSC)

### Review of the previous meeting

* discussion of stability for internal APIs [#2030](https://github.com/nodejs/io.js/issues/2030)
* Nominating new collaborators to this repository [#25481](https://github.com/joyent/node/issues/25481)
* Use something that’s not uberconference ?

### Standup:

* James: continued triaging of joyent/node issues, working on the LTS strawman proposal
* Bert: not much on node, some minor libuv and installer stuff
* Steven: Intl WG work
* Chris: Not too much on node, working on docs tooling
* Mikeal: working on a conferencing solution / replacement
* Trevor: webassembly discussion, api wg
* Brian: not much, triaging io.js issues and PRs
* Jeremiah: reviewing PRs and issues, more work on `_unrefActive()`
* Rod: busy week, worked on the build & release procedures. New jenkins job for all the types of release builds. v3.0.0 is now blocked on NAN. It’s a very big job. Node-gyp in `next` now works for rc’s and nightlies, and downloads a tarball of just the headers. First LTS WG meeting was also productive.


### Policy for PR blocking? [#2078](https://github.com/nodejs/io.js/issues/2078)

* Steven Belanger tagged this issue: can we come up with a policy for dealing with PRs that block each other?
* James clarified that this specific issue was about the url parsing changes, there were a couple of PRs that blocked each other
* Chris: the PRs here are a “hot stove” situation where they all break url functionality so they are not trivial
* Chris listed some of the blocking issues that are mainly held up because people are too busy so we probably need a way to communicate status to the community
* James: would like to table this issue until it really becomes a problem
* Bert: we could introduce some workflows - e.g. if you introduce an issue that is blocked on something else then you could mention that it’s blocked
* Jeremiah: more relevant to communicate when things are in the pipeline and provide feedback for timelines so people are reasonably blocked but can be unblocked if there is no activity
* Rod: doesn’t feel like something that needs a policy, perhaps it’s an open source 101 skill
* Mikeal: the problem is that often people who are blocking each other don’t have context so need shepherding by someone with context.
* Rod: doesn’t seem like there’s actionable items here, come back when there’s something more concrete to discuss
* Bert: the workers PR has stalled because of Petka’s lack of time, anything that it’s blocking should just move forward, url changes are unlikely to get in as they are now because they are so _breaking_

### Internationalization WG (Steven)

* https://github.com/nodejs/internationalization (repo)
* https://github.com/nodejs/internationalization/issues/4 (README)
* https://github.com/nodejs/internationalization/issues/5 (CFP)

* Steven introduced the work towards getting this set up
* Steven clarified the scope of the work (this is done in the README), it’s different to outreach and user assistance (i.e. the i18n translation stuff that io.js already has).
* Jeremiah suggested we name the group after `Intl` so it’s clearer what it’s about.
* James: It’s about Intl stuff in the code, unicode, REPL dying because of bad unicode
* Mikeal: We’ve talked about starting a formal translation/language group that unifies all of the independent translation efforts. That’s probably why people are showing up for this group thinking it’s the translation group that we’ve talked about setting up. We should set up that separate group and maybe use `Intl` as the name for this separate group.
* Bikeshedded naming for a little while.
* Conclusion: rename as the Intl WG or similar for clarity. (renamed to Intl)


### lts: strawman LTS cycle [lts#13](https://github.com/nodejs/LTS/pull/13) / Proposal: Release Process [#1997](https://github.com/nodejs/io.js/issues/1997)

* James walked through the LTS strawman proposal as formulated by the LTS WG
* Lots of bikeshedding about releases and LTS trivia
* Mikeal: we can probably move the release discussion to a formal proposal

### Next Meeting

July 8th 2015
